/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
/**
 * 
 */
package org.jboss.identity.idm.api;

/**
 * Represents a Group. Group has a name that is unique in scope of a given group type. This means that groupType/name pairs
 * uniquely identifies group. Group Id contains encoded group type and name imformation. In default implementation
 * it can look as follows: "group:/GROUP_TYPE/GROUP_NAME". Still prefix and format of Id can change in the future so
 * PersistenceManager.createGroupId(String groupName, String groupType) method should be used to create it.
 * 
 * @author Anil.Saldhana@redhat.com
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @since Jul 9, 2008
 */
public interface Group extends IdentityType
{

   /**
    * @return the name of the Group
    */
   String getName();

   /**
    * @return group type name
    */
   String getGroupType();



}