/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.identity.idm.api;

import org.jboss.identity.idm.common.exception.IdentityException;

import java.io.InputStream;

/**
 * All operations connected with realms.
 * Because operations on realms are not often there is no transaction or session support.
 *
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
public interface RealmManager
{


   /**
    * <p>Create a Realm or return an already
    * created realm. Bootstrapping includes generating
    * the models in the realm</p>
    * @param realmName
    * @return
    */
   Realm bootstrap(String realmName) throws IdentityException;

   /**
    * <p>Bootstrap a realm given a configuration</p>
    * @param realmName
    * @param config
    * @return
    */
   Realm bootstrap(String realmName, InputStream config) throws IdentityException;

    /**
    * <p>Associate a relationship between two realms</p>
    * @param realmA
    * @param realmB
     */
   void associate(Realm realmA, Realm realmB) throws IdentityException;


   /**
    * <p>Disassociate a relationship between two realms</p>
    * @param realmA
    * @param realmB
    */
   void disassociate(Realm realmA, Realm realmB) throws IdentityException;

   /**
    * @param fromRealm
    * @param toRealm
    * @return returns a relationship type between this and given Realm.
    */
   boolean isAssosiated(Realm fromRealm, Realm toRealm) throws IdentityException;

   /**
    * <p>Return a realm</p>
    * @param realmName
    * @param shouldBootstrap Should we bootstrap if a realm does not exist?
    * @return
    */
   Realm getRealm(String realmName, boolean shouldBootstrap) throws IdentityException;

}
