/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.identity.idm.api.query;

import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.SortOrder;

import java.util.Collection;

/**
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
public interface UserQueryBuilder extends QueryBuilder
{
   
   UserQuery createQuery();

   UserQueryBuilder reset();

   UserQueryBuilder withUserId(String id);

   UserQueryBuilder addAssociatedGroup(Group group);

   UserQueryBuilder addAssociatedGroup(String id);

   UserQueryBuilder addAssociatedGroups(Collection<Group> groups);

   UserQueryBuilder addAssociatedGroupsIds(Collection<String> groups);

   UserQueryBuilder addGroupConnectedWithRole(Group group);

   UserQueryBuilder addGroupConnectedWithRole(String id);

   UserQueryBuilder addGroupsConnectedWithRole(Collection<Group> groups);

   UserQueryBuilder addGroupsIdsConnectedWithRole(Collection<String> groups);

   UserQueryBuilder addRelatedGroup(Group group);

   UserQueryBuilder addRelatedGroup(String id);

   UserQueryBuilder addRelatedGroups(Collection<Group> group);

   UserQueryBuilder addRelatedGroupsIds(Collection<String> ids);

   UserQueryBuilder sort(SortOrder order) throws UnsupportedQueryCriterium;

   UserQueryBuilder sortAttributeName(String name) throws UnsupportedQueryCriterium;

   UserQueryBuilder page(int firstResult, int maxResults) throws UnsupportedQueryCriterium;

   UserQueryBuilder attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium;

   UserQueryBuilder idFilter(String idFilter) throws UnsupportedQueryCriterium;

}
