/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.identity.idm.impl.model.hibernate;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.JoinColumn;
import javax.persistence.UniqueConstraint;
import javax.persistence.FetchType;
import javax.persistence.JoinTable;
import javax.persistence.Column;

import org.jboss.identity.idm.spi.model.IdentityObjectRelationship;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationshipType;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObject;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectRelationshipType;
import org.hibernate.annotations.CollectionOfElements;

import java.util.Map;
import java.util.HashMap;

/**
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
@Entity
@Table(name="jbid_io_rel", uniqueConstraints = {@UniqueConstraint(columnNames = {"NAME", "TYPE", "FROM_IDENTITY", "TO_IDENTITY"})})
public class HibernateIdentityObjectRelationship implements IdentityObjectRelationship
{
   public static final String findIdentityObjectRelationshipsByType =
      "select r from HibernateIdentityObjectRelationship r where r.type.name like :typeName";

   public static final String findIdentityObjectRelationshipNamesByType =
     "select r.name from HibernateIdentityObjectRelationship r where r.type.name like :typeName";


   @Id
   @GeneratedValue
   private Long id;

   @ManyToOne
   @JoinColumn(nullable = true, unique = false, name="NAME")
   private HibernateIdentityObjectRelationshipName name;

   @ManyToOne
   @JoinColumn(nullable = false, name="TYPE")
   private HibernateIdentityObjectRelationshipType type;

   @ManyToOne(fetch = FetchType.EAGER)
   @JoinColumn(nullable = false, name="FROM_IDENTITY")
   private HibernateIdentityObject fromIdentityObject;

   @ManyToOne(fetch = FetchType.EAGER)
   @JoinColumn(nullable = false, name="TO_IDENTITY")
   private HibernateIdentityObject toIdentityObject;

   @CollectionOfElements
   @JoinTable(name = "jbid_io_rel_props", joinColumns = @JoinColumn(name = "REALATIONSHIP_ID", nullable=false))
   @org.hibernate.annotations.MapKey(columns = @Column(name = "prop_key", nullable=false))
   @Column(name = "PROPERTY")
   private Map<String, String> properties = new HashMap<String, String>();

   public HibernateIdentityObjectRelationship()
   {
   }

   public HibernateIdentityObjectRelationship(HibernateIdentityObjectRelationshipType type, HibernateIdentityObject fromIdentityObject, HibernateIdentityObject toIdentityObject)
   {
      this.type = type;
      this.fromIdentityObject = fromIdentityObject;
      fromIdentityObject.getFromRelationships().add(this);
      this.toIdentityObject = toIdentityObject;
      toIdentityObject.getToRelationships().add(this);
   }

   public HibernateIdentityObjectRelationship(HibernateIdentityObjectRelationshipType type, HibernateIdentityObject fromIdentityObject, HibernateIdentityObject toIdentityObject, HibernateIdentityObjectRelationshipName name)
   {
      this.type = type;
      this.fromIdentityObject = fromIdentityObject;
      fromIdentityObject.getFromRelationships().add(this);
      this.toIdentityObject = toIdentityObject;
      toIdentityObject.getToRelationships().add(this);
      this.name = name;
   }

   public Long getId()
   {
      return id;
   }

   public void setId(Long id)
   {
      this.id = id;
   }

   public IdentityObjectRelationshipType getType()
   {
      return type;
   }

   public void setType(HibernateIdentityObjectRelationshipType type)
   {
      this.type = type;
   }

   public HibernateIdentityObject getFromIdentityObject()
   {
      return fromIdentityObject;
   }

   public void setFromIdentityObject(HibernateIdentityObject fromIdentityObject)
   {
      this.fromIdentityObject = fromIdentityObject;
   }

   public HibernateIdentityObject getToIdentityObject()
   {
      return toIdentityObject;
   }

   public void setToIdentityObject(HibernateIdentityObject toIdentityObject)
   {
      this.toIdentityObject = toIdentityObject;
   }

   public String getName()
   {
      if (name != null)
      {
         return name.getName();
      }
      return null;
   }

   public void setName(HibernateIdentityObjectRelationshipName name)
   {
      this.name = name;
   }

   public Map<String, String> getProperties()
   {
      return properties;
   }

   public void setProperties(Map<String, String> properties)
   {
      this.properties = properties;
   }
}
