/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.identity.idm.spi.cache;

import org.jboss.identity.idm.spi.model.IdentityObjectAttribute;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationshipType;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationship;
import org.jboss.identity.idm.spi.search.IdentityObjectSearchCriteria;

import java.util.Map;
import java.util.Collection;
import java.util.Set;

public interface IdentityStoreCacheProvider
{
  
   void initResidentNodes(Set<String> supportedIdentityObjectTypes,
                                    Set<String> supportedRelationshipTypes);

   void putIntoCache(IdentityObject io);

   void putIntoCache(IdentityObject io, Map<String, IdentityObjectAttribute> attributesMap);

   void removeFromCache(IdentityObject io);

   void removeAttributesFromCache(IdentityObject io);

   IdentityObject getFromCache(String name, IdentityObjectType identityObjectType);

   Map<String, IdentityObjectAttribute> getAttributesFromCache(String name, IdentityObjectType identityObjectType);

   IdentityObject getFromCache(String id);

   void putIdentityObjectSearchIntoCache(IdentityObjectType identityType,
                                         IdentityObjectSearchCriteria criteria,
                                         Collection<IdentityObject> results);

   Collection<IdentityObject> getIdentityObjectSearchFromCache(IdentityObjectType identityType,
                                                               IdentityObjectSearchCriteria criteria);

   void putIdentityObjectSearchToCache(IdentityObject identity,
                                       IdentityObjectRelationshipType relationshipType,
                                       boolean parent,
                                       IdentityObjectSearchCriteria criteria,
                                       Collection<IdentityObject> results);

   Collection<IdentityObject> getIdentityObjectSearchFromCache(IdentityObject identity,
                                                               IdentityObjectRelationshipType relationshipType,
                                                               boolean parent,
                                                               IdentityObjectSearchCriteria criteria);

   void putRelationshipsSearchIntoCache(IdentityObject fromIdentity,
                                        IdentityObject toIdentity,
                                        IdentityObjectRelationshipType relationshipType,
                                        Set<IdentityObjectRelationship> results);

   Set<IdentityObjectRelationship> getRelationshipsSearchFromCache(IdentityObject fromIdentity,
                                                                   IdentityObject toIdentity,
                                                                   IdentityObjectRelationshipType relationshipType);

   void putRelationshipSearchIntoCache(IdentityObject identity,
                                       IdentityObjectRelationshipType relationshipType,
                                       boolean parent,
                                       boolean named,
                                       String name,
                                       Set<IdentityObjectRelationship> results);

   Set<IdentityObjectRelationship> getRelationshipsSearchFromCache(IdentityObject identity,
                                                                   IdentityObjectRelationshipType relationshipType,
                                                                   boolean parent,
                                                                   boolean named,
                                                                   String name);

   void invalidateCachedIdentityObjectSearches(IdentityObject io);

   void putIdentityObjectCountIntoCache(IdentityObjectType identityType, int count);

   int getIdentityObjectCountFromCache(IdentityObjectType identityType);

   void invalidateCachedIdentityObjectCount(IdentityObjectType identityType);

   void invalidateCachedRelationshipSearches(IdentityObject fromIdentity,
                                             IdentityObject toIdentity,
                                             IdentityObjectRelationshipType relationshipType,
                                             String relationshipName);

   void invalidateCachedRelationshipSearches(IdentityObject identity1, IdentityObject identity2, boolean named);

   void invalidateRelationshipNameSearches(String name);

   void putRelationshipNamesSearchIntoCache(IdentityObjectSearchCriteria criteria, Set<String> results);

   Set<String> getRelationshipNamesSearchFromCache(IdentityObjectSearchCriteria criteria);

   void putRelationshipNamesSearchIntoCache(IdentityObject identity,
                                            IdentityObjectSearchCriteria criteria,
                                            Set<String> results);

   Set<String> getRelationshipNamesSearchFromCache(IdentityObject identity, IdentityObjectSearchCriteria criteria);


}
