/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.identity.federation.web.handlers.saml2;

import java.security.Principal;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.jboss.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.jboss.identity.federation.web.constants.GeneralConstants;
import org.jboss.identity.federation.web.core.HTTPContext;
import org.jboss.identity.federation.web.interfaces.RoleGenerator;
import org.jboss.identity.federation.web.roles.DefaultRoleGenerator;

/**
 * Handles the generation of roles
 * @author Anil.Saldhana@redhat.com
 * @since Oct 7, 2009
 */
public class RolesGenerationHandler extends BaseSAML2Handler
{
   private transient RoleGenerator rg = new DefaultRoleGenerator(); 
   
   @Override
   public void init(Map<String, Object> options)
   {
      super.init(options);
      if(options.containsKey("ROLE_GENERATOR"))
      {
         String clazzName = (String) options.get(GeneralConstants.ROLE_GENERATOR);
         ClassLoader tcl = SecurityActions.getContextClassLoader();
         try
         {
            rg = (RoleGenerator) tcl.loadClass(clazzName).newInstance();
         }
         catch(Exception e)
         {
            throw new RuntimeException("Unable to instantiate Role Generator:",e);
         }
         
      }
   }

   @SuppressWarnings("unchecked")
   public void handleRequestType(SAML2HandlerRequest request, 
         SAML2HandlerResponse response) throws ProcessingException
   { 
      //Do not handle log out request interaction
      if(request.getSAML2Object() instanceof LogoutRequestType)
         return ;
      
      //only handle IDP side
      if(request.getType() == SAML2HandlerRequest.HANDLER_TYPE.SP)
         return;
      
      HTTPContext httpContext = (HTTPContext) request.getContext();
      HttpSession session = httpContext.getRequest().getSession(false);
      
      Principal userPrincipal = (Principal) session.getAttribute(GeneralConstants.PRINCIPAL_ID);
      List<String> roles = (List<String>) session.getAttribute(GeneralConstants.ROLES_ID);
      
      if(roles == null) 
      {
         RoleGenerator rg = (RoleGenerator) request.getOptions().get(GeneralConstants.ROLE_GENERATOR);
         roles = rg.generateRoles(userPrincipal);
         session.setAttribute(GeneralConstants.ROLES_ID, roles);
      }
      response.setRoles(roles);
   }

   public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response)
         throws ProcessingException
   { 
   }

   public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response)
         throws ProcessingException
   {
      return;
   }

   public void reset() throws ProcessingException
   {
      // TODO Auto-generated method stub
      
   }
}
