/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.identity.federation.web.util;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.util.Base64;
import org.jboss.identity.federation.core.saml.v2.holders.DestinationInfoHolder;

/**
 * Utility for the HTTP/Post binding
 * @author Anil.Saldhana@redhat.com
 * @since May 22, 2009
 */
public class PostBindingUtil
{
   private static Logger log = Logger.getLogger(PostBindingUtil.class);
   private static boolean trace = log.isTraceEnabled();
   
   public static String base64Encode(String stringToEncode) throws IOException
   {
      return Base64.encodeBytes(stringToEncode.getBytes("UTF-8"), Base64.DONT_BREAK_LINES);
   }

   public static byte[] base64Decode(String encodedString)
   {
      return Base64.decode(encodedString);
   }
   
   /**
    * Send the response to the redirected destination while
    * adding the character encoding of "UTF-8" as well as
    * adding headers for cache-control and Pragma
    * @param destination Destination URI where the response needs to redirect
    * @param response HttpServletResponse
    * @throws IOException
    */
   public static void sendPost(DestinationInfoHolder holder,
         HttpServletResponse response,
         boolean sendToIDP)
   throws IOException 
   {  
      String key = sendToIDP ? "SAMLRequest" : "SAMLResponse";
      
      String relayState = holder.getRelayState();
      String destination = holder.getDestination();
      String samlMessage = holder.getSamlMessage();
      
      if(destination == null)
         throw new IllegalStateException("Destination is null");
      
      response.setContentType("text/html");
      PrintWriter out = response.getWriter();
      common(holder.getDestination(), response);  
      StringBuilder builder = new StringBuilder();
      
      builder.append("<HTML>");
      builder.append("<HEAD>");
      if(sendToIDP)
         builder.append("<TITLE>HTTP Post Binding To Identity Provider</TITLE>");
      else
         builder.append("<TITLE>HTTP Post Binding Response To Service Provider</TITLE>");
      
      builder.append("</HEAD>");
      builder.append("<BODY Onload=\"document.forms[0].submit()\">");
      
      builder.append("<FORM METHOD=\"POST\" ACTION=\"" + destination + "\">");
      builder.append("<INPUT TYPE=\"HIDDEN\" NAME=\""+ key +"\"" + " VALUE=\"" + samlMessage 
            + "\"/>");
      if (relayState != null && relayState.length() > 0) 
      {
         builder.append("<INPUT TYPE=\"HIDDEN\" NAME=\"RelayState\" " +
              "VALUE=\"" + relayState + "\"/>");
      }  
      builder.append("</FORM></BODY></HTML>"); 
      
      String str = builder.toString();
      if(trace)
         log.trace(str);
      out.println(str);
      out.close(); 
   } 
   
   private static void common(String destination, HttpServletResponse response)
   {
      response.setCharacterEncoding("UTF-8");  
      response.setHeader("Pragma", "no-cache");
      response.setHeader("Cache-Control", "no-cache, no-store");  
   } 
}