/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.config.IDPType;
import org.jboss.identity.federation.core.config.KeyProviderType;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.handler.config.Handlers;
import org.jboss.identity.federation.core.impl.DelegatedAttributeManager;
import org.jboss.identity.federation.core.interfaces.AttributeManager;
import org.jboss.identity.federation.core.interfaces.ProtocolContext;
import org.jboss.identity.federation.core.interfaces.TrustKeyConfigurationException;
import org.jboss.identity.federation.core.interfaces.TrustKeyManager;
import org.jboss.identity.federation.core.interfaces.TrustKeyProcessingException;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssueInstantMissingException;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.jboss.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.jboss.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChain;
import org.jboss.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerRequest;
import org.jboss.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerResponse;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.jboss.identity.federation.core.saml.v2.util.HandlerUtil;
import org.jboss.identity.federation.saml.v2.SAML2Object;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.StatusResponseType;
import org.jboss.identity.federation.web.core.HTTPContext;
import org.jboss.identity.federation.web.interfaces.RoleGenerator;
import org.jboss.identity.federation.web.roles.DefaultRoleGenerator;
import org.jboss.identity.federation.web.servlets.SecurityActions;
import org.jboss.identity.federation.web.util.ConfigurationUtil;
import org.jboss.identity.federation.web.util.IDPWebRequestUtil;
import org.jboss.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.w3c.dom.Document;

public class IDPServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(IDPServlet.class);
    private boolean trace = log.isTraceEnabled();
    protected transient IDPType idpConfiguration = null;
    private transient RoleGenerator rg = new DefaultRoleGenerator();
    private transient DelegatedAttributeManager attribManager = new DelegatedAttributeManager();
    private List<String> attributeKeys = new ArrayList<String>();
    private long assertionValidity = 5000L;
    private String identityURL = null;
    private transient TrustKeyManager keyManager;
    private Boolean ignoreIncomingSignatures = true;
    private Boolean signOutgoingMessages = true;
    private transient ServletContext context = null;
    private transient SAML2HandlerChain chain = null;

    public Boolean getIgnoreIncomingSignatures() {
        return this.ignoreIncomingSignatures;
    }

    public void init(ServletConfig config) throws ServletException {
        String attribList;
        String rgString;
        Handlers handlers = null;
        super.init(config);
        String configFile = "/WEB-INF/jboss-idfed.xml";
        this.context = config.getServletContext();
        InputStream is = this.context.getResourceAsStream(configFile);
        if (is == null) {
            throw new RuntimeException(configFile + " missing");
        }
        this.chain = new DefaultSAML2HandlerChain();
        try {
            this.idpConfiguration = ConfigurationUtil.getIDPConfiguration(is);
            this.identityURL = this.idpConfiguration.getIdentityURL();
            log.trace((Object)("Identity Provider URL=" + this.identityURL));
            this.assertionValidity = this.idpConfiguration.getAssertionValidity();
            String attributeManager = this.idpConfiguration.getAttributeManager();
            if (attributeManager != null && !"".equals(attributeManager)) {
                ClassLoader tcl = SecurityActions.getContextClassLoader();
                AttributeManager delegate = (AttributeManager)tcl.loadClass(attributeManager).newInstance();
                this.attribManager.setDelegate(delegate);
            }
            handlers = ConfigurationUtil.getHandlers(this.context.getResourceAsStream("/WEB-INF/jbid-handlers.xml"));
            this.chain.addAll((Collection)HandlerUtil.getHandlers((Handlers)handlers));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String signOutgoingString = config.getInitParameter("SIGN_OUTGOING_MESSAGES");
        if (signOutgoingString != null && !"".equals(signOutgoingString)) {
            this.signOutgoingMessages = Boolean.parseBoolean(signOutgoingString);
        }
        if (this.signOutgoingMessages.booleanValue()) {
            KeyProviderType keyProvider = this.idpConfiguration.getKeyProvider();
            if (keyProvider == null) {
                throw new RuntimeException("Key Provider is null for context=" + this.context.getContextPath());
            }
            try {
                ClassLoader tcl = SecurityActions.getContextClassLoader();
                String keyManagerClassName = keyProvider.getClassName();
                if (keyManagerClassName == null) {
                    throw new RuntimeException("KeyManager class name is null");
                }
                Class<?> clazz = tcl.loadClass(keyManagerClassName);
                this.keyManager = (TrustKeyManager)clazz.newInstance();
                this.keyManager.setAuthProperties(keyProvider.getAuth());
                this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            }
            catch (Exception e) {
                log.error((Object)"Exception reading configuration:", (Throwable)e);
                throw new RuntimeException(e.getLocalizedMessage());
            }
            if (this.trace) {
                log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
            }
        }
        if ((rgString = config.getInitParameter("ROLE_GENERATOR")) != null && !"".equals(rgString)) {
            this.setRoleGenerator(rgString);
        }
        if ((attribList = config.getInitParameter("ATTRIBUTE_KEYS")) != null && !"".equals(attribList)) {
            StringTokenizer st = new StringTokenizer(attribList, ",");
            while (st != null && st.hasMoreTokens()) {
                this.attributeKeys.add(st.nextToken());
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession(false);
        String samlRequestMessage = (String)session.getAttribute("SAMLRequest");
        String samlResponseMessage = (String)session.getAttribute("SAMLResponse");
        String relayState = (String)session.getAttribute("RelayState");
        String referer = request.getHeader("Referer");
        Principal userPrincipal = (Principal)session.getAttribute("jboss_identity.principal");
        if (userPrincipal == null) {
            if (this.trace) {
                log.trace((Object)"Login Filters have not been configured");
            }
            response.sendError(500);
        }
        IDPWebRequestUtil webRequestUtil = new IDPWebRequestUtil(request, this.idpConfiguration, this.keyManager);
        webRequestUtil.setAttributeManager((AttributeManager)this.attribManager);
        webRequestUtil.setAttributeKeys(this.attributeKeys);
        if (userPrincipal != null) {
            block43: {
                Document samlResponse;
                String destination;
                block42: {
                    if (this.trace) {
                        log.trace((Object)"Retrieved saml message and relay state from session");
                        log.trace((Object)("saml Request message=" + samlRequestMessage + "::relay state=" + relayState));
                        log.trace((Object)("saml Response message=" + samlResponseMessage + "::relay state=" + relayState));
                    }
                    session.removeAttribute("SAMLRequest");
                    session.removeAttribute("SAMLResponse");
                    if (relayState != null && relayState.length() > 0) {
                        session.removeAttribute("RelayState");
                    }
                    SAML2Object samlObject = null;
                    destination = null;
                    samlResponse = null;
                    if (samlResponseMessage != null) {
                        StatusResponseType statusResponseType = null;
                        try {
                            samlObject = webRequestUtil.getSAMLObject(samlResponseMessage);
                            boolean isPost = webRequestUtil.hasSAMLRequestInPostProfile();
                            boolean isValid = this.validate(request.getRemoteAddr(), request.getQueryString(), new SessionHolder(samlResponseMessage, null), isPost);
                            if (!isValid) {
                                throw new GeneralSecurityException("Validation check failed");
                            }
                            String issuer = null;
                            IssuerInfoHolder idpIssuer = new IssuerInfoHolder(this.identityURL);
                            HTTPContext protocolContext = new HTTPContext(request, response, this.context);
                            DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest((ProtocolContext)protocolContext, idpIssuer.getIssuer(), samlObject, SAML2HandlerRequest.HANDLER_TYPE.IDP);
                            saml2HandlerRequest.setRelayState(relayState);
                            HashMap<String, RoleGenerator> requestOptions = new HashMap<String, RoleGenerator>();
                            requestOptions.put("ROLE_GENERATOR", this.rg);
                            saml2HandlerRequest.setOptions(requestOptions);
                            DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
                            Set handlers = this.chain.handlers();
                            if (samlObject instanceof StatusResponseType) {
                                statusResponseType = (StatusResponseType)samlObject;
                                issuer = statusResponseType.getIssuer().getValue();
                                webRequestUtil.isTrusted(issuer);
                                if (handlers != null) {
                                    for (SAML2Handler handler : handlers) {
                                        handler.handleStatusResponseType((SAML2HandlerRequest)saml2HandlerRequest, (SAML2HandlerResponse)saml2HandlerResponse);
                                    }
                                }
                            } else {
                                throw new RuntimeException("Unknown type:" + samlObject.getClass().getName());
                            }
                            samlResponse = saml2HandlerResponse.getResultingDocument();
                            relayState = saml2HandlerResponse.getRelayState();
                            destination = saml2HandlerResponse.getDestination();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (samlRequestMessage != null) {
                        RequestAbstractType requestAbstractType = null;
                        Object statusResponseType = null;
                        try {
                            samlObject = webRequestUtil.getSAMLObject(samlRequestMessage);
                            boolean isPost = webRequestUtil.hasSAMLRequestInPostProfile();
                            boolean isValid = this.validate(request.getRemoteAddr(), request.getQueryString(), new SessionHolder(samlRequestMessage, null), isPost);
                            if (!isValid) {
                                throw new GeneralSecurityException("Validation check failed");
                            }
                            String issuer = null;
                            IssuerInfoHolder idpIssuer = new IssuerInfoHolder(this.identityURL);
                            HTTPContext protocolContext = new HTTPContext(request, response, this.context);
                            DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest((ProtocolContext)protocolContext, idpIssuer.getIssuer(), samlObject, SAML2HandlerRequest.HANDLER_TYPE.IDP);
                            saml2HandlerRequest.setRelayState(relayState);
                            HashMap<String, Object> requestOptions = new HashMap<String, Object>();
                            requestOptions.put("ROLE_GENERATOR", this.rg);
                            requestOptions.put("ASSERTIONS_VALIDITY", this.assertionValidity);
                            requestOptions.put("CONFIGURATION", this.idpConfiguration);
                            Map attribs = this.attribManager.getAttributes(userPrincipal, this.attributeKeys);
                            requestOptions.put("ATTRIBUTES", attribs);
                            saml2HandlerRequest.setOptions(requestOptions);
                            List<String> roles = (List<String>)session.getAttribute("jboss_identity.roles");
                            if (roles == null) {
                                roles = this.rg.generateRoles(userPrincipal);
                                session.setAttribute("jboss_identity.roles", roles);
                            }
                            DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
                            Set handlers = this.chain.handlers();
                            if (samlObject instanceof RequestAbstractType) {
                                requestAbstractType = (RequestAbstractType)samlObject;
                                issuer = requestAbstractType.getIssuer().getValue();
                                webRequestUtil.isTrusted(issuer);
                                if (handlers != null) {
                                    for (SAML2Handler handler : handlers) {
                                        handler.handleRequestType((SAML2HandlerRequest)saml2HandlerRequest, (SAML2HandlerResponse)saml2HandlerResponse);
                                    }
                                }
                            } else {
                                throw new RuntimeException("Unknown type:" + samlObject.getClass().getName());
                            }
                            samlResponse = saml2HandlerResponse.getResultingDocument();
                            relayState = saml2HandlerResponse.getRelayState();
                            destination = saml2HandlerResponse.getDestination();
                        }
                        catch (IssuerNotTrustedException e) {
                            if (this.trace) {
                                log.trace((Object)e);
                            }
                            samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get(), this.identityURL, this.signOutgoingMessages);
                        }
                        catch (ParsingException e) {
                            if (this.trace) {
                                log.trace((Object)e);
                            }
                            samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages);
                        }
                        catch (ConfigurationException e) {
                            if (this.trace) {
                                log.trace((Object)e);
                            }
                            samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages);
                        }
                        catch (IssueInstantMissingException e) {
                            if (this.trace) {
                                log.trace((Object)e);
                            }
                            samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages);
                        }
                        catch (GeneralSecurityException e) {
                            if (this.trace) {
                                log.trace((Object)e);
                            }
                            samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages);
                        }
                    } else {
                        log.error((Object)"No SAML Request Message");
                        if (this.trace) {
                            log.trace((Object)("Referer=" + referer));
                        }
                        try {
                            this.sendErrorResponseToSP(referer, response, relayState, webRequestUtil);
                            return;
                        }
                        catch (ConfigurationException e) {
                            if (!this.trace) break block42;
                            log.trace((Object)e);
                        }
                    }
                }
                try {
                    if (samlResponse == null) {
                        throw new ServletException("SAML Response has not been generated");
                    }
                    if (this.signOutgoingMessages.booleanValue()) {
                        webRequestUtil.send(samlResponse, destination, relayState, response, true, this.keyManager.getSigningKey());
                    } else {
                        webRequestUtil.send(samlResponse, destination, relayState, response, false, null);
                    }
                }
                catch (ParsingException e) {
                    if (this.trace) {
                        log.trace((Object)e);
                    }
                }
                catch (GeneralSecurityException e) {
                    if (!this.trace) break block43;
                    log.trace((Object)e);
                }
            }
            return;
        }
    }

    protected void sendErrorResponseToSP(String referrer, HttpServletResponse response, String relayState, IDPWebRequestUtil webRequestUtil) throws ServletException, IOException, ConfigurationException {
        if (this.trace) {
            log.trace((Object)("About to send error response to SP:" + referrer));
        }
        Document samlResponse = webRequestUtil.getErrorResponse(referrer, JBossSAMLURIConstants.STATUS_RESPONDER.get(), this.identityURL, this.signOutgoingMessages);
        try {
            if (this.signOutgoingMessages.booleanValue()) {
                webRequestUtil.send(samlResponse, referrer, relayState, response, true, this.keyManager.getSigningKey());
            } else {
                webRequestUtil.send(samlResponse, referrer, relayState, response, false, null);
            }
        }
        catch (ParsingException e1) {
            throw new ServletException((Throwable)e1);
        }
        catch (GeneralSecurityException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    protected boolean validate(String remoteAddress, String queryString, SessionHolder holder, boolean isPost) throws IOException, GeneralSecurityException {
        if (holder.samlRequest == null || holder.samlRequest.length() == 0) {
            return false;
        }
        if (!this.ignoreIncomingSignatures.booleanValue() && !isPost) {
            PublicKey validatingKey;
            String sig = holder.signature;
            if (sig == null || sig.length() == 0) {
                log.error((Object)("Signature received from SP is null:" + remoteAddress));
                return false;
            }
            byte[] sigValue = RedirectBindingSignatureUtil.getSignatureValueFromSignedURL(queryString);
            if (sigValue == null) {
                return false;
            }
            try {
                validatingKey = this.keyManager.getValidatingKey(remoteAddress);
            }
            catch (TrustKeyConfigurationException e) {
                throw new GeneralSecurityException(e.getCause());
            }
            catch (TrustKeyProcessingException e) {
                throw new GeneralSecurityException(e.getCause());
            }
            return RedirectBindingSignatureUtil.validateSignature(queryString, validatingKey, sigValue);
        }
        return true;
    }

    public void testPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    private void setRoleGenerator(String rgName) {
        try {
            Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(rgName);
            this.rg = (RoleGenerator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static class SessionHolder {
        String samlRequest;
        String signature;

        public SessionHolder(String req, String sig) {
            this.samlRequest = req;
            this.signature = sig;
        }
    }
}

