/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.upgrader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.jca.as.upgrader.Http;
import org.jboss.jca.as.upgrader.MavenMetadata;
import org.jboss.jca.as.upgrader.ModuleXml;

public class Main {
    public static final String RELEASE_REPOSITORY = "http://repository.jboss.org/nexus/content/groups/public/org/jboss/ironjacamar";
    public static final String SNAPSHOT_REPOSITORY = "http://repository.jboss.org/nexus/content/repositories/snapshots/org/jboss/ironjacamar";
    static final String[] API_ARTIFACTS = new String[]{"ironjacamar-common-api", "ironjacamar-common-spi", "ironjacamar-core-api"};
    static final String[] IMPLEMENTATION_ARTIFACTS = new String[]{"ironjacamar-common-impl", "ironjacamar-core-impl", "ironjacamar-deployers-common", "ironjacamar-validator"};
    static final String[] JDBC_ARTIFACTS = new String[]{"ironjacamar-jdbc"};

    public static void main(String[] args) {
        block5: {
            if (args.length == 2) {
                try {
                    String version = args[0];
                    String asPath = args[1];
                    File asRoot = new File(asPath);
                    if (asRoot.exists() && Main.isValid(asRoot)) {
                        System.out.println("Version: " + version);
                        System.out.println("AS installation: " + asPath);
                        System.out.println("");
                        File downloadDirectory = Main.download(version);
                        Main.move(asRoot);
                        Main.install(asRoot, version);
                        Main.delete(downloadDirectory);
                        System.out.println("");
                        System.out.println("Upgrade successful");
                        break block5;
                    }
                    System.err.println("AS installation not found: " + asPath);
                }
                catch (Throwable t) {
                    System.out.println("");
                    System.out.println("Upgrade unsuccessful");
                    System.err.println("Error: " + t.getMessage());
                    t.printStackTrace();
                }
            } else {
                Main.usage();
            }
        }
    }

    private static void usage() {
        System.out.println("Usage: as-upgrader <version> <as-installation>");
    }

    private static boolean isValid(File root) {
        File f = new File(root, "modules" + File.separator + "org" + File.separator + "jboss" + File.separator + "ironjacamar");
        return f.exists();
    }

    private static File download(String version) throws Throwable {
        File toDirectory = new File(System.getProperty("java.io.tmp"), "ij");
        Main.delete(toDirectory);
        if (!toDirectory.mkdirs()) {
            throw new IOException("Could not create: " + toDirectory);
        }
        if (version.endsWith("-SNAPSHOT")) {
            String snapshotVersion;
            for (String artifact : API_ARTIFACTS) {
                snapshotVersion = MavenMetadata.getVersion("http://repository.jboss.org/nexus/content/repositories/snapshots/org/jboss/ironjacamar/" + artifact + "/" + version + "/maven-metadata.xml");
                Main.downloadSnapshotArtifact(artifact, version, snapshotVersion, toDirectory);
            }
            for (String artifact : IMPLEMENTATION_ARTIFACTS) {
                snapshotVersion = MavenMetadata.getVersion("http://repository.jboss.org/nexus/content/repositories/snapshots/org/jboss/ironjacamar/" + artifact + "/" + version + "/maven-metadata.xml");
                Main.downloadSnapshotArtifact(artifact, version, snapshotVersion, toDirectory);
            }
            for (String artifact : JDBC_ARTIFACTS) {
                snapshotVersion = MavenMetadata.getVersion("http://repository.jboss.org/nexus/content/repositories/snapshots/org/jboss/ironjacamar/" + artifact + "/" + version + "/maven-metadata.xml");
                Main.downloadSnapshotArtifact(artifact, version, snapshotVersion, toDirectory);
            }
        } else {
            for (String artifact : API_ARTIFACTS) {
                Main.downloadArtifact(artifact, version, toDirectory);
            }
            for (String artifact : IMPLEMENTATION_ARTIFACTS) {
                Main.downloadArtifact(artifact, version, toDirectory);
            }
            for (String artifact : JDBC_ARTIFACTS) {
                Main.downloadArtifact(artifact, version, toDirectory);
            }
        }
        System.out.println("Download: Done");
        return toDirectory;
    }

    private static void downloadArtifact(String name, String version, File destination) throws Throwable {
        Http downloader = new Http();
        String fileName = name + "-" + version + ".jar";
        String path = "http://repository.jboss.org/nexus/content/groups/public/org/jboss/ironjacamar/" + name + "/" + version + "/" + fileName;
        if (!downloader.download(path, new File(destination, fileName))) {
            throw new IOException("Could not download: " + path);
        }
    }

    private static void downloadSnapshotArtifact(String name, String version, String snapshotVersion, File destination) throws Throwable {
        Http downloader = new Http();
        String fileName = name + "-" + snapshotVersion + ".jar";
        String path = "http://repository.jboss.org/nexus/content/repositories/snapshots/org/jboss/ironjacamar/" + name + "/" + version + "/" + fileName;
        if (!downloader.download(path, new File(destination, fileName))) {
            throw new IOException("Could not download: " + path);
        }
    }

    private static void move(File root) throws Throwable {
        File ijRoot = new File(root, "modules" + File.separator + "org" + File.separator + "jboss" + File.separator + "ironjacamar");
        File apiRoot = new File(ijRoot, "api");
        File implRoot = new File(ijRoot, "impl");
        File jdbcRoot = new File(ijRoot, "jdbcadapters");
        String oldVersion = Main.getVersion(new File(apiRoot, "main"));
        File apiOld = new File(apiRoot, oldVersion);
        Main.delete(apiOld);
        if (!new File(apiRoot, "main").renameTo(apiOld)) {
            throw new IOException("Could not rename old api main");
        }
        File implOld = new File(implRoot, oldVersion);
        Main.delete(implOld);
        if (!new File(implRoot, "main").renameTo(implOld)) {
            throw new IOException("Could not rename old impl main");
        }
        File jdbcOld = new File(jdbcRoot, oldVersion);
        Main.delete(jdbcOld);
        if (!new File(jdbcRoot, "main").renameTo(jdbcOld)) {
            throw new IOException("Could not rename old JDBC main");
        }
        System.out.println("Moving old installation (" + oldVersion + "): Done");
    }

    private static String getVersion(File root) throws Throwable {
        for (File f : root.listFiles()) {
            int jar;
            int firstDot;
            if (!f.isFile() || !f.getName().startsWith("ironjacamar")) continue;
            String name = f.getName();
            String s = name.substring((firstDot = name.indexOf(".")) - 1, jar = name.indexOf(".jar"));
            if (s.indexOf("-") == -1) {
                return s;
            }
            return s.substring(0, s.indexOf("-")) + "-SNAPSHOT";
        }
        throw new IOException("Unable to identify old version");
    }

    private static void delete(File f) throws IOException {
        if (f != null && f.exists()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        Main.delete(files[i]);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    throw new IOException("Could not delete " + files[i]);
                }
            }
            if (!f.delete()) {
                throw new IOException("Could not delete " + f);
            }
        }
    }

    private static void copy(File src, File dest) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException("Src is null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("Dest is null");
        }
        if (!src.exists()) {
            throw new IOException("Source doesn't exist: " + src.getAbsolutePath());
        }
        if (!src.canRead()) {
            throw new IOException("Source can't be read: " + src.getAbsolutePath());
        }
        if (src.isDirectory()) {
            if (!dest.exists() && !dest.mkdirs()) {
                throw new IOException("Could not create directory: " + dest.getAbsolutePath());
            }
            String[] list = src.list();
            for (int i = 0; i < list.length; ++i) {
                File srcFile = new File(src, list[i]);
                File destFile = new File(dest, list[i]);
                Main.copy(srcFile, destFile);
            }
        } else {
            InputStream in = null;
            OutputStream out = null;
            byte[] buffer = new byte[8192];
            try {
                int bytesRead;
                in = new BufferedInputStream(new FileInputStream(src), 8192);
                out = new BufferedOutputStream(new FileOutputStream(dest), 8192);
                while ((bytesRead = in.read(buffer)) >= 0) {
                    out.write(buffer, 0, bytesRead);
                }
                out.flush();
            }
            catch (IOException e) {
                IOException wrapper = new IOException("Unable to copy file: " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
                wrapper.initCause(e);
                wrapper.setStackTrace(e.getStackTrace());
                throw wrapper;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    private static void install(File root, String version) throws Throwable {
        File fromDirectory = new File(System.getProperty("java.io.tmp"), "ij");
        File ijRoot = new File(root, "modules" + File.separator + "org" + File.separator + "jboss" + File.separator + "ironjacamar");
        File apiRoot = new File(ijRoot, "api");
        File implRoot = new File(ijRoot, "impl");
        File jdbcRoot = new File(ijRoot, "jdbcadapters");
        File apiMain = new File(apiRoot, "main");
        if (!apiMain.mkdirs()) {
            throw new IOException("Could not create: " + apiMain);
        }
        String commonApiVersion = Main.installArtifact(fromDirectory, API_ARTIFACTS[0], apiMain);
        String commonSpiVersion = Main.installArtifact(fromDirectory, API_ARTIFACTS[1], apiMain);
        String coreApiVersion = Main.installArtifact(fromDirectory, API_ARTIFACTS[2], apiMain);
        File apiModuleXml = new File(apiMain, "module.xml");
        FileWriter fw = new FileWriter(apiModuleXml);
        for (String s : ModuleXml.getApi(commonApiVersion, commonSpiVersion, coreApiVersion)) {
            fw.write(s);
            fw.write("\n");
        }
        fw.flush();
        fw.close();
        File implMain = new File(implRoot, "main");
        if (!implMain.mkdirs()) {
            throw new IOException("Could not create: " + implMain);
        }
        String commonImplVersion = Main.installArtifact(fromDirectory, IMPLEMENTATION_ARTIFACTS[0], implMain);
        String coreImplVersion = Main.installArtifact(fromDirectory, IMPLEMENTATION_ARTIFACTS[1], implMain);
        String deployersCommonVersion = Main.installArtifact(fromDirectory, IMPLEMENTATION_ARTIFACTS[2], implMain);
        String validatorVersion = Main.installArtifact(fromDirectory, IMPLEMENTATION_ARTIFACTS[3], implMain);
        File implModuleXml = new File(implMain, "module.xml");
        fw = new FileWriter(implModuleXml);
        for (String s : ModuleXml.getImplementation(commonImplVersion, coreImplVersion, deployersCommonVersion, validatorVersion)) {
            fw.write(s);
            fw.write("\n");
        }
        fw.flush();
        fw.close();
        File jdbcMain = new File(jdbcRoot, "main");
        if (!jdbcMain.mkdirs()) {
            throw new IOException("Could not create: " + jdbcMain);
        }
        String jdbcVersion = Main.installArtifact(fromDirectory, JDBC_ARTIFACTS[0], jdbcMain);
        File jdbcModuleXml = new File(jdbcMain, "module.xml");
        fw = new FileWriter(jdbcModuleXml);
        for (String s : ModuleXml.getJdbc(jdbcVersion)) {
            fw.write(s);
            fw.write("\n");
        }
        fw.flush();
        fw.close();
        System.out.println("Installing new version: Done");
    }

    private static String installArtifact(File from, String artifact, File to) throws Throwable {
        File[] files;
        for (File f : files = from.listFiles()) {
            if (!f.getName().startsWith(artifact)) continue;
            File dest = new File(to, f.getName());
            Main.copy(f, dest);
            String version = f.getName();
            version = version.substring(artifact.length() + 1);
            version = version.substring(0, version.length() - 4);
            return version;
        }
        throw new IOException(artifact + " couldn't be found");
    }
}

