/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.converters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jca.as.converters.TxConnectionFactory;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.common.v10.CommonConnDef;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonSecurityImpl;
import org.jboss.jca.common.metadata.common.CommonTimeOutImpl;
import org.jboss.jca.common.metadata.common.CommonValidationImpl;
import org.jboss.jca.common.metadata.common.v10.CommonConnDefImpl;
import org.jboss.jca.common.metadata.resourceadapter.v10.ResourceAdapterImpl;

public class LegacyConnectionFactoryImp
implements TxConnectionFactory {
    private ResourceAdapterImpl raImpl = null;
    private TransactionSupportEnum transactionSupport;
    private List<CommonConnDef> connectionDefinitions;
    private CommonTimeOutImpl timeOut = null;
    private CommonSecurityImpl security = null;
    private CommonValidationImpl validation = null;
    private CommonPool pool = null;
    private String jndiName;
    private String rarName;
    private String poolName;
    private String connectionDefinition;
    private Map<String, String> configProperty;
    private Boolean noTxSeparatePool;
    private Boolean interleaving;

    public LegacyConnectionFactoryImp(String jndiName, String rarName, String poolName, String connectionDefinition, Map<String, String> configProperty, TransactionSupportEnum transactionSupport) {
        this.jndiName = jndiName;
        this.rarName = rarName;
        this.poolName = poolName;
        if (configProperty != null) {
            this.configProperty = new HashMap<String, String>(configProperty.size());
            this.configProperty.putAll(configProperty);
        } else {
            this.configProperty = new HashMap<String, String>(0);
        }
        this.connectionDefinition = connectionDefinition;
        this.transactionSupport = transactionSupport;
    }

    public void buildResourceAdapterImpl() throws Exception {
        CommonConnDefImpl connDef = new CommonConnDefImpl(this.configProperty, this.connectionDefinition, this.jndiName, this.poolName, Defaults.ENABLED, Defaults.USE_JAVA_CONTEXT, Defaults.USE_CCM, this.pool, (CommonTimeOut)this.timeOut, (CommonValidation)this.validation, (CommonSecurity)this.security, null);
        this.connectionDefinitions = new ArrayList<CommonConnDef>();
        this.connectionDefinitions.add((CommonConnDef)connDef);
        this.raImpl = new ResourceAdapterImpl(this.rarName, this.transactionSupport, this.connectionDefinitions, null, null, null, null);
    }

    public String toString() {
        String out = this.raImpl.toString();
        return out;
    }

    public LegacyConnectionFactoryImp buildTimeOut(Long blockingTimeoutMillis, Long idleTimeoutMinutes, Integer allocationRetry, Long allocationRetryWaitMillis, Integer xaResourceTimeout) throws Exception {
        this.timeOut = new CommonTimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout);
        return this;
    }

    public LegacyConnectionFactoryImp buildValidation(Boolean backgroundValidation, Long backgroundValidationMillis, Boolean useFastFail) throws Exception {
        this.validation = new CommonValidationImpl(backgroundValidation, backgroundValidationMillis, useFastFail);
        return this;
    }

    public LegacyConnectionFactoryImp buildCommonPool(Integer minPoolSize, Integer maxPoolSize, Boolean prefill, Boolean noTxSeparatePool, Boolean interleaving) throws Exception {
        this.pool = new CommonPoolImpl(minPoolSize, maxPoolSize, prefill, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY);
        this.noTxSeparatePool = noTxSeparatePool;
        this.setInterleaving(interleaving);
        return this;
    }

    public LegacyConnectionFactoryImp buildSecurity(String securityDomainManaged, String securityDomainAndApplicationManaged, boolean applicationManaged) throws Exception {
        this.security = new CommonSecurityImpl(securityDomainManaged, securityDomainAndApplicationManaged, applicationManaged);
        return this;
    }

    public LegacyConnectionFactoryImp buildOther() {
        return this;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public String getSecurityDomain() {
        return null;
    }

    @Override
    public Integer getMinPoolSize() {
        return this.pool.getMinPoolSize();
    }

    @Override
    public Integer getMaxPoolSize() {
        return this.pool.getMaxPoolSize();
    }

    @Override
    public Long getBlockingTimeoutMillis() {
        return this.timeOut.getBlockingTimeoutMillis();
    }

    @Override
    public Boolean isBackgroundValidation() {
        return this.validation.isBackgroundValidation();
    }

    @Override
    public Long getBackgroundValidationMillis() {
        return this.validation.getBackgroundValidationMillis();
    }

    @Override
    public Long getIdleTimeoutMinutes() {
        return this.timeOut.getIdleTimeoutMinutes();
    }

    @Override
    public Integer getAllocationRetry() {
        return this.timeOut.getAllocationRetry();
    }

    @Override
    public Long getAllocationRetryWaitMillis() {
        return this.timeOut.getAllocationRetryWaitMillis();
    }

    @Override
    public Boolean isPrefill() {
        return this.pool.isPrefill();
    }

    @Override
    public Boolean isUseFastFail() {
        return this.validation.isUseFastFail();
    }

    @Override
    public Boolean isNoTxSeparatePools() {
        return this.noTxSeparatePool;
    }

    @Override
    public Boolean isTrackConnectionByTx() {
        return false;
    }

    @Override
    public Integer getXaResourceTimeout() {
        return this.timeOut.getXaResourceTimeout();
    }

    @Override
    public String getRarName() {
        return this.rarName;
    }

    @Override
    public String getConnectionDefinition() {
        return this.connectionDefinition;
    }

    @Override
    public Map<String, String> getConfigProperties() {
        return this.configProperty;
    }

    @Override
    public TransactionSupportEnum getTransactionSupport() {
        return null;
    }

    public void setInterleaving(Boolean interleaving) {
        this.interleaving = interleaving;
    }

    public Boolean getInterleaving() {
        return this.interleaving;
    }
}

