/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.rarinfo;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.jca.as.rarinfo.RaImpl;
import org.jboss.jca.as.rarinfo.SecurityActions;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.common.v10.CommonConnDef;
import org.jboss.jca.common.api.metadata.ra.AdminObject;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.MessageListener;
import org.jboss.jca.common.api.metadata.ra.RequiredConfigProperty;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.common.api.metadata.ra.ra10.ResourceAdapter10;
import org.jboss.jca.common.metadata.common.CommonAdminObjectImpl;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonSecurityImpl;
import org.jboss.jca.common.metadata.common.CommonXaPoolImpl;
import org.jboss.jca.common.metadata.common.CredentialImpl;
import org.jboss.jca.common.metadata.common.v10.CommonConnDefImpl;
import org.jboss.jca.common.metadata.ra.RaParser;
import org.jboss.jca.validator.Validation;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Main {
    private static final int SUCCESS = 0;
    private static final int ERROR = 1;
    private static final int OTHER = 2;
    private static final String REPORT_FILE = "-report.txt";
    private static final String RAXML_FILE = "META-INF/ra.xml";
    private static final String tempdir = System.getProperty("java.io.tmpdir");
    private static final String subdir = "/jca/";
    private static Set<Class<?>> validTypes;
    private static final String ARGS_CP = "-classpath";
    private static final String ARGS_STDOUT = "--stdout";
    private static final String ARGS_OUT = "-o";
    private static File root;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        int argsLength = args.length;
        PrintStream out = null;
        try {
            ResourceAdapter ra;
            String version;
            if (argsLength < 1) {
                Main.usage();
                System.exit(2);
            }
            String rarFile = "";
            String[] cps = null;
            boolean stdout = false;
            String reportFile = "";
            for (int i = 0; i < argsLength; ++i) {
                String arg = args[i];
                if (arg.equals(ARGS_CP)) {
                    cps = args[++i].split(System.getProperty("path.separator"));
                    continue;
                }
                if (arg.equals(ARGS_STDOUT)) {
                    stdout = true;
                    continue;
                }
                if (arg.equals(ARGS_OUT)) {
                    reportFile = args[++i];
                    continue;
                }
                if (arg.endsWith("rar")) {
                    rarFile = arg;
                    continue;
                }
                Main.usage();
                System.exit(2);
            }
            ZipFile zipFile = new ZipFile(rarFile);
            boolean hasRaXml = false;
            boolean exsitNativeFile = false;
            Connector connector = null;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> xmls = new ArrayList<String>();
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry ze = zipEntries.nextElement();
                String name = ze.getName();
                names.add(name);
                if (name.endsWith(".xml") && name.startsWith("META-INF") && !name.endsWith("pom.xml")) {
                    xmls.add(name);
                }
                if (name.endsWith(".so") || name.endsWith(".a") || name.endsWith(".dll")) {
                    exsitNativeFile = true;
                }
                if (!name.equals(RAXML_FILE)) continue;
                hasRaXml = true;
                InputStream raIn = zipFile.getInputStream(ze);
                RaParser parser = new RaParser();
                connector = parser.parse(raIn);
                raIn.close();
            }
            if (!hasRaXml) {
                System.out.println("JCA annotations aren't supported");
                System.exit(2);
            }
            if (connector == null) {
                System.out.println("can't parse ra.xml");
                System.exit(2);
            }
            URLClassLoader cl = Main.loadClass(rarFile, cps);
            out = stdout ? System.out : (!reportFile.isEmpty() ? new PrintStream(reportFile) : new PrintStream(rarFile.substring(0, rarFile.length() - 4) + REPORT_FILE));
            int sep = rarFile.lastIndexOf(File.separator);
            String archiveFile = sep > 0 ? rarFile.substring(sep + 1) : rarFile;
            out.println("Archive:\t" + archiveFile);
            String type = "";
            boolean reauth = false;
            if (connector.getVersion() == Connector.Version.V_10) {
                version = "1.0";
                ra = connector.getResourceadapter();
                type = "OutBound";
                reauth = ((ResourceAdapter10)ra).getReauthenticationSupport();
            } else {
                version = connector.getVersion() == Connector.Version.V_15 ? "1.5" : "1.6";
                ResourceAdapter1516 ra1516 = (ResourceAdapter1516)connector.getResourceadapter();
                ra = ra1516;
                if (ra1516.getOutboundResourceadapter() != null) {
                    reauth = ra1516.getOutboundResourceadapter().getReauthenticationSupport();
                    type = ra1516.getInboundResourceadapter() != null ? "Bidirectional" : "OutBound";
                } else if (ra1516.getInboundResourceadapter() != null) {
                    type = "InBound";
                } else {
                    out.println("Rar file has problem");
                    System.exit(1);
                }
            }
            out.println("JCA version:\t" + version);
            out.println("Type:\t\t" + type);
            out.print("Reauth:\t\t");
            if (reauth) {
                out.println("Yes");
            } else {
                out.println("No");
            }
            int systemExitCode = Validation.validate((URL)new File(rarFile).toURI().toURL(), (String)".", (String[])cps);
            String compliant = systemExitCode == 0 ? "Yes" : "No";
            out.println("Compliant:\t" + compliant);
            out.print("Native:\t\t");
            if (exsitNativeFile) {
                out.println("Yes");
            } else {
                out.println("No");
            }
            Collections.sort(names);
            out.println();
            out.println("Structure:");
            out.println("----------");
            for (String name : names) {
                out.println(name);
            }
            String classname = "";
            HashMap<String, String> raConfigProperties = null;
            TransactionSupportEnum transSupport = TransactionSupportEnum.NoTransaction;
            ArrayList<CommonAdminObject> adminObjects = null;
            ArrayList<Object> connDefs = null;
            CommonSecurityImpl secImpl = new CommonSecurityImpl("", "", true);
            CommonPoolImpl poolImpl = new CommonPoolImpl(Integer.valueOf(0), Integer.valueOf(10), Defaults.PREFILL, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY);
            CommonXaPoolImpl xaPoolImpl = new CommonXaPoolImpl(Integer.valueOf(0), Integer.valueOf(10), Defaults.PREFILL, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY, Defaults.IS_SAME_RM_OVERRIDE, Defaults.INTERLEAVING, Defaults.PAD_XID, Defaults.WRAP_XA_RESOURCE, Defaults.NO_TX_SEPARATE_POOL);
            if (connector.getVersion() != Connector.Version.V_10) {
                String poolName;
                Map<String, String> introspected;
                ResourceAdapter1516 ra1516 = (ResourceAdapter1516)ra;
                if (ra1516.getResourceadapterClass() != null && !ra1516.getResourceadapterClass().equals("")) {
                    out.println();
                    out.println("Resource-adapter:");
                    out.println("-----------------");
                    out.println("Class: " + ra1516.getResourceadapterClass());
                    introspected = Main.getIntrospectedProperties(ra1516.getResourceadapterClass(), cl);
                    if (ra1516.getConfigProperties() != null) {
                        raConfigProperties = new HashMap<String, String>();
                        for (ConfigProperty configProperty : ra1516.getConfigProperties()) {
                            raConfigProperties.put(Main.getValueString(configProperty.getConfigPropertyName()), Main.getValueString(configProperty.getConfigPropertyValue()));
                            Main.removeIntrospectedValue(introspected, Main.getValueString(configProperty.getConfigPropertyName()));
                            out.println("  Config-property: " + Main.getValueString(configProperty.getConfigPropertyName()) + " (" + Main.getValueString(configProperty.getConfigPropertyType()) + ")");
                        }
                    }
                    if (introspected != null && !introspected.isEmpty()) {
                        for (Map.Entry entry : introspected.entrySet()) {
                            out.println("  Introspected Config-property: " + (String)entry.getKey() + " (" + (String)entry.getValue() + ")");
                        }
                    }
                    if (introspected == null) {
                        out.println("  Unable to resolve introspected config-property's");
                    }
                }
                int line = 0;
                HashSet<String> hashSet = new HashSet<String>();
                boolean needPrint = true;
                if (ra1516.getOutboundResourceadapter() != null) {
                    out.println();
                    out.println("Managed-connection-factory:");
                    out.println("---------------------------");
                    if (ra1516.getOutboundResourceadapter().getConnectionDefinitions() != null) {
                        connDefs = new ArrayList<CommonConnDef>();
                    }
                    transSupport = ra1516.getOutboundResourceadapter().getTransactionSupport();
                    for (ConnectionDefinition connectionDefinition : ra1516.getOutboundResourceadapter().getConnectionDefinitions()) {
                        CommonConnDefImpl connImpl;
                        classname = Main.getValueString(connectionDefinition.getManagedConnectionFactoryClass());
                        if (!hashSet.contains(classname)) {
                            hashSet.add(classname);
                            if (line != 0) {
                                out.println();
                            }
                            ++line;
                            out.println("Class: " + classname);
                            needPrint = true;
                        } else {
                            needPrint = false;
                        }
                        if (needPrint) {
                            Main.hasValidatingMcfInterface(out, classname, cl);
                            String cfi = Main.getValueString(connectionDefinition.getConnectionFactoryInterface());
                            try {
                                out.print("  CCI: ");
                                Class<?> clazz = Class.forName(cfi, true, cl);
                                if (Main.hasInterface(clazz, "javax.resource.cci.ConnectionFactory")) {
                                    out.println("Yes");
                                } else {
                                    out.println("No");
                                    out.println("  ConnectionFactory (" + cfi + "):");
                                    Main.outputMethodInfo(out, clazz, cl);
                                    Class<?> clazz2 = Class.forName(Main.getValueString(connectionDefinition.getConnectionInterface()), true, cl);
                                    out.println("  Connection (" + Main.getValueString(connectionDefinition.getConnectionInterface()) + "):");
                                    Main.outputMethodInfo(out, clazz2, cl);
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace(System.err);
                                out.println("Unknown");
                            }
                        }
                        HashMap<String, String> configProperty = null;
                        if (connectionDefinition.getConfigProperties() != null) {
                            configProperty = new HashMap<String, String>();
                        }
                        introspected = Main.getIntrospectedProperties(classname, cl);
                        for (ConfigProperty configProperty2 : connectionDefinition.getConfigProperties()) {
                            configProperty.put(Main.getValueString(configProperty2.getConfigPropertyName()), Main.getValueString(configProperty2.getConfigPropertyValue()));
                            Main.removeIntrospectedValue(introspected, Main.getValueString(configProperty2.getConfigPropertyName()));
                            if (!needPrint) continue;
                            out.println("  Config-property: " + Main.getValueString(configProperty2.getConfigPropertyName()) + " (" + Main.getValueString(configProperty2.getConfigPropertyType()) + ")");
                        }
                        if (introspected != null && !introspected.isEmpty()) {
                            for (Map.Entry entry : introspected.entrySet()) {
                                if (!needPrint) continue;
                                out.println("  Introspected Config-property: " + (String)entry.getKey() + " (" + (String)entry.getValue() + ")");
                            }
                        }
                        if (introspected == null) {
                            out.println("  Unable to resolve introspected config-property's");
                        }
                        poolName = Main.getValueString(connectionDefinition.getConnectionInterface()).substring(Main.getValueString(connectionDefinition.getConnectionInterface()).lastIndexOf(46) + 1);
                        Object var40_78 = null;
                        if (transSupport.equals((Object)TransactionSupportEnum.XATransaction)) {
                            CommonXaPoolImpl commonXaPoolImpl = xaPoolImpl;
                            Recovery recovery = new Recovery((Credential)new CredentialImpl("user", "password", null), null, Boolean.valueOf(false));
                            connImpl = new CommonConnDefImpl(configProperty, classname, "java:jboss/eis/" + poolName, poolName, Defaults.ENABLED, Defaults.USE_JAVA_CONTEXT, Defaults.USE_CCM, (CommonPool)commonXaPoolImpl, null, null, (CommonSecurity)secImpl, recovery);
                        } else {
                            CommonPoolImpl commonPoolImpl = poolImpl;
                            connImpl = new CommonConnDefImpl(configProperty, classname, "java:jboss/eis/" + poolName, poolName, Defaults.ENABLED, Defaults.USE_JAVA_CONTEXT, Defaults.USE_CCM, (CommonPool)commonPoolImpl, null, null, (CommonSecurity)secImpl, null);
                        }
                        connDefs.add((CommonConnDef)connImpl);
                    }
                }
                line = 0;
                hashSet.clear();
                if (ra1516.getAdminObjects() != null && ra1516.getAdminObjects().size() > 0) {
                    out.println();
                    out.println("Admin-object:");
                    out.println("-------------");
                    adminObjects = new ArrayList<CommonAdminObject>();
                }
                for (AdminObject adminObject : ra1516.getAdminObjects()) {
                    void var40_84;
                    String aoClassname = Main.getValueString(adminObject.getAdminobjectClass());
                    if (!hashSet.contains(aoClassname)) {
                        hashSet.add(aoClassname);
                        if (line != 0) {
                            out.println();
                        }
                        ++line;
                        out.println("Class: " + aoClassname);
                        out.println("  Interface: " + Main.getValueString(adminObject.getAdminobjectInterface()));
                        needPrint = true;
                    } else {
                        needPrint = false;
                    }
                    poolName = aoClassname.substring(aoClassname.lastIndexOf(46) + 1);
                    Object var40_82 = null;
                    if (adminObject.getConfigProperties() != null) {
                        HashMap hashMap = new HashMap();
                    }
                    introspected = Main.getIntrospectedProperties(aoClassname, cl);
                    for (ConfigProperty configProperty : adminObject.getConfigProperties()) {
                        var40_84.put(Main.getValueString(configProperty.getConfigPropertyName()), Main.getValueString(configProperty.getConfigPropertyValue()));
                        Main.removeIntrospectedValue(introspected, Main.getValueString(configProperty.getConfigPropertyName()));
                        if (!needPrint) continue;
                        out.println("  Config-property: " + Main.getValueString(configProperty.getConfigPropertyName()) + " (" + Main.getValueString(configProperty.getConfigPropertyType()) + ")");
                    }
                    if (introspected != null && !introspected.isEmpty()) {
                        for (Map.Entry entry : introspected.entrySet()) {
                            if (!needPrint) continue;
                            out.println("  Introspected Config-property: " + (String)entry.getKey() + " (" + (String)entry.getValue() + ")");
                        }
                    }
                    if (introspected == null) {
                        out.println("  Unable to resolve introspected config-property's");
                    }
                    CommonAdminObjectImpl aoImpl = new CommonAdminObjectImpl((Map)var40_84, aoClassname, "java:jboss/eis/ao/" + poolName, poolName, Defaults.ENABLED, Defaults.USE_JAVA_CONTEXT);
                    adminObjects.add((CommonAdminObject)aoImpl);
                }
                line = 0;
                hashSet.clear();
                if (ra1516.getInboundResourceadapter() != null && ra1516.getInboundResourceadapter().getMessageadapter() != null) {
                    out.println();
                    out.println("Activation-spec:");
                    out.println("----------------");
                    for (MessageListener messageListener : ra1516.getInboundResourceadapter().getMessageadapter().getMessagelisteners()) {
                        String asClassname = Main.getValueString(messageListener.getActivationspec().getActivationspecClass());
                        if (hashSet.contains(asClassname)) continue;
                        hashSet.add(asClassname);
                        if (line != 0) {
                            out.println();
                        }
                        ++line;
                        out.println("Class: " + asClassname);
                        out.println("  Message-listener: " + Main.getValueString(messageListener.getMessagelistenerType()));
                        introspected = Main.getIntrospectedProperties(asClassname, cl);
                        if (messageListener.getActivationspec() != null && messageListener.getActivationspec().getRequiredConfigProperties() != null) {
                            for (RequiredConfigProperty requiredConfigProperty : messageListener.getActivationspec().getRequiredConfigProperties()) {
                                Main.removeIntrospectedValue(introspected, Main.getValueString(requiredConfigProperty.getConfigPropertyName()));
                                out.println("  Required-config-property: " + Main.getValueString(requiredConfigProperty.getConfigPropertyName()));
                            }
                        }
                        if (introspected != null && !introspected.isEmpty()) {
                            for (Map.Entry entry : introspected.entrySet()) {
                                out.println("  Introspected Config-property: " + (String)entry.getKey() + " (" + (String)entry.getValue() + ")");
                            }
                        }
                        if (introspected != null) continue;
                        out.println("  Unable to resolve introspected config-property's");
                    }
                }
            } else {
                void var37_66;
                void var34_50;
                out.println("Managed-connection-factory:");
                out.println("---------------------------");
                ResourceAdapter10 ra10 = (ResourceAdapter10)ra;
                out.println("Class: " + ra10.getManagedConnectionFactoryClass());
                classname = Main.getValueString(ra10.getManagedConnectionFactoryClass());
                transSupport = ra10.getTransactionSupport();
                Main.hasValidatingMcfInterface(out, classname, cl);
                Class<?> cfi = Class.forName(classname, true, cl);
                out.println("  ConnectionFactory (" + classname + "):");
                Main.outputMethodInfo(out, cfi, cl);
                Class<?> ci = Class.forName(Main.getValueString(ra10.getConnectionInterface()), true, cl);
                out.println("  Connection (" + Main.getValueString(ra10.getConnectionInterface()) + "):");
                Main.outputMethodInfo(out, ci, cl);
                Object var34_48 = null;
                if (ra10.getConfigProperties() != null) {
                    HashMap hashMap = new HashMap();
                }
                Map<String, String> introspected = Main.getIntrospectedProperties(classname, cl);
                for (ConfigProperty configProperty : ra10.getConfigProperties()) {
                    var34_50.put(Main.getValueString(configProperty.getConfigPropertyName()), Main.getValueString(configProperty.getConfigPropertyValue()));
                    Main.removeIntrospectedValue(introspected, Main.getValueString(configProperty.getConfigPropertyName()));
                    out.println("  Config-property: " + Main.getValueString(configProperty.getConfigPropertyName()) + " (" + Main.getValueString(configProperty.getConfigPropertyType()) + ")");
                }
                if (introspected != null && !introspected.isEmpty()) {
                    for (Map.Entry entry : introspected.entrySet()) {
                        out.println("  Introspected Config-property: " + (String)entry.getKey() + " (" + (String)entry.getValue() + ")");
                    }
                }
                if (introspected == null) {
                    out.println("  Unable to resolve introspected config-property's");
                }
                String poolName = classname.substring(classname.lastIndexOf(46) + 1);
                Object var37_63 = null;
                if (transSupport.equals((Object)TransactionSupportEnum.XATransaction)) {
                    CommonXaPoolImpl commonXaPoolImpl = xaPoolImpl;
                } else {
                    CommonPoolImpl commonPoolImpl = poolImpl;
                }
                CommonConnDefImpl connImpl = new CommonConnDefImpl((Map)var34_50, classname, "java:jboss/eis/" + poolName, poolName, Defaults.ENABLED, Defaults.USE_JAVA_CONTEXT, Defaults.USE_CCM, (CommonPool)var37_66, null, null, (CommonSecurity)secImpl, null);
                connDefs = new ArrayList();
                connDefs.add((CommonConnDef)connImpl);
            }
            RaImpl raImpl = new RaImpl(archiveFile, transSupport, connDefs, adminObjects, raConfigProperties);
            raImpl.buildResourceAdapterImpl();
            Main.outputMenifest("META-INF/MANIFEST.MF", out);
            Main.outputXmlDesc(xmls, out);
            Main.outputRaDesc(raImpl, out);
            System.out.println("Done.");
            System.exit(0);
        }
        catch (Throwable t) {
            System.err.println("Error: " + t.getMessage());
            t.printStackTrace(System.err);
            System.exit(1);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ioe) {}
            }
            Main.cleanupTempFiles();
        }
    }

    private static void outputMethodInfo(PrintStream out, Class<?> clazz, URLClassLoader cl) throws ClassNotFoundException {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            out.print("    " + Main.singleName(method.getReturnType().getCanonicalName()) + " " + method.getName() + "(");
            Class<?>[] params = method.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                out.print(Main.singleName(params[i].getCanonicalName()));
                if (i + 1 >= params.length) continue;
                out.print(", ");
            }
            out.print(") ");
            Class<?>[] exceptions = method.getExceptionTypes();
            if (exceptions.length > 0) {
                out.print("throws ");
                for (int i = 0; i < exceptions.length; ++i) {
                    out.print(Main.singleName(exceptions[i].getCanonicalName()));
                    if (i + 1 >= exceptions.length) continue;
                    out.print(", ");
                }
            }
            out.println();
        }
    }

    private static String singleName(String className) {
        int lastPos = className.lastIndexOf(".");
        if (lastPos < 0) {
            return className;
        }
        return className.substring(lastPos + 1);
    }

    private static void hasValidatingMcfInterface(PrintStream out, String classname, URLClassLoader cl) {
        try {
            out.print("  Validating: ");
            Class<?> clazz = Class.forName(classname, true, cl);
            if (Main.hasInterface(clazz, "javax.resource.spi.ValidatingManagedConnectionFactory")) {
                out.println("Yes");
            } else {
                out.println("No");
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            out.println("Unknown");
        }
    }

    private static void outputMenifest(String meniFile, PrintStream out) throws FileNotFoundException, IOException {
        out.println();
        out.println(meniFile + ":");
        for (int i = 0; i <= meniFile.length(); ++i) {
            out.print("-");
        }
        out.println();
        Main.outToFile(meniFile, out);
    }

    private static void outputXmlDesc(ArrayList<String> xmls, PrintStream out) throws FileNotFoundException, IOException {
        for (String xmlfile : xmls) {
            out.println();
            out.println(xmlfile + ":");
            for (int i = 0; i <= xmlfile.length(); ++i) {
                out.print("-");
            }
            out.println();
            Main.outToFile(xmlfile, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void outToFile(String fileName, PrintStream out) throws FileNotFoundException, IOException {
        Reader in = null;
        try {
            int nBytes;
            in = new FileReader(root.getAbsolutePath() + File.separator + fileName);
            char[] buffer = new char[4096];
            while ((nBytes = in.read(buffer)) > 0) {
                for (int i = 0; i < nBytes; ++i) {
                    if (buffer[i] == '\r') continue;
                    out.print(buffer[i]);
                }
            }
            out.flush();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void outputRaDesc(RaImpl raImpl, PrintStream out) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        String raString = "<resource-adapters>" + raImpl.toString() + "</resource-adapters>";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(raString)));
        out.println();
        out.println("Deployment descriptor:");
        out.println("----------------------");
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer serializer = tfactory.newTransformer();
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        serializer.transform(new DOMSource(doc), new StreamResult(out));
    }

    private static URLClassLoader loadClass(String rarFile, String[] classpath) {
        if (rarFile == null) {
            throw new IllegalArgumentException("Rar file name is null");
        }
        File destination = null;
        try {
            URL[] allurls;
            File f = new File(rarFile);
            if (f.isFile()) {
                destination = new File(tempdir, subdir);
                root = Main.extract(f, destination);
            } else {
                root = f;
            }
            URL[] urls = Main.getUrls(root);
            if (classpath != null && classpath.length > 0) {
                ArrayList<URL> listUrl = new ArrayList<URL>();
                for (URL u : urls) {
                    listUrl.add(u);
                }
                for (String jar : classpath) {
                    if (!jar.endsWith(".jar")) continue;
                    listUrl.add(new File(jar).toURI().toURL());
                }
                allurls = listUrl.toArray(new URL[listUrl.size()]);
            } else {
                allurls = urls;
            }
            URLClassLoader cl = SecurityActions.createURLCLassLoader(allurls, SecurityActions.getThreadContextClassLoader());
            return cl;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static void cleanupTempFiles() {
        File destination = new File(tempdir, subdir);
        if (destination != null) {
            try {
                Main.recursiveDelete(destination);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static boolean hasInterface(Class<?> clazz, String interfaceName) {
        if (clazz.getName().equals(interfaceName)) {
            return true;
        }
        int i$ = 0;
        Class<?>[] arr$ = clazz.getInterfaces();
        int len$ = arr$.length;
        if (i$ < len$) {
            Class<?> iface = arr$[i$];
            if (iface.getName().equals(interfaceName)) {
                return true;
            }
            return Main.hasInterface(iface, interfaceName);
        }
        if (clazz.getSuperclass() != null) {
            return Main.hasInterface(clazz.getSuperclass(), interfaceName);
        }
        return false;
    }

    private static Map<String, String> getIntrospectedProperties(String clz, URLClassLoader cl) {
        TreeMap<String, String> result = null;
        try {
            Class<?> c = Class.forName(clz, true, cl);
            result = new TreeMap<String, String>();
            Method[] methods = c.getMethods();
            if (methods != null) {
                for (Method m : methods) {
                    if (!m.getName().startsWith("set") || m.getParameterTypes() == null || m.getParameterTypes().length != 1 || !Main.isValidType(m.getParameterTypes()[0])) continue;
                    String name = m.getName().substring(3);
                    name = name.length() == 1 ? name.toLowerCase(Locale.US) : name.substring(0, 1).toLowerCase(Locale.US) + name.substring(1);
                    String type = m.getParameterTypes()[0].getName();
                    result.put(name, type);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        return result;
    }

    private static boolean isValidType(Class<?> type) {
        return validTypes.contains(type);
    }

    private static void removeIntrospectedValue(Map<String, String> m, String name) {
        if (m != null) {
            m.remove(name);
            name = name.length() == 1 ? name.toUpperCase(Locale.US) : name.substring(0, 1).toUpperCase(Locale.US) + name.substring(1);
            m.remove(name);
            name = name.length() == 1 ? name.toLowerCase(Locale.US) : name.substring(0, 1).toLowerCase(Locale.US) + name.substring(1);
            m.remove(name);
        }
    }

    private static URL[] getUrls(File directory) throws MalformedURLException, IOException {
        LinkedList<URL> list = new LinkedList<URL>();
        if (directory.exists() && directory.isDirectory()) {
            list.add(directory.toURI().toURL());
            File[] jars = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            if (jars != null) {
                for (int j = 0; j < jars.length; ++j) {
                    list.add(jars[j].getCanonicalFile().toURI().toURL());
                }
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extract(File file, File directory) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (directory == null) {
            throw new IllegalArgumentException("Directory is null");
        }
        File target = new File(directory, file.getName());
        if (target.exists()) {
            Main.recursiveDelete(target);
        }
        if (!target.mkdirs()) {
            throw new IOException("Could not create " + target);
        }
        JarFile jar = new JarFile(file);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry je = entries.nextElement();
            File copy = new File(target, je.getName());
            if (!je.isDirectory()) {
                BufferedInputStream in = null;
                OutputStream out = null;
                if (copy.getParentFile() != null && !copy.getParentFile().exists() && !copy.getParentFile().mkdirs()) {
                    throw new IOException("Could not create " + copy.getParentFile());
                }
                try {
                    int nBytes;
                    in = new BufferedInputStream(jar.getInputStream(je));
                    out = new BufferedOutputStream(new FileOutputStream(copy));
                    byte[] buffer = new byte[4096];
                    while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                        out.write(buffer, 0, nBytes);
                    }
                    out.flush();
                    continue;
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException ignore) {}
                    try {
                        if (in == null) continue;
                        ((InputStream)in).close();
                    }
                    catch (IOException ignore) {}
                    continue;
                }
            }
            if (!copy.exists()) {
                if (copy.mkdirs()) continue;
                throw new IOException("Could not create " + copy);
            }
            if (copy.isDirectory()) continue;
            throw new IOException(copy + " isn't a directory");
        }
        return target;
    }

    private static void recursiveDelete(File f) throws IOException {
        if (f != null && f.exists()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        Main.recursiveDelete(files[i]);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    throw new IOException("Could not delete " + files[i]);
                }
            }
            if (!f.delete()) {
                throw new IOException("Could not delete " + f);
            }
        }
    }

    private static String getValueString(XsdString value) {
        if (value == null || value == XsdString.NULL_XSDSTRING) {
            return "";
        }
        return value.getValue();
    }

    private static void usage() {
        System.out.println("Usage:  ./rar-info.sh [-classpath <lib>[:<lib>]*] [--stdout] [-o <reportFile>] <file>");
    }

    static {
        root = null;
        validTypes = new HashSet();
        validTypes.add(Boolean.TYPE);
        validTypes.add(Boolean.class);
        validTypes.add(Byte.TYPE);
        validTypes.add(Byte.class);
        validTypes.add(Short.TYPE);
        validTypes.add(Short.class);
        validTypes.add(Integer.TYPE);
        validTypes.add(Integer.class);
        validTypes.add(Long.TYPE);
        validTypes.add(Long.class);
        validTypes.add(Float.TYPE);
        validTypes.add(Float.class);
        validTypes.add(Double.TYPE);
        validTypes.add(Double.class);
        validTypes.add(Character.TYPE);
        validTypes.add(Character.class);
        validTypes.add(String.class);
    }
}

