/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.upgrader;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.as.upgrader.Http;

public class MavenMetadata {
    public static String getVersion(String url) throws IOException {
        try {
            Http http = new Http();
            String mavenMetadataXml = http.get(url);
            StringReader sr = new StringReader(mavenMetadataXml);
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(sr);
            String version = null;
            while (version == null && xmlStreamReader.hasNext()) {
                int eventCode = xmlStreamReader.next();
                switch (eventCode) {
                    case 1: {
                        if (!"value".equals(xmlStreamReader.getLocalName())) break;
                        version = MavenMetadata.readString(xmlStreamReader);
                        break;
                    }
                }
            }
            if (version != null) {
                return version;
            }
        }
        catch (Throwable t) {
            throw new IOException("Unable to read: " + url, t);
        }
        throw new IOException("Unable to read: " + url);
    }

    private static String readString(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String result = null;
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 4: {
                    if (xmlStreamReader.getText().trim().equals("")) break;
                    result = xmlStreamReader.getText().trim();
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        return result;
    }
}

