/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.converters;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jboss.jca.as.converters.ConnectionFactoryConverter;
import org.jboss.jca.as.converters.DataSourceConverter;
import org.jboss.jca.as.converters.WlsRaConverter;

public class Main {
    private static final int SUCCESS = 0;
    private static final int ERROR = 1;
    private static final int OTHER = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            if (args.length < 3) {
                Main.usage();
                System.exit(2);
            }
            String option = args[0];
            String oldDsFilename = args[args.length - 2];
            String newFilename = args[args.length - 1];
            if (!option.equals("-ra") && !option.equals("-ds") || !oldDsFilename.endsWith(".xml") || !newFilename.endsWith(".xml")) {
                Main.usage();
                System.exit(2);
            }
            in = new FileInputStream(oldDsFilename);
            out = new FileOutputStream(newFilename);
            if (option.equals("-ds")) {
                DataSourceConverter converter = new DataSourceConverter();
                converter.convert(in, out);
            } else if (option.equals("-ra")) {
                if (!args[1].equals("--weblogic")) {
                    ConnectionFactoryConverter converter = new ConnectionFactoryConverter();
                    converter.convert(in, out);
                } else {
                    WlsRaConverter converter = new WlsRaConverter();
                    converter.convert(in, (OutputStream)out);
                }
            }
            System.out.println("Done.");
            System.exit(0);
        }
        catch (Throwable t) {
            System.err.println("Error: " + t.getMessage());
            t.printStackTrace(System.err);
            System.exit(1);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private static void usage() {
        System.out.println("Usage: ./converter.sh -{ds|ra} [--weblogic] old-ds.xml mydeployment-{ds|ra}.xml");
    }
}

