/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.converters;

import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.as.converters.ConnectionFactory;

public interface NoTxConnectionFactory
extends ConnectionFactory {
    public String getRarName();

    public String getConnectionDefinition();

    public Map<String, String> getConfigProperties();

    public static enum Tag {
        UNKNOWN(null),
        RAR_NAME("rar-name"),
        CONNECTION_DEFINITION("connection-definition"),
        CONFIG_PROPERTY("config-property"),
        JNDI_NAME("jndi-name"),
        SECURITY_DOMAIN("security-domain"),
        SECURITY_DOMAIN_AND_APPLICATION("security-domain-and-application"),
        MIN_POOL_SIZE("min-pool-size"),
        MAX_POOL_SIZE("max-pool-size"),
        BLOCKING_TIMEOUT_MILLIS("blocking-timeout-millis"),
        BACKGROUND_VALIDATION("background-validation"),
        BACKGROUND_VALIDATION_MILLIS("background-validation-millis"),
        IDLE_TIMEOUT_MINUTES("idle-timeout-minutes"),
        ALLOCATION_RETRY("allocation-retry"),
        ALLOCATION_RETRY_WAIT_MILLIS("allocation-retry-wait-millis"),
        PREFILL("prefill"),
        USE_FAST_FAIL("use-fast-fail");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

