/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.converters;

import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.as.converters.CommonXa;
import org.jboss.jca.as.converters.DataSource;

public interface XaDataSource
extends DataSource,
CommonXa {
    public String getXaDataSourceClass();

    public Map<String, String> getXaDataSourceProperty();

    public Boolean isSameRmOverride();

    public Boolean isInterleaving();

    public Boolean isPadXid();

    public Boolean isWrapXaResource();

    public static enum Tag {
        UNKNOWN(null),
        XA_DATASOURCE_PROPERTY("xa-datasource-property"),
        XA_DATASOURCE_CLASS("xa-datasource-class"),
        TRANSACTION_ISOLATION("transaction-isolation"),
        IS_SAME_RM_OVERRIDE("isSameRM-override-value"),
        INTERLEAVING("interleaving"),
        PAD_XID("pad-xid"),
        WRAP_XA_RESOURCE("wrap-xa-resource"),
        TRACK_CONNECTION_BY_TX("track_connection-by-tx"),
        NO_TX_SEPARATE_POOLS("no-tx-separate-pools"),
        XA_RESOURCE_TIMEOUT("xa-resource-timeout"),
        JNDI_NAME("jndi-name"),
        USE_JAVA_CONTEXT("use-java-context"),
        URL_DELIMITER("url-delimiter"),
        URL_SELECTOR_STRATEGY_CLASS_NAME("url-selector-strategy-class-name"),
        USER_NAME("user-name"),
        PASSWORD("password"),
        SECURITY_DOMAIN("security-domain"),
        SECURITY_DOMAIN_AND_APPLICATION("security-domain-and-application"),
        MIN_POOL_SIZE("min-pool-size"),
        MAX_POOL_SIZE("max-pool-size"),
        BLOCKING_TIMEOUT_MILLIS("blocking-timeout-millis"),
        BACKGROUND_VALIDATION("background-validation"),
        BACKGROUND_VALIDATION_MILLIS("background-validation-millis"),
        IDLE_TIMEOUT_MINUTES("idle-timeout-minutes"),
        ALLOCATION_RETRY("allocation-retry"),
        ALLOCATION_RETRY_WAIT_MILLIS("allocation-retry-wait-millis"),
        VALIDATE_ON_MATCH("validate-on-match"),
        NEW_CONNECTION_SQL("new-connection-sql"),
        CHECK_VALID_CONNECTION_SQL("check-valid-connection-sql"),
        VALID_CONNECTION_CHECKER("valid-connection-checker-class-name"),
        EXCEPTION_SORTER("exception-sorter-class-name"),
        STALE_CONNECTION_CHECKER("stale-connection-checker-class-name"),
        TRACK_STATEMENTS("track-statements"),
        PREFILL("prefill"),
        USE_FAST_FAIL("use-fast-fail"),
        PREPARED_STATEMENT_CACHE_SIZE("prepared-statement-cache-size"),
        SHARE_PREPARED_STATEMENTS("share-prepared-statements"),
        SET_TX_QUERY_TIMEOUT("set-tx-query-timeout"),
        QUERY_TIMEOUT("query-timeout"),
        USE_TRY_LOCK("use-try-lock"),
        RECOVER_USER_NAME("recover-user-name"),
        RECOVER_PASSWORD("recover-password"),
        NO_RECOVER("no_recover"),
        VALIDATION_QUERY_TIMEOUT("validation-query-timeout");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

