/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.converters.wls.metadata;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.as.converters.wls.metadata.ParserException;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.CommonLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public abstract class AbstractParser {
    private static CommonLogger log = (CommonLogger)Logger.getMessageLogger(CommonLogger.class, (String)AbstractParser.class.getName());
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private boolean resolveSystemProperties = true;

    public boolean isSystemPropertiesResolved() {
        return this.resolveSystemProperties;
    }

    public void setSystemPropertiesResolved(boolean v) {
        this.resolveSystemProperties = v;
    }

    protected Boolean elementAsBoolean(XMLStreamReader reader) throws XMLStreamException, ParserException {
        String elementtext = this.rawElementText(reader);
        String stringValue = this.getSubstitutionValue(elementtext);
        if (stringValue == null || stringValue.length() == 0 || stringValue.trim().equalsIgnoreCase("true") || stringValue.trim().equalsIgnoreCase("false")) {
            return stringValue == null || stringValue.length() == 0 ? Boolean.TRUE : Boolean.valueOf(stringValue.trim());
        }
        throw new ParserException(bundle.elementAsBoolean(elementtext, reader.getLocalName()));
    }

    protected Boolean attributeAsBoolean(XMLStreamReader reader, String attributeName, Boolean defaultValue) throws XMLStreamException, ParserException {
        String attributeString = this.rawAttributeText(reader, attributeName);
        String stringValue = this.getSubstitutionValue(attributeString);
        if (stringValue == null || stringValue.length() == 0 || stringValue.trim().equalsIgnoreCase("true") || stringValue.trim().equalsIgnoreCase("false")) {
            return attributeString == null ? defaultValue : Boolean.valueOf(reader.getAttributeValue("", attributeName).trim());
        }
        throw new ParserException(bundle.attributeAsBoolean(attributeString, reader.getLocalName()));
    }

    protected String elementAsString(XMLStreamReader reader) throws XMLStreamException {
        String elementtext = this.rawElementText(reader);
        return this.getSubstitutionValue(elementtext);
    }

    private String rawElementText(XMLStreamReader reader) throws XMLStreamException {
        String elementtext = reader.getElementText();
        elementtext = elementtext == null ? null : elementtext.trim();
        return elementtext;
    }

    protected String attributeAsString(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        String attributeString = this.rawAttributeText(reader, attributeName);
        return this.getSubstitutionValue(attributeString);
    }

    protected Integer attributeAsInt(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        String attributeString = this.getSubstitutionValue(this.rawAttributeText(reader, attributeName));
        return attributeString != null ? Integer.valueOf(this.getSubstitutionValue(attributeString)) : null;
    }

    private String rawAttributeText(XMLStreamReader reader, String attributeName) {
        String attributeString = reader.getAttributeValue("", attributeName) == null ? null : reader.getAttributeValue("", attributeName).trim();
        return attributeString;
    }

    protected Integer elementAsInteger(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Integer integerValue = null;
        String elementtext = this.rawElementText(reader);
        try {
            integerValue = Integer.valueOf(this.getSubstitutionValue(elementtext));
        }
        catch (NumberFormatException nfe) {
            throw new ParserException(bundle.notValidNumber(elementtext, reader.getLocalName()));
        }
        return integerValue;
    }

    protected Long elementAsLong(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Long longValue = null;
        String elementtext = this.rawElementText(reader);
        try {
            longValue = Long.valueOf(this.getSubstitutionValue(elementtext));
        }
        catch (NumberFormatException nfe) {
            throw new ParserException(bundle.notValidNumber(elementtext, reader.getLocalName()));
        }
        return longValue;
    }

    private String getSubstitutionValue(String input) throws XMLStreamException {
        if (input == null || ((String)input).trim().equals("")) {
            return input;
        }
        if (!this.resolveSystemProperties) {
            return input;
        }
        while (((String)input).indexOf("${") != -1) {
            int from = ((String)input).indexOf("${");
            int to = ((String)input).indexOf("}");
            int dv = ((String)input).indexOf(":", from + 2);
            if (dv != -1 && dv > to) {
                dv = -1;
            }
            String systemProperty = "";
            String defaultValue = "";
            String s = ((String)input).substring(from + 2, to);
            if (dv == -1) {
                systemProperty = "/".equals(s) ? File.separator : (":".equals(s) ? File.pathSeparator : SecurityActions.getSystemProperty(s));
            } else {
                s = ((String)input).substring(from + 2, dv);
                systemProperty = SecurityActions.getSystemProperty(s);
                defaultValue = ((String)input).substring(dv + 1, to);
            }
            String prefix = "";
            String postfix = "";
            if (from != 0) {
                prefix = ((String)input).substring(0, from);
            }
            if (to + 1 < ((String)input).length() - 1) {
                postfix = ((String)input).substring(to + 1);
            }
            if (systemProperty != null && !systemProperty.trim().equals("")) {
                input = prefix + systemProperty + postfix;
                continue;
            }
            if (!defaultValue.trim().equals("")) {
                input = prefix + defaultValue + postfix;
                continue;
            }
            input = prefix + postfix;
            log.debugf("System property %s not set", (Object)s);
        }
        return input;
    }

    private static class SecurityActions {
        private SecurityActions() {
        }

        static String getSystemProperty(final String name) {
            if (System.getSecurityManager() == null) {
                return System.getProperty(name);
            }
            return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty(name);
                }
            });
        }
    }
}

