/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.tracer;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.jca.as.tracer.HTMLReport;
import org.jboss.jca.as.tracer.Interaction;
import org.jboss.jca.as.tracer.TraceEventStatus;
import org.jboss.jca.core.tracer.TraceEvent;

public class TraceEventHelper {
    public static List<TraceEvent> filterPoolEvents(List<TraceEvent> data) throws Exception {
        ArrayList<TraceEvent> result = new ArrayList<TraceEvent>();
        for (TraceEvent te : data) {
            if (te.getType() == 60 || te.getType() == 61 || te.getType() == 62 || te.getType() == 70 || te.getType() == 71 || te.getType() == 72 || te.getType() == 73 || te.getType() == 74 || te.getType() == 75 || te.getType() == 76 || te.getType() == 80 || te.getType() == 81 || te.getType() == 90 || te.getType() == 91 || te.getType() == 92 || te.getType() == 93 || te.getType() == 94 || te.getType() == 95 || te.getType() == 96 || te.getType() == 100) continue;
            result.add(te);
        }
        return result;
    }

    public static Map<String, List<TraceEvent>> filterLifecycleEvents(List<TraceEvent> data) throws Exception {
        TreeMap<String, List<TraceEvent>> result = new TreeMap<String, List<TraceEvent>>();
        for (TraceEvent te : data) {
            if (te.getType() != 60 && te.getType() != 61 && te.getType() != 62 && te.getType() != 70 && te.getType() != 71 && te.getType() != 72 && te.getType() != 73 && te.getType() != 74 && te.getType() != 75 && te.getType() != 76 && te.getType() != 80 && te.getType() != 81) continue;
            ArrayList<TraceEvent> l = (ArrayList<TraceEvent>)result.get(te.getPool());
            if (l == null) {
                l = new ArrayList<TraceEvent>();
            }
            l.add(te);
            result.put(te.getPool(), l);
        }
        return result;
    }

    public static List<TraceEvent> filterCCMEvents(List<TraceEvent> data) throws Exception {
        ArrayList<TraceEvent> result = new ArrayList<TraceEvent>();
        for (TraceEvent te : data) {
            if (te.getType() != 90 && te.getType() != 91) continue;
            result.add(te);
        }
        return result;
    }

    public static Map<String, List<TraceEvent>> filterCCMPoolEvents(List<TraceEvent> data) throws Exception {
        TreeMap<String, List<TraceEvent>> result = new TreeMap<String, List<TraceEvent>>();
        for (TraceEvent te : data) {
            if (te.getType() != 92 && te.getType() != 93 && te.getType() != 94 && te.getType() != 95 && te.getType() != 96) continue;
            ArrayList<TraceEvent> l = (ArrayList<TraceEvent>)result.get(te.getPool());
            if (l == null) {
                l = new ArrayList<TraceEvent>();
            }
            l.add(te);
            result.put(te.getPool(), l);
        }
        return result;
    }

    public static Map<String, Set<String>> poolManagedConnectionPools(List<TraceEvent> data) throws Exception {
        TreeMap<String, Set<String>> result = new TreeMap<String, Set<String>>();
        for (TraceEvent te : data) {
            if (te.getType() != 0 && te.getType() != 1 && te.getType() != 2 && te.getType() != 3) continue;
            TreeSet<String> s = (TreeSet<String>)result.get(te.getPool());
            if (s == null) {
                s = new TreeSet<String>();
            }
            s.add(te.getManagedConnectionPool());
            result.put(te.getPool(), s);
        }
        return result;
    }

    public static Map<String, List<TraceEvent>> tocConnections(List<TraceEvent> data) throws Exception {
        TreeMap<String, List<TraceEvent>> result = new TreeMap<String, List<TraceEvent>>();
        for (TraceEvent te : data) {
            if (te.getType() != 40) continue;
            ArrayList<TraceEvent> l = (ArrayList<TraceEvent>)result.get(te.getPayload1());
            if (l == null) {
                l = new ArrayList<TraceEvent>();
            }
            l.add(te);
            result.put(te.getPayload1(), l);
        }
        return result;
    }

    public static Map<String, TraceEvent> tocManagedConnections(List<TraceEvent> data) throws Exception {
        TreeMap<String, TraceEvent> result = new TreeMap<String, TraceEvent>();
        for (TraceEvent te : data) {
            if (te.getType() != 60 && te.getType() != 61 && te.getType() != 62) continue;
            result.put(te.getPayload1(), te);
        }
        return result;
    }

    public static Map<String, List<TraceEvent>> tocConnectionListeners(List<TraceEvent> data) throws Exception {
        TreeMap<String, List<TraceEvent>> result = new TreeMap<String, List<TraceEvent>>();
        for (TraceEvent te : data) {
            if (te.getType() != 0 && te.getType() != 1 && te.getType() != 2 && te.getType() != 3) continue;
            ArrayList<TraceEvent> l = (ArrayList<TraceEvent>)result.get(te.getConnectionListener());
            if (l == null) {
                l = new ArrayList<TraceEvent>();
            }
            l.add(te);
            result.put(te.getConnectionListener(), l);
        }
        return result;
    }

    public static Map<String, List<TraceEvent>> tocManagedConnectionPools(List<TraceEvent> data) throws Exception {
        TreeMap<String, List<TraceEvent>> result = new TreeMap<String, List<TraceEvent>>();
        for (TraceEvent te : data) {
            if (te.getType() != 0 && te.getType() != 1 && te.getType() != 2 && te.getType() != 3) continue;
            ArrayList<TraceEvent> l = (ArrayList<TraceEvent>)result.get(te.getManagedConnectionPool());
            if (l == null) {
                l = new ArrayList<TraceEvent>();
            }
            l.add(te);
            result.put(te.getManagedConnectionPool(), l);
        }
        return result;
    }

    public static List<TraceEvent> getEvents(FileReader fr, File directory) throws Exception {
        return TraceEventHelper.getEvents(TraceEventHelper.getData(fr, directory));
    }

    public static Map<String, TraceEventStatus> getStatus(Map<String, List<TraceEvent>> input, boolean ignoreDelist, boolean ignoreTracking, boolean ignoreIncomplete) {
        TreeMap<String, TraceEventStatus> result = new TreeMap<String, TraceEventStatus>();
        for (Map.Entry<String, List<TraceEvent>> entry : input.entrySet()) {
            result.put(entry.getKey(), TraceEventHelper.getStatus(entry.getValue(), ignoreDelist, ignoreTracking, ignoreIncomplete));
        }
        return result;
    }

    public static TraceEventStatus getStatus(List<TraceEvent> data, boolean ignoreDelist, boolean ignoreTracking, boolean ignoreIncomplete) {
        TraceEventStatus explicit = null;
        HashSet<String> knownConnections = new HashSet<String>();
        boolean gotCl = false;
        boolean inTx = false;
        boolean gotClear = false;
        block30: for (TraceEvent te : data) {
            switch (te.getType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (gotCl) {
                        explicit = TraceEventStatus.RED;
                    }
                    gotCl = true;
                    continue block30;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    if (!gotCl) {
                        explicit = TraceEventStatus.RED;
                    }
                    gotCl = false;
                    continue block30;
                }
                case 14: {
                    explicit = TraceEventStatus.RED;
                    continue block30;
                }
                case 20: {
                    if (inTx) {
                        explicit = TraceEventStatus.RED;
                    }
                    inTx = true;
                    continue block30;
                }
                case 22: {
                    if (inTx) {
                        explicit = TraceEventStatus.YELLOW;
                    }
                    inTx = true;
                    continue block30;
                }
                case 21: 
                case 23: {
                    explicit = inTx ? TraceEventStatus.RED : TraceEventStatus.YELLOW;
                    inTx = true;
                    continue block30;
                }
                case 30: 
                case 32: {
                    if (!inTx) {
                        explicit = TraceEventStatus.RED;
                    }
                    inTx = false;
                    if (ignoreTracking || knownConnections.size() <= 0 || explicit == TraceEventStatus.RED) continue block30;
                    explicit = TraceEventStatus.YELLOW;
                    continue block30;
                }
                case 34: {
                    if (!inTx) {
                        explicit = TraceEventStatus.RED;
                    }
                    inTx = false;
                    if (ignoreTracking || explicit == TraceEventStatus.RED) continue block30;
                    explicit = TraceEventStatus.YELLOW;
                    continue block30;
                }
                case 35: {
                    if (!inTx) {
                        explicit = TraceEventStatus.RED;
                    }
                    inTx = false;
                    if (ignoreTracking) continue block30;
                    explicit = TraceEventStatus.RED;
                    continue block30;
                }
                case 31: 
                case 33: {
                    explicit = !inTx ? TraceEventStatus.RED : TraceEventStatus.YELLOW;
                    inTx = false;
                    if (ignoreTracking || knownConnections.size() <= 0 || explicit == TraceEventStatus.RED) continue block30;
                    explicit = TraceEventStatus.YELLOW;
                    continue block30;
                }
                case 40: {
                    if (knownConnections.add(te.getPayload1())) continue block30;
                    explicit = TraceEventStatus.RED;
                    continue block30;
                }
                case 41: {
                    if (knownConnections.remove(te.getPayload1())) continue block30;
                    explicit = TraceEventStatus.RED;
                    continue block30;
                }
                case 42: {
                    gotClear = true;
                    continue block30;
                }
                case 50: {
                    continue block30;
                }
                case 60: {
                    continue block30;
                }
                case 61: {
                    continue block30;
                }
                case 62: {
                    continue block30;
                }
                case 70: {
                    continue block30;
                }
                case 71: {
                    continue block30;
                }
                case 72: {
                    continue block30;
                }
                case 73: {
                    continue block30;
                }
                case 74: {
                    continue block30;
                }
                case 75: {
                    continue block30;
                }
                case 76: {
                    continue block30;
                }
                case 80: {
                    continue block30;
                }
                case 81: {
                    continue block30;
                }
                case 92: {
                    continue block30;
                }
                case 93: {
                    continue block30;
                }
            }
            System.err.println("TraceEventHelper: Unknown code: " + te);
        }
        if (explicit != null) {
            return explicit;
        }
        if (gotCl) {
            return TraceEventStatus.RED;
        }
        if (inTx && !ignoreDelist) {
            return TraceEventStatus.RED;
        }
        if (knownConnections.size() > 0) {
            return TraceEventStatus.RED;
        }
        if (gotClear) {
            return TraceEventStatus.RED;
        }
        return TraceEventStatus.GREEN;
    }

    public static TraceEventStatus mergeStatus(Collection<TraceEventStatus> data) {
        TraceEventStatus result = TraceEventStatus.GREEN;
        for (TraceEventStatus tes : data) {
            if (tes == TraceEventStatus.YELLOW) {
                result = TraceEventStatus.YELLOW;
                continue;
            }
            if (tes != TraceEventStatus.RED) continue;
            return TraceEventStatus.RED;
        }
        return result;
    }

    public static boolean isStartState(TraceEvent te) {
        return te.getType() == 0 || te.getType() == 1 || te.getType() == 2 || te.getType() == 3 || te.getType() == 14;
    }

    public static boolean isEndState(TraceEvent te) {
        return te.getType() == 10 || te.getType() == 11 || te.getType() == 12 || te.getType() == 13 || te.getType() == 14;
    }

    public static boolean isRed(TraceEvent te) {
        return te.getType() == 42 || te.getType() == 14;
    }

    public static boolean isYellow(TraceEvent te) {
        return false;
    }

    public static Map<String, List<Interaction>> getPoolData(List<TraceEvent> data, boolean ignoreDelist, boolean ignoreTracking, boolean ignoreIncomplete) {
        TreeMap<String, List<Interaction>> result = new TreeMap<String, List<Interaction>>();
        TreeMap temp = new TreeMap();
        for (int i = 0; i < data.size(); ++i) {
            ArrayList<TraceEvent> l;
            TraceEvent te = data.get(i);
            TreeMap<String, ArrayList<TraceEvent>> m = (TreeMap<String, ArrayList<TraceEvent>>)temp.get(te.getPool());
            if (m == null) {
                m = new TreeMap<String, ArrayList<TraceEvent>>();
            }
            if ((l = (ArrayList<TraceEvent>)m.get(te.getConnectionListener())) == null) {
                l = new ArrayList<TraceEvent>();
            }
            l.add(te);
            if (TraceEventHelper.isEndState(te)) {
                Interaction interaction = new Interaction(te.getThreadId(), ((TraceEvent)l.get(0)).getTimestamp(), ((TraceEvent)l.get(l.size() - 1)).getTimestamp(), l, TraceEventHelper.getStatus(l, ignoreDelist, ignoreTracking, ignoreIncomplete));
                ArrayList<Interaction> pool = (ArrayList<Interaction>)result.get(te.getPool());
                if (pool == null) {
                    pool = new ArrayList<Interaction>();
                }
                pool.add(interaction);
                result.put(te.getPool(), pool);
                l = null;
            }
            m.put(te.getConnectionListener(), l);
            temp.put(te.getPool(), m);
        }
        if (!ignoreIncomplete) {
            for (Map.Entry poolEntry : temp.entrySet()) {
                for (Map.Entry clEntry : ((Map)poolEntry.getValue()).entrySet()) {
                    List l = (List)clEntry.getValue();
                    if (l == null) continue;
                    Interaction interaction = new Interaction(((TraceEvent)l.get(0)).getThreadId(), ((TraceEvent)l.get(0)).getTimestamp(), ((TraceEvent)l.get(l.size() - 1)).getTimestamp(), l, TraceEventHelper.getStatus(l, ignoreDelist, ignoreTracking, ignoreIncomplete));
                    ArrayList<Interaction> pool = (ArrayList<Interaction>)result.get(poolEntry.getKey());
                    if (pool == null) {
                        pool = new ArrayList<Interaction>();
                    }
                    pool.add(interaction);
                    result.put((String)poolEntry.getKey(), pool);
                }
            }
        }
        return result;
    }

    public static Map<String, List<Interaction>> getConnectionListenerData(List<Interaction> data) {
        TreeMap<String, List<Interaction>> result = new TreeMap<String, List<Interaction>>();
        for (int i = 0; i < data.size(); ++i) {
            Interaction interaction = data.get(i);
            ArrayList<Interaction> l = (ArrayList<Interaction>)result.get(interaction.getConnectionListener());
            if (l == null) {
                l = new ArrayList<Interaction>();
            }
            l.add(interaction);
            result.put(interaction.getConnectionListener(), l);
        }
        return result;
    }

    public static Map<String, List<Interaction>> getTransactionData(List<Interaction> data) {
        TreeMap<String, List<Interaction>> result = new TreeMap<String, List<Interaction>>();
        for (int i = 0; i < data.size(); ++i) {
            Interaction interaction = data.get(i);
            if (interaction.getTransaction() == null) continue;
            ArrayList<Interaction> l = (ArrayList<Interaction>)result.get(interaction.getTransaction());
            if (l == null) {
                l = new ArrayList<Interaction>();
            }
            l.add(interaction);
            result.put(interaction.getTransaction(), l);
        }
        return result;
    }

    public static boolean hasException(List<TraceEvent> events) {
        for (TraceEvent te : events) {
            if (te.getType() != 50) continue;
            return true;
        }
        return false;
    }

    public static String exceptionDescription(String encoded) {
        char[] data = encoded.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            char c = data[i];
            sb = c == '|' ? sb.append('\n') : (c == '/' ? sb.append('\r') : (c == '\\' ? sb.append('\t') : (c == '_' ? sb.append(' ') : sb.append(c))));
        }
        return sb.toString();
    }

    public static String prettyPrint(TraceEvent te) {
        if (te.getType() != 0 && te.getType() != 1 && te.getType() != 2 && te.getType() != 3 && te.getType() != 10 && te.getType() != 11 && te.getType() != 12 && te.getType() != 13 && te.getType() != 60 && te.getType() != 61 && te.getType() != 62 && te.getType() != 70 && te.getType() != 71 && te.getType() != 72 && te.getType() != 73 && te.getType() != 74 && te.getType() != 75 && te.getType() != 76 && te.getType() != 50 && te.getType() != 90 && te.getType() != 91) {
            return te.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("IJTRACER");
        sb.append("-");
        sb.append(te.getPool());
        sb.append("-");
        sb.append(te.getManagedConnectionPool());
        sb.append("-");
        sb.append(te.getThreadId());
        sb.append("-");
        sb.append(te.getType());
        sb.append("-");
        sb.append(te.getTimestamp());
        sb.append("-");
        sb.append(te.getConnectionListener());
        sb.append("-");
        sb.append("DATA");
        return sb.toString();
    }

    public static TraceEvent getVersion(List<TraceEvent> events) {
        for (TraceEvent te : events) {
            if (te.getType() != 100) continue;
            return te;
        }
        return null;
    }

    public static TraceEventStatus getCCMStatus(List<TraceEvent> data, boolean ignoreIncomplete) {
        TreeMap stacks = new TreeMap();
        for (TraceEvent te : data) {
            Long id = te.getThreadId();
            ArrayDeque<TraceEvent> stack = (ArrayDeque<TraceEvent>)stacks.get(id);
            if (stack == null) {
                stack = new ArrayDeque<TraceEvent>();
            }
            if (te.getType() == 90) {
                stack.push(te);
            } else {
                TraceEvent top = (TraceEvent)stack.peek();
                if (top.getPayload1().equals(te.getPayload1())) {
                    stack.pop();
                } else {
                    return TraceEventStatus.RED;
                }
            }
            stacks.put(id, stack);
        }
        for (Deque entry : stacks.values()) {
            if (ignoreIncomplete || entry.isEmpty()) continue;
            return TraceEventStatus.YELLOW;
        }
        return TraceEventStatus.GREEN;
    }

    /*
     * WARNING - void declaration
     */
    public static TraceEventStatus getCCMPoolStatus(List<TraceEvent> data, boolean ignoreIncomplete) {
        HashMap<Long, void> threads = new HashMap<Long, void>();
        TraceEventStatus status = TraceEventStatus.GREEN;
        for (TraceEvent traceEvent : data) {
            Set<String> s;
            void var7_9;
            Long id = traceEvent.getThreadId();
            Map map = (Map)threads.get(id);
            if (map == null) {
                HashMap hashMap = new HashMap();
            }
            if (traceEvent.getType() == 92) {
                s = (HashSet<String>)var7_9.get(traceEvent.getConnectionListener());
                if (s == null) {
                    s = new HashSet<String>();
                    var7_9.put(traceEvent.getConnectionListener(), s);
                }
                if (!s.add(traceEvent.getPayload1())) {
                    status = TraceEventStatus.YELLOW;
                }
            } else if (traceEvent.getType() == 93) {
                s = (Set)var7_9.get(traceEvent.getConnectionListener());
                if (s == null) {
                    s = new HashSet();
                    var7_9.put(traceEvent.getConnectionListener(), s);
                }
                if (!s.remove(traceEvent.getPayload1())) {
                    status = TraceEventStatus.YELLOW;
                }
            } else {
                if (traceEvent.getType() == 95) {
                    return TraceEventStatus.RED;
                }
                if (traceEvent.getType() == 96) {
                    status = TraceEventStatus.YELLOW;
                }
            }
            threads.put(id, var7_9);
        }
        for (Map.Entry entry : threads.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                if (ignoreIncomplete || ((Set)entry2.getValue()).size() <= 0) continue;
                return TraceEventStatus.RED;
            }
        }
        return status;
    }

    public static TraceEvent getType(List<TraceEvent> events, int ... types) {
        return TraceEventHelper.getType(events, null, types);
    }

    public static TraceEvent getType(List<TraceEvent> events, String identifier, int ... types) {
        for (TraceEvent te : events) {
            for (int type : types) {
                if (te.getType() != type || identifier != null && !te.getConnectionListener().equals(identifier)) continue;
                return te;
            }
        }
        return null;
    }

    static boolean hasMoreApplicationEvents(List<TraceEvent> events, int index) {
        if (index < 0 || index >= events.size()) {
            return false;
        }
        for (int j = index; j < events.size(); ++j) {
            TraceEvent te = events.get(j);
            if (te.getType() != 40 && te.getType() != 41) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getData(FileReader fr, File directory) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        LineNumberReader r = new LineNumberReader(fr);
        String s = r.readLine();
        while (s != null) {
            if (s.indexOf("IJTRACER") != -1) {
                result.add(s.substring(s.indexOf("IJTRACER")));
            }
            s = r.readLine();
        }
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(directory.getAbsolutePath() + "/raw.txt");
            for (String data : result) {
                HTMLReport.writeString((FileWriter)fw, data);
                HTMLReport.writeEOL((FileWriter)fw);
            }
        }
        finally {
            if (fw != null) {
                try {
                    fw.flush();
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    private static List<TraceEvent> getEvents(List<String> data) throws Exception {
        ArrayList<TraceEvent> result = new ArrayList<TraceEvent>();
        for (String s : data) {
            result.add(TraceEvent.parse((String)s));
        }
        return result;
    }
}

