/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.MethodForConnection;
import org.jboss.jca.codegenerator.MethodParam;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class McCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        int indent = 1;
        out.write("public class " + this.getClassName(def) + " implements ManagedConnection");
        this.writeLeftCurlyBracket(out, 0);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** The logger */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private static Logger log = Logger.getLogger(" + this.getSelfClassName(def) + ");");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** The logwriter */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private PrintWriter logwriter;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** ManagedConnectionFactory */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private " + def.getMcfDefs().get(this.getNumOfMcf()).getMcfClass() + " mcf;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** Listeners */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private List<ConnectionEventListener> listeners;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** Connection */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        if (def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
            out.write("private " + def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass() + " connection;");
        } else {
            out.write("private " + def.getMcfDefs().get(this.getNumOfMcf()).getConnImplClass() + " connection;");
        }
        this.writeEol(out);
        this.writeEol(out);
        if (def.isSupportEis()) {
            this.writeIndent(out, indent);
            out.write("/** Socket */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("private Socket socket;");
            this.writeEol(out);
            this.writeEol(out);
        }
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Default constructor");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param mcf mcf");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public " + this.getClassName(def) + "(" + def.getMcfDefs().get(this.getNumOfMcf()).getMcfClass() + " mcf)");
        if (def.isSupportEis()) {
            out.write(" throws ResourceException");
        }
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("this.mcf = mcf;");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("this.logwriter = null;");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("this.listeners = Collections.synchronizedList(new ArrayList<ConnectionEventListener>(1));");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("this.connection = null;");
        if (def.isSupportEis()) {
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            out.write("this.socket = null; // TODO: Initialize me");
        }
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeConnection(def, out, indent);
        this.writeLifecycle(def, out, indent);
        this.writeConnectionEventListener(def, out, indent);
        this.writeLogWriter(def, out, indent);
        this.writeTransaction(def, out, indent);
        this.writeMetaData(def, out, indent);
        this.writeMethod(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        if (def.isSupportEis()) {
            out.write("import java.io.IOException;");
            this.writeEol(out);
        }
        out.write("import java.io.PrintWriter;");
        this.writeEol(out);
        if (def.isSupportEis()) {
            out.write("import java.net.Socket;");
            this.writeEol(out);
        }
        out.write("import java.util.ArrayList;");
        this.writeEol(out);
        out.write("import java.util.Collections;");
        this.writeEol(out);
        out.write("import java.util.List;");
        this.writeEol(out);
        this.importLogging(def, out);
        out.write("import javax.resource.NotSupportedException;");
        this.writeEol(out);
        out.write("import javax.resource.ResourceException;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ConnectionEvent;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ConnectionEventListener;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ConnectionRequestInfo;");
        this.writeEol(out);
        out.write("import javax.resource.spi.LocalTransaction;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ManagedConnection;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ManagedConnectionMetaData;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.security.auth.Subject;");
        this.writeEol(out);
        out.write("import javax.transaction.xa.XAResource;");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMcfDefs().get(this.getNumOfMcf()).getMcClass();
    }

    private void writeConnection(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Creates a new connection handle for the underlying physical connection ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * represented by the ManagedConnection instance. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param subject Security context as JAAS subject");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param cxRequestInfo ConnectionRequestInfo instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return generic Object instance representing the connection handle. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public Object getConnection(Subject subject,");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("ConnectionRequestInfo cxRequestInfo) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getConnection", new String[0]);
        this.writeIndent(out, indent + 1);
        if (def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
            out.write("connection = new " + def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass() + "();");
        } else {
            out.write("connection = new " + def.getMcfDefs().get(this.getNumOfMcf()).getConnImplClass() + "(this, mcf);");
        }
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("return connection;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Used by the container to change the association of an ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * application-level connection handle with a ManagedConneciton instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param connection Application-level connection handle");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void associateConnection(Object connection) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "associateConnection", "connection");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("if (connection == null)");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("throw new ResourceException(\"Null connection handle\");");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("if (!(connection instanceof ");
        if (def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass());
        } else {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getConnImplClass());
        }
        out.write("))");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("throw new ResourceException(\"Wrong connection handle\");");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("this.connection = (");
        if (def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass());
        } else {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getConnImplClass());
        }
        out.write(")connection;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeLifecycle(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Application server calls this method to force any cleanup on the ManagedConnection instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void cleanup() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "cleanup", new String[0]);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Destroys the physical connection to the underlying resource manager.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void destroy() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "destroy", new String[0]);
        if (def.isSupportEis()) {
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            out.write("if (socket != null)");
            this.writeLeftCurlyBracket(out, indent + 1);
            this.writeIndent(out, indent + 2);
            out.write("try");
            this.writeLeftCurlyBracket(out, indent + 2);
            this.writeIndent(out, indent + 3);
            out.write("socket.close();");
            this.writeRightCurlyBracket(out, indent + 2);
            this.writeIndent(out, indent + 2);
            out.write("catch (IOException ioe)");
            this.writeLeftCurlyBracket(out, indent + 2);
            this.writeIndent(out, indent + 3);
            out.write("// Ignore");
            this.writeRightCurlyBracket(out, indent + 2);
            this.writeRightCurlyBracket(out, indent + 1);
        }
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeConnectionEventListener(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Adds a connection event listener to the ManagedConnection instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param listener A new ConnectionEventListener to be registered");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void addConnectionEventListener(ConnectionEventListener listener)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "addConnectionEventListener", "listener");
        this.writeIndent(out, indent + 1);
        out.write("if (listener == null)");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("throw new IllegalArgumentException(\"Listener is null\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("listeners.add(listener);");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Removes an already registered connection event listener from the ManagedConnection instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param listener already registered connection event listener to be removed");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void removeConnectionEventListener(ConnectionEventListener listener)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "removeConnectionEventListener", "listener");
        this.writeIndent(out, indent + 1);
        out.write("if (listener == null)");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("throw new IllegalArgumentException(\"Listener is null\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("listeners.remove(listener);");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Close handle");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param handle The handle");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("void closeHandle(");
        if (def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass() + " handle)");
        } else {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getConnInterfaceClass() + " handle)");
        }
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("ConnectionEvent event = new ConnectionEvent(this, ConnectionEvent.CONNECTION_CLOSED);");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("event.setConnectionHandle(handle);");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("for (ConnectionEventListener cel : listeners)");
        this.writeLeftCurlyBracket(out, indent + 1);
        this.writeIndent(out, indent + 2);
        out.write("cel.connectionClosed(event);");
        this.writeRightCurlyBracket(out, indent + 1);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeLogWriter(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Gets the log writer for this ManagedConnection instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Character output stream associated with this Managed-Connection instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public PrintWriter getLogWriter() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getLogWriter", new String[0]);
        this.writeIndent(out, indent + 1);
        out.write("return logwriter;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Sets the log writer for this ManagedConnection instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param out Character Output stream to be associated");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException  generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void setLogWriter(PrintWriter out) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "setLogWriter", "out");
        this.writeIndent(out, indent + 1);
        out.write("logwriter = out;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeTransaction(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Returns an <code>javax.resource.spi.LocalTransaction</code> instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return LocalTransaction instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public LocalTransaction getLocalTransaction() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        if (def.getSupportTransaction().equals("NoTransaction")) {
            this.writeIndent(out, indent + 1);
            out.write("throw new NotSupportedException(\"getLocalTransaction() not supported\");");
        } else {
            this.writeLogging(def, out, indent + 1, "trace", "getLocalTransaction", new String[0]);
            this.writeIndent(out, indent + 1);
            out.write("return null;");
        }
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Returns an <code>javax.transaction.xa.XAresource</code> instance. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return XAResource instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public XAResource getXAResource() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        if (def.getSupportTransaction().equals("NoTransaction")) {
            this.writeIndent(out, indent + 1);
            out.write("throw new NotSupportedException(\"getXAResource() not supported\");");
        } else {
            this.writeLogging(def, out, indent + 1, "trace", "getXAResource", new String[0]);
            this.writeIndent(out, indent + 1);
            out.write("return null;");
        }
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeMetaData(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Gets the metadata information for this connection's underlying EIS resource manager instance. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return ManagedConnectionMetaData instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public ManagedConnectionMetaData getMetaData() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getMetaData", new String[0]);
        this.writeIndent(out, indent + 1);
        out.write("return new " + def.getMcfDefs().get(this.getNumOfMcf()).getMcMetaClass() + "();");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeMethod(Definition def, Writer out, int indent) throws IOException {
        if (def.getMcfDefs().get(this.getNumOfMcf()).isDefineMethodInConnection()) {
            if (def.getMcfDefs().get(this.getNumOfMcf()).getMethods().size() > 0) {
                for (MethodForConnection method : def.getMcfDefs().get(this.getNumOfMcf()).getMethods()) {
                    String ex;
                    int i;
                    this.writeIndent(out, indent);
                    out.write("/**");
                    this.writeEol(out);
                    this.writeIndent(out, indent);
                    out.write(" * Call " + method.getMethodName());
                    this.writeEol(out);
                    int paramSize = method.getParams().size();
                    for (int i2 = 0; i2 < paramSize; ++i2) {
                        MethodParam param = method.getParams().get(i2);
                        this.writeIndent(out, indent);
                        out.write(" * @param " + param.getName() + " " + param.getType());
                        this.writeEol(out);
                    }
                    int exceptionSize = method.getExceptionType().size();
                    for (i = 0; i < exceptionSize; ++i) {
                        ex = method.getExceptionType().get(i);
                        this.writeIndent(out, indent);
                        out.write(" * @throws " + ex);
                        this.writeEol(out);
                    }
                    if (!method.getReturnType().equals("void")) {
                        this.writeIndent(out, indent);
                        out.write(" * @return " + method.getReturnType());
                        this.writeEol(out);
                    }
                    this.writeIndent(out, indent);
                    out.write(" */");
                    this.writeEol(out);
                    this.writeIndent(out, indent);
                    out.write(method.getReturnType() + " " + method.getMethodName() + "(");
                    for (i = 0; i < paramSize; ++i) {
                        MethodParam param = method.getParams().get(i);
                        out.write(param.getType());
                        out.write(" ");
                        out.write(param.getName());
                        if (i + 1 >= paramSize) continue;
                        out.write(", ");
                    }
                    out.write(")");
                    for (i = 0; i < exceptionSize; ++i) {
                        if (i == 0) {
                            out.write(" throws ");
                        }
                        ex = method.getExceptionType().get(i);
                        out.write(ex);
                        if (i + 1 >= exceptionSize) continue;
                        out.write(", ");
                    }
                    this.writeLeftCurlyBracket(out, indent);
                    this.writeLogging(def, out, indent + 1, "trace", method.getMethodName(), new String[0]);
                    if (!method.getReturnType().equals("void")) {
                        this.writeEol(out);
                        this.writeIndent(out, indent + 1);
                        out.write("return null;");
                    }
                    this.writeRightCurlyBracket(out, indent);
                }
            }
        } else {
            this.writeIndent(out, indent);
            out.write("/**");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * Call me");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("void callMe()");
            this.writeLeftCurlyBracket(out, indent);
            this.writeLogging(def, out, indent + 1, "trace", "callMe", new String[0]);
            this.writeRightCurlyBracket(out, indent);
        }
    }
}

