/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.MethodForConnection;
import org.jboss.jca.codegenerator.MethodParam;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class ConnImplCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public class " + this.getClassName(def) + " implements " + def.getMcfDefs().get(this.getNumOfMcf()).getConnInterfaceClass());
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeIndent(out, indent);
        out.write("/** The logger */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private static Logger log = Logger.getLogger(" + this.getSelfClassName(def) + ");");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** ManagedConnection */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private " + def.getMcfDefs().get(this.getNumOfMcf()).getMcClass() + " mc;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** ManagedConnectionFactory */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private " + def.getMcfDefs().get(this.getNumOfMcf()).getMcfClass() + " mcf;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Default constructor");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param mc " + def.getMcfDefs().get(this.getNumOfMcf()).getMcClass());
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param mcf " + def.getMcfDefs().get(this.getNumOfMcf()).getMcfClass());
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public " + this.getClassName(def) + "(" + def.getMcfDefs().get(this.getNumOfMcf()).getMcClass() + " mc, " + def.getMcfDefs().get(this.getNumOfMcf()).getMcfClass() + " mcf)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("this.mc = mc;");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("this.mcf = mcf;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeMethod(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        this.importLogging(def, out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMcfDefs().get(this.getNumOfMcf()).getConnImplClass();
    }

    private void writeMethod(Definition def, Writer out, int indent) throws IOException {
        if (def.getMcfDefs().get(this.getNumOfMcf()).isDefineMethodInConnection()) {
            if (def.getMcfDefs().get(this.getNumOfMcf()).getMethods().size() > 0) {
                for (MethodForConnection method : def.getMcfDefs().get(this.getNumOfMcf()).getMethods()) {
                    MethodParam param;
                    String ex;
                    int i;
                    this.writeIndent(out, indent);
                    out.write("/**");
                    this.writeEol(out);
                    this.writeIndent(out, indent);
                    out.write(" * Call " + method.getMethodName());
                    this.writeEol(out);
                    int paramSize = method.getParams().size();
                    for (int i2 = 0; i2 < paramSize; ++i2) {
                        MethodParam param2 = method.getParams().get(i2);
                        this.writeIndent(out, indent);
                        out.write(" * @param " + param2.getName() + " " + param2.getType());
                        this.writeEol(out);
                    }
                    int exceptionSize = method.getExceptionType().size();
                    for (i = 0; i < exceptionSize; ++i) {
                        ex = method.getExceptionType().get(i);
                        this.writeIndent(out, indent);
                        out.write(" * @throws " + ex);
                        this.writeEol(out);
                    }
                    if (!method.getReturnType().equals("void")) {
                        this.writeIndent(out, indent);
                        out.write(" * @return " + method.getReturnType());
                        this.writeEol(out);
                    }
                    this.writeIndent(out, indent);
                    out.write(" */");
                    this.writeEol(out);
                    this.writeIndent(out, indent);
                    out.write("public " + method.getReturnType() + " " + method.getMethodName() + "(");
                    for (i = 0; i < paramSize; ++i) {
                        param = method.getParams().get(i);
                        out.write(param.getType());
                        out.write(" ");
                        out.write(param.getName());
                        if (i + 1 >= paramSize) continue;
                        out.write(", ");
                    }
                    out.write(")");
                    for (i = 0; i < exceptionSize; ++i) {
                        if (i == 0) {
                            out.write(" throws ");
                        }
                        ex = method.getExceptionType().get(i);
                        out.write(ex);
                        if (i + 1 >= exceptionSize) continue;
                        out.write(", ");
                    }
                    this.writeLeftCurlyBracket(out, indent);
                    this.writeIndent(out, indent + 1);
                    if (!method.getReturnType().equals("void")) {
                        out.write("return ");
                    }
                    out.write("mc." + method.getMethodName() + "(");
                    for (i = 0; i < paramSize; ++i) {
                        param = method.getParams().get(i);
                        out.write(param.getName());
                        if (i + 1 >= paramSize) continue;
                        out.write(", ");
                    }
                    out.write(");");
                    this.writeRightCurlyBracket(out, indent);
                    this.writeEol(out);
                }
            }
        } else {
            this.writeIndent(out, indent);
            out.write("/**");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * Call me");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("public void callMe()");
            this.writeLeftCurlyBracket(out, indent);
            this.writeIndent(out, indent + 1);
            out.write("mc.callMe();");
            this.writeRightCurlyBracket(out, indent);
        }
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Close");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void close()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("mc.closeHandle(this);");
        this.writeRightCurlyBracket(out, indent);
    }
}

