/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.jboss.jca.codegenerator.BaseGen;
import org.jboss.jca.codegenerator.Definition;

public abstract class AbstractCodeGen
extends BaseGen {
    private int numOfMcf = 0;

    public void generate(Definition def, Writer out) throws IOException {
        this.writeheader(def, out);
        this.writeImport(def, out);
        this.writeClassComment(def, out);
        this.writeClassBody(def, out);
    }

    void writeClassComment(Definition def, Writer out) throws IOException {
        out.write("/**");
        this.writeEol(out);
        out.write(" * " + this.getClassName(def));
        this.writeEol(out);
        out.write(" *");
        this.writeEol(out);
        out.write(" * @version $Revision: $");
        this.writeEol(out);
        out.write(" */");
        this.writeEol(out);
    }

    public abstract String getClassName(Definition var1);

    public abstract void writeImport(Definition var1, Writer var2) throws IOException;

    public abstract void writeClassBody(Definition var1, Writer var2) throws IOException;

    void writeLeftCurlyBracket(Writer out, int indent) throws IOException {
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("{");
        this.writeEol(out);
    }

    void writeRightCurlyBracket(Writer out, int indent) throws IOException {
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("}");
        this.writeEol(out);
    }

    void writeDefaultConstructor(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Default constructor");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public " + this.getClassName(def) + "()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    String upcaseFirst(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(name.substring(0, 1).toUpperCase(Locale.ENGLISH));
        sb.append(name.substring(1));
        return sb.toString();
    }

    void writeHashCode(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/** ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Returns a hash code value for the object.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return A hash code value for this object.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public int hashCode()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return 42;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    void writeEquals(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/** ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Indicates whether some other object is equal to this one.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param other The reference object with which to compare.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return true If this object is the same as the obj argument, false otherwise.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public boolean equals(Object other)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("if (other == null)");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("return false;");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("return getClass().equals(other.getClass());");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    public void setNumOfMcf(int numOfMcf) {
        this.numOfMcf = numOfMcf;
    }

    public int getNumOfMcf() {
        return this.numOfMcf;
    }

    protected String getSelfClassName(Definition def) {
        return this.getClassName(def) + ".class.getName()";
    }

    protected void importLogging(Definition def, Writer out) throws IOException {
        if (def.isSupportJbossLogging()) {
            out.write("import org.jboss.logging.Logger;");
            this.writeEol(out);
            this.writeEol(out);
        } else {
            out.write("import java.util.logging.Logger;");
            this.writeEol(out);
            this.writeEol(out);
        }
    }

    protected void writeLogging(Definition def, Writer out, int indent, String level, String content, String ... params) throws IOException {
        this.writeIndent(out, indent);
        if (def.isSupportJbossLogging()) {
            int i;
            out.write("log.trace");
            int size = params.length;
            if (size > 0) {
                out.write("f");
            }
            out.write("(\"" + content + "(");
            for (i = 0; i < size; ++i) {
                out.write("%s");
                if (i >= size - 1) continue;
                out.write(", ");
            }
            out.write(")\"");
            for (i = 0; i < size; ++i) {
                out.write(", ");
                out.write(params[i]);
            }
            out.write(");");
        } else {
            out.write("log.finest(\"" + content + "()\");");
        }
        this.writeEol(out);
    }
}

