package org.jboss.jca.embedded.dsl.ironjacamar12.impl; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.jca.embedded.dsl.ironjacamar12.api.WorkmanagerSecurityMappingsUsersType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.jca.embedded.dsl.ironjacamar12.api.WorkmanagerSecurityMappingType;
import org.jboss.jca.embedded.dsl.ironjacamar12.impl.WorkmanagerSecurityMappingTypeImpl;

/**
 * This class implements the <code> workmanagerSecurityMappingsUsersType </code> xsd type 
 */
public class WorkmanagerSecurityMappingsUsersTypeImpl<T> implements Child<T>, WorkmanagerSecurityMappingsUsersType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public WorkmanagerSecurityMappingsUsersTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public WorkmanagerSecurityMappingsUsersTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WorkmanagerSecurityMappingsUsersType ElementName: ironjacamar:workmanagerSecurityMappingType ElementType : map
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>map</code> element will be created and returned.
    * Otherwise, the first existing <code>map</code> element will be returned.
    * @return the instance defined for the element <code>map</code> 
    */
   public WorkmanagerSecurityMappingType<WorkmanagerSecurityMappingsUsersType<T>> getOrCreateMap()
   {
      List<Node> nodeList = childNode.get("map");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new WorkmanagerSecurityMappingTypeImpl<WorkmanagerSecurityMappingsUsersType<T>>(this, "map", childNode, nodeList.get(0));
      }
      return createMap();
   }

   /**
    * Creates a new <code>map</code> element 
    * @return the new created instance of <code>WorkmanagerSecurityMappingType<WorkmanagerSecurityMappingsUsersType<T>></code> 
    */
   public WorkmanagerSecurityMappingType<WorkmanagerSecurityMappingsUsersType<T>> createMap()
   {
      return new WorkmanagerSecurityMappingTypeImpl<WorkmanagerSecurityMappingsUsersType<T>>(this, "map", childNode);
   }

   /**
    * Returns all <code>map</code> elements
    * @return list of <code>map</code> 
    */
   public List<WorkmanagerSecurityMappingType<WorkmanagerSecurityMappingsUsersType<T>>> getAllMap()
   {
      List<WorkmanagerSecurityMappingType<WorkmanagerSecurityMappingsUsersType<T>>> list = new ArrayList<WorkmanagerSecurityMappingType<WorkmanagerSecurityMappingsUsersType<T>>>();
      List<Node> nodeList = childNode.get("map");
      for(Node node: nodeList)
      {
         WorkmanagerSecurityMappingType<WorkmanagerSecurityMappingsUsersType<T>>  type = new WorkmanagerSecurityMappingTypeImpl<WorkmanagerSecurityMappingsUsersType<T>>(this, "map", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>map</code> elements 
    * @return the current instance of <code>WorkmanagerSecurityMappingType<WorkmanagerSecurityMappingsUsersType<T>></code> 
    */
   public WorkmanagerSecurityMappingsUsersType<T> removeAllMap()
   {
      childNode.removeChildren("map");
      return this;
   }
}
