package org.jboss.jca.embedded.dsl.resourceadapters11.api; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.jca.embedded.dsl.resourceadapters11.api.WorkmanagerSecurityType;
/**
 * This interface defines the contract for the <code> workmanagerType </code> xsd type 
 */
public interface WorkmanagerType<T> extends Child<T>
{
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WorkmanagerType ElementName: resource-adapters:workmanagerSecurityType ElementType : security
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>security</code> element with the given value will be created.
    * Otherwise, the existing <code>security</code> element will be returned.
    * @return  a new or existing instance of <code>WorkmanagerSecurityType<WorkmanagerType<T>></code> 
    */
   public WorkmanagerSecurityType<WorkmanagerType<T>> getOrCreateSecurity();

   /**
    * Removes the <code>security</code> element 
    * @return the current instance of <code>WorkmanagerType<T></code> 
    */
   public WorkmanagerType<T> removeSecurity();
}
