/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.annotations;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.resource.spi.Activation;
import javax.resource.spi.AdministeredObject;
import javax.resource.spi.AuthenticationMechanism;
import javax.resource.spi.ConfigProperty;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ConnectionDefinitions;
import javax.resource.spi.Connector;
import javax.resource.spi.SecurityPermission;
import javax.resource.spi.TransactionSupport;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.annotation.javaee.DisplayNames;
import org.jboss.annotation.javaee.Icons;
import org.jboss.jca.common.annotations.SecurityActions;
import org.jboss.jca.common.validator.ValidateException;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.DescriptionImpl;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.DisplayNameImpl;
import org.jboss.metadata.javaee.spec.DisplayNamesImpl;
import org.jboss.metadata.javaee.spec.IconImpl;
import org.jboss.metadata.javaee.spec.IconsImpl;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.rar.spec.ActivationspecMetaData;
import org.jboss.metadata.rar.spec.AdminObjectMetaData;
import org.jboss.metadata.rar.spec.AuthenticationMechanismMetaData;
import org.jboss.metadata.rar.spec.ConfigPropertyMetaData;
import org.jboss.metadata.rar.spec.ConnectionDefinitionMetaData;
import org.jboss.metadata.rar.spec.ConnectorMetaData;
import org.jboss.metadata.rar.spec.InboundRaMetaData;
import org.jboss.metadata.rar.spec.JCA16Base;
import org.jboss.metadata.rar.spec.JCA16MetaData;
import org.jboss.metadata.rar.spec.LicenseMetaData;
import org.jboss.metadata.rar.spec.MessageAdapterMetaData;
import org.jboss.metadata.rar.spec.MessageListenerMetaData;
import org.jboss.metadata.rar.spec.OutboundRaMetaData;
import org.jboss.metadata.rar.spec.ResourceAdapterMetaData;
import org.jboss.metadata.rar.spec.SecurityPermissionMetaData;
import org.jboss.metadata.rar.spec.TransactionSupportMetaData;
import org.jboss.papaki.Annotation;
import org.jboss.papaki.AnnotationRepository;
import org.jboss.papaki.AnnotationScanner;
import org.jboss.papaki.AnnotationScannerFactory;
import org.jboss.papaki.AnnotationType;

public class Annotations {
    private static Logger log = Logger.getLogger(Annotations.class);
    private static boolean trace = log.isTraceEnabled();

    public ConnectorMetaData scan(ConnectorMetaData cmd, URL[] urls, ClassLoader cl) throws Exception {
        if (cmd == null || cmd.is16()) {
            AnnotationScanner annotationScanner = AnnotationScannerFactory.getStrategy((int)1);
            annotationScanner.configure().constructorLevel(false).parameterLevel(false);
            AnnotationRepository annotationRepository = annotationScanner.scan(urls, new ClassLoader[]{cl});
            boolean isMetadataComplete = false;
            if (cmd != null && cmd instanceof JCA16Base) {
                JCA16Base jmd = (JCA16Base)cmd;
                isMetadataComplete = jmd.isMetadataComplete();
            }
            if (cmd == null || !isMetadataComplete) {
                cmd = this.process(cmd, annotationRepository);
            }
        }
        return cmd;
    }

    public ConnectorMetaData process(ConnectorMetaData md, AnnotationRepository annotationRepository) throws Exception {
        if (annotationRepository == null) {
            throw new ValidateException("AnnotationRepository reference is null");
        }
        if (md == null) {
            JCA16MetaData jmd = new JCA16MetaData();
            jmd.setMetadataComplete(false);
            md = jmd;
        }
        md = this.processConnector(md, annotationRepository);
        md = this.processConnectionDefinitions(md, annotationRepository);
        md = this.processConnectionDefinition(md, annotationRepository);
        md = this.processActivation(md, annotationRepository);
        md = this.processAdministeredObject(md, annotationRepository);
        md = this.processConfigProperty(md, annotationRepository);
        return md;
    }

    private ConnectorMetaData processConnector(ConnectorMetaData md, AnnotationRepository annotationRepository) throws Exception {
        Collection values = annotationRepository.getAnnotation(Connector.class);
        if (values != null) {
            if (values.size() == 1) {
                Annotation annotation = (Annotation)values.iterator().next();
                String raClass = annotation.getClassName();
                Connector c = (Connector)annotation.getAnnotation();
                if (trace) {
                    log.trace((Object)("Processing: " + c + " for " + raClass));
                }
                md = this.attachConnector(md, raClass, c);
            } else if (values.size() == 0) {
                if (md.getRa().getRaClass() == null || md.getRa().getRaClass().equals("")) {
                    log.fatal((Object)"No @Connector was found and no definition in the ra.xml metadata either");
                    throw new ValidateException("No @Connector defined");
                }
            } else if (md.getRa().getRaClass() == null || md.getRa().getRaClass().equals("")) {
                log.fatal((Object)"More than one @Connector was found but the correct one wasn't defined in the ra.xml metadata");
                throw new ValidateException("More than one @Connector defined");
            }
        }
        return md;
    }

    private ConnectorMetaData attachConnector(ConnectorMetaData md, String raClass, Connector c) throws Exception {
        String version;
        String vendorName;
        String[] smallIcon;
        SecurityPermission[] securityPermissions;
        Class[] requiredWorkContexts;
        String[] licenseDescription;
        String[] largeIcon;
        String eisType;
        String[] displayName;
        if (md.getRa() == null) {
            md.setRa(new ResourceAdapterMetaData());
        }
        md.getRa().setRaClass(raClass);
        AuthenticationMechanism[] authMechanisms = c.authMechanisms();
        if (authMechanisms != null) {
            for (AuthenticationMechanism authMechanism : authMechanisms) {
                this.attachAuthenticationMechanism(md, authMechanism);
            }
        }
        DescriptionGroupMetaData descGroup = new DescriptionGroupMetaData();
        md.setDescriptionGroup(descGroup);
        String[] description = c.description();
        if (description != null) {
            if (descGroup.getDescriptions() == null) {
                DescriptionsImpl descsImpl = new DescriptionsImpl();
                descGroup.setDescriptions((Descriptions)descsImpl);
            }
            for (String desc : description) {
                DescriptionImpl descImpl = new DescriptionImpl();
                descImpl.setDescription(desc);
                ((DescriptionsImpl)descGroup.getDescriptions()).add((MappableMetaData)descImpl);
            }
        }
        if ((displayName = c.displayName()) != null) {
            if (descGroup.getDisplayNames() == null) {
                DisplayNamesImpl dnsImpl = new DisplayNamesImpl();
                descGroup.setDisplayNames((DisplayNames)dnsImpl);
            }
            for (String dn : displayName) {
                DisplayNameImpl dnImpl = new DisplayNameImpl();
                dnImpl.setDisplayName(dn);
                ((DisplayNamesImpl)descGroup.getDisplayNames()).add((MappableMetaData)dnImpl);
            }
        }
        if ((eisType = c.eisType()) != null && md.getEISType() == null) {
            md.setEISType(eisType);
        }
        if ((largeIcon = c.largeIcon()) != null) {
            if (descGroup.getIcons() == null) {
                IconsImpl icsImpl = new IconsImpl();
                descGroup.setIcons((Icons)icsImpl);
            }
            for (String large : largeIcon) {
                IconImpl icImpl = new IconImpl();
                icImpl.setLargeIcon(large);
                ((IconsImpl)descGroup.getIcons()).add((MappableMetaData)icImpl);
            }
        }
        if ((licenseDescription = c.licenseDescription()) != null) {
            if (md.getLicense() == null) {
                md.setLicense(new LicenseMetaData());
            }
            if (md.getLicense().getDescriptions() == null) {
                DescriptionsImpl descsImpl = new DescriptionsImpl();
                md.getLicense().setDescriptions((Descriptions)descsImpl);
            }
            for (String desc : licenseDescription) {
                DescriptionImpl descImpl = new DescriptionImpl();
                descImpl.setDescription(desc);
                ((DescriptionsImpl)md.getLicense().getDescriptions()).add((MappableMetaData)descImpl);
            }
        }
        boolean licenseRequired = c.licenseRequired();
        if (md.getLicense() == null) {
            md.setLicense(new LicenseMetaData());
        }
        md.getLicense().setRequired(licenseRequired);
        boolean reauthenticationSupport = c.reauthenticationSupport();
        if (md.getRa() != null && md.getRa().getOutboundRa() != null) {
            md.getRa().getOutboundRa().setReAuthSupport(reauthenticationSupport);
        }
        if ((requiredWorkContexts = c.requiredWorkContexts()) != null) {
            for (Class requiredWorkContext : requiredWorkContexts) {
                if (!(md instanceof JCA16Base)) continue;
                JCA16Base jmd = (JCA16Base)md;
                if (jmd.getRequiredWorkContexts() == null) {
                    jmd.setRequiredWorkContexts(new ArrayList());
                }
                if (jmd.getRequiredWorkContexts().contains(requiredWorkContext.getName())) continue;
                if (trace) {
                    log.trace((Object)("RequiredWorkContext=" + requiredWorkContext.getName()));
                }
                jmd.getRequiredWorkContexts().add(requiredWorkContext.getName());
            }
        }
        if ((securityPermissions = c.securityPermissions()) != null) {
            if (md.getRa() == null) {
                md.setRa(new ResourceAdapterMetaData());
            }
            if (md.getRa().getSecurityPermissions() == null) {
                md.getRa().setSecurityPermissions(new ArrayList());
            }
            for (SecurityPermission securityPermission : securityPermissions) {
                SecurityPermissionMetaData spmd = new SecurityPermissionMetaData();
                spmd.setSecurityPermissionSpec(securityPermission.permissionSpec());
                md.getRa().getSecurityPermissions().add(spmd);
            }
        }
        if ((smallIcon = c.smallIcon()) != null) {
            IconsImpl icsImpl;
            if (descGroup.getIcons() == null) {
                icsImpl = new IconsImpl();
                descGroup.setIcons((Icons)icsImpl);
            } else {
                icsImpl = (IconsImpl)descGroup.getIcons();
            }
            IconImpl[] icArray = (IconImpl[])icsImpl.toArray((Object[])new IconImpl[icsImpl.size()]);
            for (int i = 0; i < smallIcon.length; ++i) {
                if (i < icArray.length) {
                    icArray[i].setSmallIcon(smallIcon[i]);
                    continue;
                }
                IconImpl icImpl = new IconImpl();
                icImpl.setLargeIcon(smallIcon[i]);
                icsImpl.add((MappableMetaData)icImpl);
            }
        }
        TransactionSupport.TransactionSupportLevel transactionSupport = c.transactionSupport();
        if (md.getRa() != null && md.getRa().getOutboundRa() != null) {
            if (transactionSupport.equals((Object)TransactionSupport.TransactionSupportLevel.NoTransaction)) {
                md.getRa().getOutboundRa().setTransSupport(TransactionSupportMetaData.NoTransaction);
            } else if (transactionSupport.equals((Object)TransactionSupport.TransactionSupportLevel.XATransaction)) {
                md.getRa().getOutboundRa().setTransSupport(TransactionSupportMetaData.XATransaction);
            } else if (transactionSupport.equals((Object)TransactionSupport.TransactionSupportLevel.LocalTransaction)) {
                md.getRa().getOutboundRa().setTransSupport(TransactionSupportMetaData.LocalTransaction);
            }
        }
        if ((vendorName = c.vendorName()) != null && md.getVendorName() == null) {
            md.setVendorName(vendorName);
        }
        if ((version = c.version()) != null && md.getRAVersion() == null) {
            md.setRAVersion(version);
        }
        return md;
    }

    private ConnectorMetaData processConnectionDefinitions(ConnectorMetaData md, AnnotationRepository annotationRepository) throws Exception {
        Collection values = annotationRepository.getAnnotation(ConnectionDefinitions.class);
        if (values != null) {
            if (values.size() == 1) {
                Annotation annotation = (Annotation)values.iterator().next();
                ConnectionDefinitions c = (ConnectionDefinitions)annotation.getAnnotation();
                if (trace) {
                    log.trace((Object)("Processing: " + c));
                }
                md = this.attachConnectionDefinitions(md, c, annotation.getClassName());
            } else {
                throw new ValidateException("More than one @ConnectionDefinitions defined");
            }
        }
        return md;
    }

    private ConnectorMetaData attachConnectionDefinitions(ConnectorMetaData md, ConnectionDefinitions cds, String mcf) throws Exception {
        this.createConDefs(md);
        if (cds.value() != null) {
            for (ConnectionDefinition cd : cds.value()) {
                md = this.attachConnectionDefinition(md, mcf, cd);
            }
        }
        return md;
    }

    private ConnectorMetaData processConnectionDefinition(ConnectorMetaData md, AnnotationRepository annotationRepository) throws Exception {
        Collection values = annotationRepository.getAnnotation(ConnectionDefinition.class);
        if (values != null) {
            for (Annotation annotation : values) {
                md = this.attachConnectionDefinition(md, annotation);
            }
        }
        return md;
    }

    private ConnectorMetaData attachConnectionDefinition(ConnectorMetaData md, Annotation annotation) throws Exception {
        ConnectionDefinition cd = (ConnectionDefinition)annotation.getAnnotation();
        if (trace) {
            log.trace((Object)("Processing: " + annotation));
        }
        this.createConDefs(md);
        for (ConnectionDefinitionMetaData cdMeta : md.getRa().getOutboundRa().getConDefs()) {
            if (!cdMeta.getManagedConnectionFactoryClass().equals(annotation.getClassName())) continue;
            return md;
        }
        return this.attachConnectionDefinition(md, annotation.getClassName(), cd);
    }

    private ConnectorMetaData attachConnectionDefinition(ConnectorMetaData md, String mcf, ConnectionDefinition cd) throws Exception {
        if (trace) {
            log.trace((Object)("Processing: " + cd));
        }
        this.createConDefs(md);
        ConnectionDefinitionMetaData cdMeta = new ConnectionDefinitionMetaData();
        cdMeta.setManagedConnectionFactoryClass(mcf);
        cdMeta.setConnectionFactoryInterfaceClass(cd.connectionFactory().getName());
        cdMeta.setConnectionFactoryImplementationClass(cd.connectionFactoryImpl().getName());
        cdMeta.setConnectionInterfaceClass(cd.connection().getName());
        cdMeta.setConnectionImplementationClass(cd.connectionImpl().getName());
        md.getRa().getOutboundRa().getConDefs().add(cdMeta);
        return md;
    }

    private ConnectorMetaData processConfigProperty(ConnectorMetaData md, AnnotationRepository annotationRepository) throws Exception {
        Collection values = annotationRepository.getAnnotation(ConfigProperty.class);
        if (values != null) {
            for (Annotation annotation : values) {
                md = this.attachConfigProperty(md, annotation);
            }
        }
        return md;
    }

    private ConnectorMetaData attachConfigProperty(ConnectorMetaData md, Annotation annotation) throws Exception {
        block18: {
            String attachedClassName;
            Class<?> attachedClass;
            ConfigPropertyMetaData cfgMeta;
            block19: {
                block17: {
                    ClassLoader cl;
                    ConfigProperty configProperty = (ConfigProperty)annotation.getAnnotation();
                    if (trace) {
                        log.trace((Object)("Processing: " + configProperty));
                    }
                    if (configProperty.ignore()) {
                        return md;
                    }
                    cfgMeta = new ConfigPropertyMetaData();
                    cfgMeta.setName(this.getConfigPropertyName(annotation));
                    if (configProperty.defaultValue() != null && !configProperty.defaultValue().equals("")) {
                        cfgMeta.setValue(configProperty.defaultValue());
                    }
                    if (!Object.class.equals((Object)configProperty.type())) {
                        cfgMeta.setType(configProperty.type().getName());
                    } else {
                        cfgMeta.setType(this.getConfigPropertyType(annotation));
                    }
                    cfgMeta.setIgnore(configProperty.ignore());
                    String[] description = configProperty.description();
                    if (description != null) {
                        if (cfgMeta.getDescriptions() == null) {
                            DescriptionsImpl descsImpl = new DescriptionsImpl();
                            cfgMeta.setDescriptions((Descriptions)descsImpl);
                        }
                        for (String desc : description) {
                            DescriptionImpl descImpl = new DescriptionImpl();
                            descImpl.setDescription(desc);
                            ((DescriptionsImpl)cfgMeta.getDescriptions()).add((MappableMetaData)descImpl);
                        }
                    }
                    if (!this.hasInterface(attachedClass = Class.forName(attachedClassName = annotation.getClassName(), true, cl = SecurityActions.getThreadContextClassLoader()), "javax.resource.spi.ResourceAdapter")) break block17;
                    if (md.getRa() == null) {
                        md.setRa(new ResourceAdapterMetaData());
                    }
                    if (md.getRa().getConfigProperty() == null) {
                        md.getRa().setConfigProperty(new ArrayList());
                    }
                    for (ConfigPropertyMetaData cpMeta : md.getRa().getConfigProperty()) {
                        if (!cpMeta.getName().equals(cfgMeta.getName())) continue;
                        return md;
                    }
                    md.getRa().getConfigProperty().add(cfgMeta);
                    break block18;
                }
                if (!this.hasInterface(attachedClass, "javax.resource.spi.ManagedConnectionFactory")) break block19;
                this.createConDefs(md);
                for (ConnectionDefinitionMetaData cdMeta : md.getRa().getOutboundRa().getConDefs()) {
                    if (!attachedClassName.equals(cdMeta.getManagedConnectionFactoryClass())) continue;
                    if (cdMeta.getConfigProps() == null) {
                        cdMeta.setConfigProps(new ArrayList());
                    }
                    for (ConfigPropertyMetaData cpMeta : cdMeta.getConfigProps()) {
                        if (!cpMeta.getName().equals(cfgMeta.getName())) continue;
                        return md;
                    }
                    cdMeta.getConfigProps().add(cfgMeta);
                }
                break block18;
            }
            if (!this.hasInterface(attachedClass, "javax.resource.spi.ActivationSpec")) break block18;
            this.createMessageListeners(md);
            for (MessageListenerMetaData mlMeta : md.getRa().getInboundRa().getMessageAdapter().getMessageListeners()) {
                if (!attachedClassName.equals(mlMeta.getActivationSpecType().getAsClass())) continue;
                if (mlMeta.getActivationSpecType().getConfigProps() == null) {
                    mlMeta.getActivationSpecType().setConfigProps(new ArrayList());
                }
                for (ConfigPropertyMetaData cpMeta : mlMeta.getActivationSpecType().getConfigProps()) {
                    if (!cpMeta.getName().equals(cfgMeta.getName())) continue;
                    return md;
                }
                mlMeta.getActivationSpecType().getConfigProps().add(cfgMeta);
            }
        }
        return md;
    }

    private boolean hasInterface(Class c, String targetClassName) {
        for (Class<?> face : c.getInterfaces()) {
            if (face.getName().equals(targetClassName)) {
                return true;
            }
            for (Class<?> face2 : face.getInterfaces()) {
                if (face2.getName().equals(targetClassName)) {
                    return true;
                }
                if (!this.hasInterface(face2, targetClassName)) continue;
                return true;
            }
        }
        if (null != c.getSuperclass()) {
            return this.hasInterface(c.getSuperclass(), targetClassName);
        }
        return false;
    }

    private ConnectorMetaData attachAuthenticationMechanism(ConnectorMetaData md, AuthenticationMechanism authenticationmechanism) throws Exception {
        if (md.getRa() == null) {
            md.setRa(new ResourceAdapterMetaData());
        }
        if (md.getRa().getOutboundRa() == null) {
            md.getRa().setOutboundRa(new OutboundRaMetaData());
        }
        if (md.getRa().getOutboundRa().getAuthMechanisms() == null) {
            md.getRa().getOutboundRa().setAuthMechanisms(new ArrayList());
        }
        AuthenticationMechanismMetaData ammd = new AuthenticationMechanismMetaData();
        ammd.setAuthenticationMechanismType(authenticationmechanism.authMechanism());
        String credentialInterfaceClass = null;
        if (authenticationmechanism.credentialInterface().equals((Object)AuthenticationMechanism.CredentialInterface.GenericCredential)) {
            credentialInterfaceClass = "javax.resource.spi.security.GenericCredential";
        } else if (authenticationmechanism.credentialInterface().equals((Object)AuthenticationMechanism.CredentialInterface.GSSCredential)) {
            credentialInterfaceClass = "org.ietf.jgss.GSSCredential";
        } else if (authenticationmechanism.credentialInterface().equals((Object)AuthenticationMechanism.CredentialInterface.PasswordCredential)) {
            credentialInterfaceClass = "javax.resource.spi.security.PasswordCredential";
        }
        ammd.setCredentialInterfaceClass(credentialInterfaceClass);
        String[] description = authenticationmechanism.description();
        if (description != null) {
            if (ammd.getDescriptions() == null) {
                DescriptionsImpl descsImpl = new DescriptionsImpl();
                ammd.setDescriptions((Descriptions)descsImpl);
            }
            for (String desc : description) {
                DescriptionImpl descImpl = new DescriptionImpl();
                descImpl.setDescription(desc);
                ((DescriptionsImpl)ammd.getDescriptions()).add((MappableMetaData)descImpl);
            }
        }
        md.getRa().getOutboundRa().getAuthMechanisms().add(ammd);
        return md;
    }

    private ConnectorMetaData processAdministeredObject(ConnectorMetaData md, AnnotationRepository annotationRepository) throws Exception {
        Collection values = annotationRepository.getAnnotation(AdministeredObject.class);
        if (values != null) {
            for (Annotation annotation : values) {
                AdministeredObject a = (AdministeredObject)annotation.getAnnotation();
                if (trace) {
                    log.trace((Object)("Processing: " + a));
                }
                md = this.attachAdministeredObject(md, a);
            }
        }
        return md;
    }

    private ConnectorMetaData attachAdministeredObject(ConnectorMetaData md, AdministeredObject a) throws Exception {
        this.createAdminObject(md);
        String aoName = null;
        if (a.adminObjectInterfaces().length > 0) {
            aoName = ((Class)Array.get(a.adminObjectInterfaces(), 0)).getName();
        }
        AdminObjectMetaData aomd = new AdminObjectMetaData();
        aomd.setAdminObjectInterfaceClass(aoName);
        md.getRa().getAdminObjects().add(aomd);
        return md;
    }

    private ConnectorMetaData processActivation(ConnectorMetaData md, AnnotationRepository annotationRepository) throws Exception {
        Collection values = annotationRepository.getAnnotation(Activation.class);
        if (values != null) {
            for (Annotation annotation : values) {
                md = this.attachActivation(md, annotation);
            }
        }
        return md;
    }

    private ConnectorMetaData attachActivation(ConnectorMetaData md, Annotation annotation) throws Exception {
        Activation activation = (Activation)annotation.getAnnotation();
        if (trace) {
            log.trace((Object)("Processing: " + activation));
        }
        this.createMessageListeners(md);
        for (Class asClass : activation.messageListeners()) {
            ActivationspecMetaData asMeta = new ActivationspecMetaData();
            asMeta.setAsClass(annotation.getClassName());
            MessageListenerMetaData mlMeta = new MessageListenerMetaData();
            mlMeta.setActivationSpecType(asMeta);
            mlMeta.setType(asClass.getName());
            md.getRa().getInboundRa().getMessageAdapter().getMessageListeners().add(mlMeta);
        }
        return md;
    }

    private void createMessageListeners(ConnectorMetaData md) throws Exception {
        if (md.getRa() == null) {
            md.setRa(new ResourceAdapterMetaData());
        }
        if (md.getRa().getInboundRa() == null) {
            md.getRa().setInboundRa(new InboundRaMetaData());
        }
        if (md.getRa().getInboundRa().getMessageAdapter() == null) {
            md.getRa().getInboundRa().setMessageAdapter(new MessageAdapterMetaData());
        }
        if (md.getRa().getInboundRa().getMessageAdapter().getMessageListeners() == null) {
            md.getRa().getInboundRa().getMessageAdapter().setMessageListeners(new ArrayList());
        }
    }

    private void createAdminObject(ConnectorMetaData md) throws Exception {
        if (md.getRa() == null) {
            md.setRa(new ResourceAdapterMetaData());
        }
        if (md.getRa().getAdminObjects() == null) {
            md.getRa().setAdminObjects(new ArrayList());
        }
    }

    private void createConDefs(ConnectorMetaData md) throws Exception {
        if (md.getRa() == null) {
            md.setRa(new ResourceAdapterMetaData());
        }
        if (md.getRa().getOutboundRa() == null) {
            md.getRa().setOutboundRa(new OutboundRaMetaData());
        }
        if (md.getRa().getOutboundRa().getConDefs() == null) {
            md.getRa().getOutboundRa().setConDefs(new ArrayList());
        }
    }

    private String getConfigPropertyName(Annotation annotation) throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException {
        if (AnnotationType.FIELD.equals((Object)annotation.getType())) {
            return annotation.getMemberName();
        }
        if (AnnotationType.METHOD.equals((Object)annotation.getType())) {
            String name = annotation.getMemberName();
            if (name.startsWith("set")) {
                name = name.substring(3);
            } else if (name.startsWith("get")) {
                name = name.substring(3);
            } else if (name.startsWith("is")) {
                name = name.substring(2);
            }
            if (name.length() > 1) {
                return Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
            return Character.toString(Character.toLowerCase(name.charAt(0)));
        }
        throw new IllegalArgumentException("Unknown annotation: " + annotation);
    }

    private String getConfigPropertyType(Annotation annotation) throws ClassNotFoundException {
        block10: {
            block9: {
                if (!AnnotationType.FIELD.equals((Object)annotation.getType())) break block9;
                ClassLoader cl = SecurityActions.getThreadContextClassLoader();
                Class<?> clz = Class.forName(annotation.getClassName(), true, cl);
                while (!Object.class.equals(clz)) {
                    try {
                        Field field = clz.getDeclaredField(annotation.getMemberName());
                        return field.getType().getName();
                    }
                    catch (NoSuchFieldException nsfe) {
                        clz = clz.getSuperclass();
                    }
                }
                break block10;
            }
            if (!AnnotationType.METHOD.equals((Object)annotation.getType())) break block10;
            ClassLoader cl = SecurityActions.getThreadContextClassLoader();
            Class<?> clz = Class.forName(annotation.getClassName(), true, cl);
            Class[] parameters = null;
            if (annotation.getParameterTypes() != null) {
                parameters = new Class[annotation.getParameterTypes().length];
                for (int i = 0; i < annotation.getParameterTypes().length; ++i) {
                    String parameter = annotation.getParameterTypes()[i];
                    parameters[i] = Class.forName(parameter, true, cl);
                }
            }
            while (!Object.class.equals(clz)) {
                try {
                    Method method = clz.getDeclaredMethod(annotation.getMemberName(), parameters);
                    if (Void.TYPE.equals(method.getReturnType())) {
                        if (parameters == null || parameters.length <= 0) continue;
                        return parameters[0].getName();
                    }
                    return method.getReturnType().getName();
                }
                catch (NoSuchMethodException nsme) {
                    clz = clz.getSuperclass();
                }
            }
        }
        throw new IllegalArgumentException("Unknown annotation: " + annotation);
    }
}

