/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.jboss.jca.common.metadata.jbossra.JbossRa;
import org.jboss.jca.common.metadata.jbossra.JbossRaParser;
import org.jboss.jca.common.metadata.ra.RaParser;
import org.jboss.jca.common.metadata.ra.common.Connector;
import org.jboss.logging.Logger;

public class MetadataFactory {
    private static Logger log = Logger.getLogger(MetadataFactory.class);

    public Connector getStandardMetaData(File root) throws Exception {
        Connector result = null;
        File metadataFile = new File(root, "/META-INF/ra.xml");
        if (metadataFile.exists()) {
            InputStream input = null;
            String url = metadataFile.getAbsolutePath();
            try {
                long start = System.currentTimeMillis();
                input = new FileInputStream(metadataFile);
                result = new RaParser().parse(input);
                log.debugf("Total parse for %s took %d ms", new Object[]{url, System.currentTimeMillis() - start});
                log.tracef("successufully deployed $s", new Object[]{result.toString()});
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Error during parsing: %s", new Object[]{url});
                throw e;
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        return result;
    }

    public JbossRa getJBossMetaData(File root) throws Exception {
        JbossRa result = null;
        File metadataFile = new File(root, "/META-INF/jboss-ra.xml");
        if (metadataFile.exists()) {
            InputStream input = null;
            String url = metadataFile.getAbsolutePath();
            try {
                long start = System.currentTimeMillis();
                input = new FileInputStream(metadataFile);
                result = new JbossRaParser().parse(input);
                log.debugf("Total parse for $s took %d ms", new Object[]{url, System.currentTimeMillis() - start});
                log.tracef("successufully deployed $s", new Object[]{result.toString()});
            }
            catch (Exception e) {
                log.error((Object)("Error during parsing: " + url), (Throwable)e);
                throw e;
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        return result;
    }
}

