/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.jbossra;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.metadata.MetadataParser;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.jbossra.JbossRa;
import org.jboss.jca.common.metadata.jbossra.jbossra10.JbossRa10;
import org.jboss.jca.common.metadata.jbossra.jbossra20.BeanValidationGroup;
import org.jboss.jca.common.metadata.jbossra.jbossra20.JbossRa20;
import org.jboss.jca.common.metadata.jbossra.jbossra20.OverrideElementAttribute;
import org.jboss.jca.common.metadata.jbossra.jbossra20.RaConfigProperty;

public class JbossRaParser
implements MetadataParser<JbossRa> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JbossRa parse(InputStream xmlInputStream) throws Exception {
        void var3_6;
        XMLStreamReader reader = null;
        Object var3_3 = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            reader = inputFactory.createXMLStreamReader(xmlInputStream);
            switch (reader.nextTag()) {
                case 2: {
                    return var3_6;
                }
                case 1: {
                    if ("http://www.jboss.org/schema/ra".equals(reader.getNamespaceURI())) {
                        switch (Tag.forName(reader.getLocalName())) {
                            case JBOSSRA: {
                                JbossRa10 jbossRa10 = this.parseJbossRa10(reader);
                                return var3_6;
                            }
                        }
                        throw new ParserException("Unexpected element:" + reader.getLocalName());
                    }
                    if (!"http://www.jboss.org/schema/ra/2.0".equals(reader.getNamespaceURI())) throw new ParserException(String.format("Namespace %s is not supported by %s parser", reader.getNamespaceURI(), this.getClass().getName()));
                    switch (Tag.forName(reader.getLocalName())) {
                        case JBOSSRA: {
                            JbossRa20 jbossRa20 = this.parseJbossRa20(reader);
                            return var3_6;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (XMLStreamException e) {
            return var3_6;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private JbossRa20 parseJbossRa20(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList raConfigProperties = new ArrayList();
        ArrayList<BeanValidationGroup> beanValidationGroups = new ArrayList<BeanValidationGroup>();
        String bootStrapContext = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.JBOSSRA) {
                        raConfigProperties.trimToSize();
                        beanValidationGroups.trimToSize();
                        return new JbossRa20(raConfigProperties, bootStrapContext, beanValidationGroups);
                    }
                    if (JbossRa10.Tag.forName(reader.getLocalName()) != JbossRa10.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (JbossRa20.Tag.forName(reader.getLocalName())) {
                        case RA_CONFIG_PROPERTY: {
                            raConfigProperties.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                        case BOOTSTRAP_CONTEXT: {
                            bootStrapContext = reader.getElementText();
                            break block0;
                        }
                        case BEAN_VALIDATION_GROUPS: {
                            beanValidationGroups.add(this.parseBeanValidationGroups(reader));
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    private JbossRa10 parseJbossRa10(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList raConfigProperties = new ArrayList();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.JBOSSRA) {
                        raConfigProperties.trimToSize();
                        return new JbossRa10(raConfigProperties);
                    }
                    if (JbossRa10.Tag.forName(reader.getLocalName()) != JbossRa10.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (JbossRa10.Tag.forName(reader.getLocalName())) {
                        case RA_CONFIG_PROPERTY: {
                            raConfigProperties.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    private RaConfigProperty<?> parseConfigProperty(XMLStreamReader reader) throws XMLStreamException, ParserException {
        String value = null;
        String type = null;
        String name = null;
        OverrideElementAttribute overrideElementAttribute = OverrideElementAttribute.forName(reader.getAttributeValue(0));
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (JbossRa10.Tag.forName(reader.getLocalName()) == JbossRa10.Tag.RA_CONFIG_PROPERTY || JbossRa20.Tag.forName(reader.getLocalName()) == JbossRa20.Tag.RA_CONFIG_PROPERTY) {
                        return RaConfigProperty.buildRaConfigProperty(name, value, type, overrideElementAttribute);
                    }
                    if (JbossRa10.Tag.forName(reader.getLocalName()) != JbossRa10.Tag.UNKNOWN || JbossRa20.Tag.forName(reader.getLocalName()) != JbossRa20.Tag.UNKNOWN || RaConfigProperty.Tag.forName(reader.getLocalName()) != RaConfigProperty.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (RaConfigProperty.Tag.forName(reader.getLocalName())) {
                        case RA_CONFIG_PROPERTY_NAME: {
                            name = reader.getElementText();
                            break block0;
                        }
                        case RA_CONFIG_PROPERTY_VALUE: {
                            value = reader.getElementText();
                            break block0;
                        }
                        case RA_CONFIG_PROPERTY_TYPE: {
                            type = reader.getElementText();
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    private BeanValidationGroup parseBeanValidationGroups(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<String> beanValidationGroup = new ArrayList<String>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (JbossRa20.Tag.forName(reader.getLocalName()) == JbossRa20.Tag.BEAN_VALIDATION_GROUPS) {
                        beanValidationGroup.trimToSize();
                        return new BeanValidationGroup(beanValidationGroup);
                    }
                    if (JbossRa10.Tag.forName(reader.getLocalName()) != JbossRa10.Tag.UNKNOWN || JbossRa20.Tag.forName(reader.getLocalName()) != JbossRa20.Tag.UNKNOWN || BeanValidationGroup.Tag.forName(reader.getLocalName()) != BeanValidationGroup.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (BeanValidationGroup.Tag.forName(reader.getLocalName())) {
                        case BEAN_VALIDATION_GROUP: {
                            beanValidationGroup.add(reader.getElementText());
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    public static enum Tag {
        UNKNOWN(null),
        JBOSSRA("jboss-ra");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

