/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ra.common;

public enum CredentialInterfaceEnum {
    PASSWORD("javax.resource.spi.security.PasswordCredential"),
    GSS("org.ietf.jgss.GSSCredential"),
    GENERIC("javax.resource.spi.security.GenericCredential");

    private final String fullQualifiedName;

    private CredentialInterfaceEnum(String name) {
        this.fullQualifiedName = name;
    }

    public static CredentialInterfaceEnum forName(String fullQualifiedName) throws IllegalArgumentException {
        if ("javax.resource.spi.security.PasswordCredential".equals(fullQualifiedName)) {
            return PASSWORD;
        }
        if ("org.ietf.jgss.GSSCredential".equals(fullQualifiedName)) {
            return GSS;
        }
        if ("javax.resource.spi.security.GenericCredential".equals(fullQualifiedName)) {
            return GENERIC;
        }
        throw new IllegalArgumentException("fullQualifiedName should be one of javax.resource.spi.security.PasswordCredential; org.ietf.jgss.GSSCredential;javax.resource.spi.security.GenericCredential");
    }

    public String getFullQualifiedName() {
        return this.fullQualifiedName;
    }
}

