/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ra.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jca.common.metadata.ra.common.IdDecoratedMetadata;
import org.jboss.jca.common.metadata.ra.common.LocalizedXsdString;

public class LicenseType
implements IdDecoratedMetadata {
    private static final long serialVersionUID = 1590514246054447090L;
    private final ArrayList<LocalizedXsdString> description;
    private final boolean licenseRequired;
    private final String id;

    public LicenseType(ArrayList<LocalizedXsdString> description, boolean licenseRequired, String id) {
        this.description = description;
        this.licenseRequired = licenseRequired;
        this.id = id;
    }

    public List<LocalizedXsdString> getDescription() {
        return Collections.unmodifiableList(this.description);
    }

    public boolean isLicenseRequired() {
        return this.licenseRequired;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.licenseRequired ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseType)) {
            return false;
        }
        LicenseType other = (LicenseType)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.licenseRequired == other.licenseRequired;
    }

    public String toString() {
        return "LicenseType [description=" + this.description + ", licenseRequired=" + this.licenseRequired + ", id=" + this.id + "]";
    }

    public static enum Attribute {
        ID("id");

        private final String name;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }
    }

    public static enum Tag {
        UNKNOWN(null),
        DESCRIPTION("description"),
        LICENSE_REQUIRED("license-required");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

