/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public class StatementImpl
implements Statement {
    private static final long serialVersionUID = 3361665706947342366L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private final Boolean sharePreparedStatements;
    private final Long preparedStatementsCacheSize;
    private final Statement.TrackStatementsEnum trackStatements;

    public StatementImpl(Boolean sharePreparedStatements, Long preparedStatementsCacheSize, Statement.TrackStatementsEnum trackStatements) throws ValidateException {
        this.sharePreparedStatements = sharePreparedStatements;
        this.preparedStatementsCacheSize = preparedStatementsCacheSize;
        this.trackStatements = trackStatements;
        this.validate();
    }

    public final Boolean isSharePreparedStatements() {
        return this.sharePreparedStatements;
    }

    public final Long getPreparedStatementsCacheSize() {
        return this.preparedStatementsCacheSize;
    }

    public final Statement.TrackStatementsEnum getTrackStatements() {
        return this.trackStatements;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.preparedStatementsCacheSize == null ? 0 : this.preparedStatementsCacheSize.hashCode());
        result = 31 * result + (this.sharePreparedStatements == null ? 0 : this.sharePreparedStatements.hashCode());
        result = 31 * result + (this.trackStatements == null ? 0 : this.trackStatements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatementImpl)) {
            return false;
        }
        StatementImpl other = (StatementImpl)obj;
        if (this.preparedStatementsCacheSize == null ? other.preparedStatementsCacheSize != null : !this.preparedStatementsCacheSize.equals(other.preparedStatementsCacheSize)) {
            return false;
        }
        if (this.sharePreparedStatements == null ? other.sharePreparedStatements != null : !this.sharePreparedStatements.equals(other.sharePreparedStatements)) {
            return false;
        }
        return this.trackStatements == other.trackStatements;
    }

    public String toString() {
        return "StatementImpl [sharePreparedStatements=" + this.sharePreparedStatements + ", preparedStatementsCacheSize=" + this.preparedStatementsCacheSize + ", trackStatements=" + this.trackStatements + "]";
    }

    public void validate() throws ValidateException {
        if (this.preparedStatementsCacheSize != null && this.preparedStatementsCacheSize < 0L) {
            throw new ValidateException(bundle.invalidNegative(Statement.Tag.PREPAREDSTATEMENTCACHESIZE.getLocalName()));
        }
    }
}

