/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.common;

import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.AbstractParser;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.common.CommonAdminObjectImpl;
import org.jboss.jca.common.metadata.common.CommonConnDefImpl;
import org.jboss.jca.common.metadata.common.CommonTimeOutImpl;
import org.jboss.jca.common.metadata.common.CommonValidationImpl;
import org.jboss.logging.Messages;

public abstract class CommonIronJacamarParser
extends AbstractParser {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    protected CommonConnDef parseConnectionDefinitions(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        HashMap<String, String> configProperties = new HashMap<String, String>();
        CommonSecurity security = null;
        CommonTimeOut timeOut = null;
        CommonValidation validation = null;
        CommonXaPool pool = null;
        Recovery recovery = null;
        boolean useJavaContext = true;
        String className = null;
        boolean enabled = true;
        String jndiName = null;
        String poolName = null;
        boolean useCcm = true;
        int attributeSize = reader.getAttributeCount();
        boolean isXa = false;
        block21: for (int i = 0; i < attributeSize; ++i) {
            CommonConnDef.Attribute attribute = CommonConnDef.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block21;
                }
                case JNDINAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block21;
                }
                case CLASS_NAME: {
                    className = this.attributeAsString(reader, attribute.getLocalName());
                    continue block21;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block21;
                }
                case USEJAVACONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block21;
                }
                case USECCM: {
                    useCcm = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block21;
                }
                default: {
                    throw new ParserException(bundle.unexpectedAttribute(attribute.getLocalName(), reader.getLocalName()));
                }
            }
        }
        if (jndiName == null || jndiName.trim().equals("")) {
            throw new ParserException(bundle.missingJndiName(reader.getLocalName()));
        }
        while (reader.hasNext()) {
            block8 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapter.Tag.forName((String)reader.getLocalName()) == ResourceAdapter.Tag.CONNECTION_DEFINITION) {
                        return new CommonConnDefImpl(configProperties, className, jndiName, poolName, enabled, useJavaContext, useCcm, (CommonPool)pool, timeOut, validation, security, recovery);
                    }
                    if (CommonConnDef.Tag.forName((String)reader.getLocalName()) != CommonConnDef.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonConnDef.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            configProperties.put(this.attributeAsString(reader, "name"), this.elementAsString(reader));
                            break block8;
                        }
                        case SECURITY: {
                            security = this.parseSecuritySettings(reader);
                            break block8;
                        }
                        case TIMEOUT: {
                            timeOut = this.parseTimeOut(reader, isXa);
                            break block8;
                        }
                        case VALIDATION: {
                            validation = this.parseValidation(reader);
                            break block8;
                        }
                        case XA_POOL: {
                            if (pool != null) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            pool = this.parseXaPool(reader);
                            isXa = true;
                            break block8;
                        }
                        case POOL: {
                            if (pool != null) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            pool = this.parsePool(reader);
                            break block8;
                        }
                        case RECOVERY: {
                            recovery = this.parseRecovery(reader);
                            break block8;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private CommonValidation parseValidation(XMLStreamReader reader) throws XMLStreamException, ParserException {
        boolean useFastFail = false;
        boolean backgroundValidation = false;
        Long backgroundValidationMillis = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (CommonConnDef.Tag.forName((String)reader.getLocalName()) == CommonConnDef.Tag.VALIDATION) {
                        return new CommonValidationImpl(backgroundValidation, backgroundValidationMillis, useFastFail);
                    }
                    if (CommonValidation.Tag.forName((String)reader.getLocalName()) != CommonValidation.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonValidation.Tag.forName((String)reader.getLocalName())) {
                        case BACKGROUNDVALIDATIONMILLIS: {
                            backgroundValidationMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case BACKGROUNDVALIDATION: {
                            backgroundValidation = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USEFASTFAIL: {
                            useFastFail = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private CommonTimeOut parseTimeOut(XMLStreamReader reader, boolean isXa) throws XMLStreamException, ParserException, ValidateException {
        Long blockingTimeoutMillis = null;
        Long allocationRetryWaitMillis = null;
        Long idleTimeoutMinutes = null;
        Integer allocationRetry = null;
        Integer xaResourceTimeout = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (CommonConnDef.Tag.forName((String)reader.getLocalName()) == CommonConnDef.Tag.TIMEOUT) {
                        return new CommonTimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout);
                    }
                    if (CommonTimeOut.Tag.forName((String)reader.getLocalName()) != CommonTimeOut.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonTimeOut.Tag.forName((String)reader.getLocalName())) {
                        case ALLOCATIONRETRYWAITMILLIS: {
                            allocationRetryWaitMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case ALLOCATIONRETRY: {
                            allocationRetry = this.elementAsInteger(reader);
                            break block0;
                        }
                        case BLOCKINGTIMEOUTMILLIS: {
                            blockingTimeoutMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case IDLETIMEOUTMINUTES: {
                            idleTimeoutMinutes = this.elementAsLong(reader);
                            break block0;
                        }
                        case XARESOURCETIMEOUT: {
                            if (!isXa) {
                                throw new ParserException(bundle.unsupportedElement(reader.getLocalName()));
                            }
                            xaResourceTimeout = this.elementAsInteger(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected CommonAdminObject parseAdminObjects(XMLStreamReader reader) throws XMLStreamException, ParserException {
        HashMap<String, String> configProperties = new HashMap<String, String>();
        boolean useJavaContext = true;
        String className = null;
        boolean enabled = true;
        String jndiName = null;
        String poolName = null;
        int attributeSize = reader.getAttributeCount();
        block14: for (int i = 0; i < attributeSize; ++i) {
            CommonAdminObject.Attribute attribute = CommonAdminObject.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block14;
                }
                case JNDINAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block14;
                }
                case CLASS_NAME: {
                    className = this.attributeAsString(reader, attribute.getLocalName());
                    continue block14;
                }
                case USEJAVACONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block14;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block14;
                }
                default: {
                    throw new ParserException(bundle.unexpectedAttribute(attribute.getLocalName(), reader.getLocalName()));
                }
            }
        }
        if (jndiName == null || jndiName.trim().equals("")) {
            throw new ParserException(bundle.missingJndiName(reader.getLocalName()));
        }
        while (reader.hasNext()) {
            block7 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapter.Tag.forName((String)reader.getLocalName()) == ResourceAdapter.Tag.ADMIN_OBJECT) {
                        return new CommonAdminObjectImpl(configProperties, className, jndiName, poolName, enabled, useJavaContext);
                    }
                    if (CommonAdminObject.Tag.forName((String)reader.getLocalName()) != CommonAdminObject.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonAdminObject.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            configProperties.put(this.attributeAsString(reader, "name"), this.elementAsString(reader));
                            break block7;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }
}

