/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.jboss.jca.common.CommonLogger;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.metadata.ironjacamar.v11.IronJacamarParser;
import org.jboss.jca.common.metadata.ra.RaParser;
import org.jboss.logging.Logger;

public class MetadataFactory {
    private static CommonLogger log = (CommonLogger)Logger.getMessageLogger(CommonLogger.class, (String)MetadataFactory.class.getName());

    public Connector getStandardMetaData(File root) throws Exception {
        Connector result = null;
        File metadataFile = new File(root, "/META-INF/ra.xml");
        if (metadataFile.exists()) {
            InputStream input = null;
            String url = metadataFile.getAbsolutePath();
            try {
                long start = System.currentTimeMillis();
                input = new FileInputStream(metadataFile);
                result = new RaParser().parse(input);
                log.debugf("Total parse for %s took %d ms", url, System.currentTimeMillis() - start);
            }
            catch (Exception e) {
                log.parsingErrorRaXml(url, e);
                throw e;
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        } else {
            log.tracef("metadata file %s does not exist", metadataFile.toString());
        }
        return result;
    }

    public IronJacamar getIronJacamarMetaData(File root) throws Exception {
        IronJacamar result = null;
        File metadataFile = new File(root, "/META-INF/ironjacamar.xml");
        if (metadataFile.exists()) {
            InputStream input = null;
            String url = metadataFile.getAbsolutePath();
            try {
                long start = System.currentTimeMillis();
                input = new FileInputStream(metadataFile);
                result = new IronJacamarParser().parse(input);
                log.debugf("Total parse for %s took %d ms", url, System.currentTimeMillis() - start);
            }
            catch (Exception e) {
                log.parsingErrorIronJacamarXml(url, e);
                throw e;
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        return result;
    }
}

