/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.common.v11;

import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.v11.CommonConnDef;
import org.jboss.jca.common.api.metadata.resourceadapter.v11.ResourceAdapter;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.common.v11.CommonConnDefImpl;
import org.jboss.logging.Messages;

public abstract class CommonIronJacamarParser
extends org.jboss.jca.common.metadata.common.v10.CommonIronJacamarParser {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    protected CommonConnDef parseConnectionDefinitions(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        HashMap<String, String> configProperties = new HashMap<String, String>();
        CommonSecurity security = null;
        CommonTimeOut timeOut = null;
        CommonValidation validation = null;
        CommonXaPool pool = null;
        Recovery recovery = null;
        Boolean useJavaContext = Boolean.TRUE;
        String className = null;
        Boolean enabled = Boolean.TRUE;
        String jndiName = null;
        String poolName = null;
        Boolean useCcm = Boolean.TRUE;
        Boolean sharable = Boolean.TRUE;
        Boolean enlistment = Boolean.TRUE;
        int attributeSize = reader.getAttributeCount();
        Boolean isXa = Boolean.FALSE;
        block23: for (int i = 0; i < attributeSize; ++i) {
            CommonConnDef.Attribute attribute = CommonConnDef.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block23;
                }
                case JNDI_NAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block23;
                }
                case CLASS_NAME: {
                    className = this.attributeAsString(reader, attribute.getLocalName());
                    continue block23;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block23;
                }
                case USE_JAVA_CONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block23;
                }
                case USE_CCM: {
                    useCcm = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block23;
                }
                case SHARABLE: {
                    sharable = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block23;
                }
                case ENLISTMENT: {
                    enlistment = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block23;
                }
                default: {
                    throw new ParserException(bundle.unexpectedAttribute(attribute.getLocalName(), reader.getLocalName()));
                }
            }
        }
        if (jndiName == null || jndiName.trim().equals("")) {
            throw new ParserException(bundle.missingJndiName(reader.getLocalName()));
        }
        while (reader.hasNext()) {
            block10 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapter.Tag.forName((String)reader.getLocalName()) == ResourceAdapter.Tag.CONNECTION_DEFINITION) {
                        return new CommonConnDefImpl(configProperties, className, jndiName, poolName, enabled, useJavaContext, useCcm, sharable, enlistment, (CommonPool)pool, timeOut, validation, security, recovery);
                    }
                    if (CommonConnDef.Tag.forName((String)reader.getLocalName()) != CommonConnDef.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonConnDef.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            configProperties.put(this.attributeAsString(reader, "name"), this.elementAsString(reader));
                            break block10;
                        }
                        case SECURITY: {
                            security = this.parseSecuritySettings(reader);
                            break block10;
                        }
                        case TIMEOUT: {
                            timeOut = this.parseTimeOut(reader, isXa);
                            break block10;
                        }
                        case VALIDATION: {
                            validation = this.parseValidation(reader);
                            break block10;
                        }
                        case XA_POOL: {
                            if (pool != null) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            pool = this.parseXaPool(reader);
                            isXa = true;
                            break block10;
                        }
                        case POOL: {
                            if (pool != null) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            pool = this.parsePool(reader);
                            break block10;
                        }
                        case RECOVERY: {
                            recovery = this.parseRecovery(reader);
                            break block10;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }
}

