/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ironjacamar.v11;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.common.v11.CommonConnDef;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.MetadataParser;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.common.v11.CommonIronJacamarParser;
import org.jboss.jca.common.metadata.ironjacamar.v11.IronJacamarImpl;
import org.jboss.logging.Messages;

public class IronJacamarParser
extends CommonIronJacamarParser
implements MetadataParser<IronJacamar> {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    @Override
    public IronJacamar parse(InputStream xmlInputStream) throws Exception {
        XMLStreamReader reader = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        reader = inputFactory.createXMLStreamReader(xmlInputStream);
        return this.parse(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IronJacamar parse(XMLStreamReader reader) throws Exception {
        IronJacamar ironJacamar = null;
        try {
            int iterate;
            try {
                iterate = reader.nextTag();
            }
            catch (XMLStreamException e) {
                iterate = reader.nextTag();
            }
            switch (iterate) {
                case 2: {
                    return ironJacamar;
                }
                case 1: {
                    switch (Tag.forName(reader.getLocalName())) {
                        case IRONJACAMAR: {
                            ironJacamar = this.parseIronJacamar(reader);
                            return ironJacamar;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private IronJacamar parseIronJacamar(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        ArrayList<CommonConnDef> connectionDefinitions = null;
        ArrayList<CommonAdminObject> adminObjects = null;
        ArrayList<String> beanValidationGroups = null;
        String bootstrapContext = null;
        TransactionSupportEnum transactionSupport = null;
        HashMap<String, String> configProperties = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.IRONJACAMAR) {
                        return new IronJacamarImpl(transactionSupport, configProperties, adminObjects, connectionDefinitions, beanValidationGroups, bootstrapContext);
                    }
                    if (IronJacamar.Tag.forName((String)reader.getLocalName()) != IronJacamar.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (IronJacamar.Tag.forName((String)reader.getLocalName())) {
                        case ADMIN_OBJECTS: 
                        case CONNECTION_DEFINITIONS: 
                        case BEAN_VALIDATION_GROUPS: {
                            break block0;
                        }
                        case ADMIN_OBJECT: {
                            if (adminObjects == null) {
                                adminObjects = new ArrayList<CommonAdminObject>();
                            }
                            adminObjects.add(this.parseAdminObjects(reader));
                            break block0;
                        }
                        case CONNECTION_DEFINITION: {
                            if (connectionDefinitions == null) {
                                connectionDefinitions = new ArrayList<CommonConnDef>();
                            }
                            connectionDefinitions.add(this.parseConnectionDefinitions(reader));
                            break block0;
                        }
                        case BEAN_VALIDATION_GROUP: {
                            if (beanValidationGroups == null) {
                                beanValidationGroups = new ArrayList<String>();
                            }
                            beanValidationGroups.add(this.elementAsString(reader));
                            break block0;
                        }
                        case BOOTSTRAP_CONTEXT: {
                            bootstrapContext = this.elementAsString(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY: {
                            if (configProperties == null) {
                                configProperties = new HashMap<String, String>();
                            }
                            configProperties.put(this.attributeAsString(reader, "name"), this.elementAsString(reader));
                            break block0;
                        }
                        case TRANSACTION_SUPPORT: {
                            transactionSupport = TransactionSupportEnum.valueOf((String)this.elementAsString(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    public static enum Tag {
        UNKNOWN(null),
        IRONJACAMAR("ironjacamar");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

