/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.common.v11;

import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.v11.ConnDefXaPool;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonXaPoolImpl;

public class ConnDefXaPoolImpl
extends CommonXaPoolImpl
implements ConnDefXaPool {
    private static final long serialVersionUID = 1L;
    protected final Integer initialPoolSize;
    protected final Capacity capacity;

    public ConnDefXaPoolImpl(Integer minPoolSize, Integer initialPoolSize, Integer maxPoolSize, Boolean prefill, Boolean useStrictMin, FlushStrategy flushStrategy, Capacity capacity, Boolean isSameRmOverride, Boolean interleaving, Boolean padXid, Boolean wrapXaResource, Boolean noTxSeparatePool) throws ValidateException {
        super(minPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, isSameRmOverride, interleaving, padXid, wrapXaResource, noTxSeparatePool);
        this.initialPoolSize = initialPoolSize;
        this.capacity = capacity;
    }

    public Integer getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public Capacity getCapacity() {
        return this.capacity;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.initialPoolSize == null ? 7 : 7 * this.initialPoolSize.hashCode());
        result = 31 * result + (this.capacity == null ? 7 : 7 * this.capacity.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ConnDefXaPoolImpl)) {
            return false;
        }
        ConnDefXaPoolImpl other = (ConnDefXaPoolImpl)obj;
        if (this.initialPoolSize == null ? other.initialPoolSize != null : !this.initialPoolSize.equals(other.initialPoolSize)) {
            return false;
        }
        return !(this.capacity == null ? other.capacity != null : !this.capacity.equals((Object)other.capacity));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<xa-pool>");
        if (this.minPoolSize != null) {
            sb.append("<").append(ConnDefXaPool.Tag.MIN_POOL_SIZE).append(">");
            sb.append(this.minPoolSize);
            sb.append("</").append(ConnDefXaPool.Tag.MIN_POOL_SIZE).append(">");
        }
        if (this.initialPoolSize != null) {
            sb.append("<").append(ConnDefXaPool.Tag.INITIAL_POOL_SIZE).append(">");
            sb.append(this.initialPoolSize);
            sb.append("</").append(ConnDefXaPool.Tag.INITIAL_POOL_SIZE).append(">");
        }
        if (this.maxPoolSize != null) {
            sb.append("<").append(ConnDefXaPool.Tag.MAX_POOL_SIZE).append(">");
            sb.append(this.maxPoolSize);
            sb.append("</").append(ConnDefXaPool.Tag.MAX_POOL_SIZE).append(">");
        }
        if (this.prefill != null) {
            sb.append("<").append(ConnDefXaPool.Tag.PREFILL).append(">");
            sb.append(this.prefill);
            sb.append("</").append(ConnDefXaPool.Tag.PREFILL).append(">");
        }
        if (this.useStrictMin != null) {
            sb.append("<").append(ConnDefXaPool.Tag.USE_STRICT_MIN).append(">");
            sb.append(this.useStrictMin);
            sb.append("</").append(ConnDefXaPool.Tag.USE_STRICT_MIN).append(">");
        }
        if (this.flushStrategy != null) {
            sb.append("<").append(ConnDefXaPool.Tag.FLUSH_STRATEGY).append(">");
            sb.append(this.flushStrategy);
            sb.append("</").append(ConnDefXaPool.Tag.FLUSH_STRATEGY).append(">");
        }
        if (this.capacity != null) {
            sb.append("<").append(ConnDefXaPool.Tag.CAPACITY).append(">");
            sb.append(this.capacity);
            sb.append("</").append(ConnDefXaPool.Tag.CAPACITY).append(">");
        }
        if (this.isSameRmOverride != null) {
            sb.append("<").append(ConnDefXaPool.Tag.IS_SAME_RM_OVERRIDE).append(">");
            sb.append(this.isSameRmOverride);
            sb.append("</").append(ConnDefXaPool.Tag.IS_SAME_RM_OVERRIDE).append(">");
        }
        if (this.interleaving != null && Boolean.TRUE.equals(this.interleaving)) {
            sb.append("<").append(ConnDefXaPool.Tag.INTERLEAVING).append("/>");
        }
        if (this.noTxSeparatePool != null && Boolean.TRUE.equals(this.noTxSeparatePool)) {
            sb.append("<").append(ConnDefXaPool.Tag.NO_TX_SEPARATE_POOLS).append("/>");
        }
        if (this.padXid != null) {
            sb.append("<").append(ConnDefXaPool.Tag.PAD_XID).append(">");
            sb.append(this.padXid);
            sb.append("</").append(ConnDefXaPool.Tag.PAD_XID).append(">");
        }
        if (this.wrapXaResource != null) {
            sb.append("<").append(ConnDefXaPool.Tag.WRAP_XA_RESOURCE).append(">");
            sb.append(this.wrapXaResource);
            sb.append("</").append(ConnDefXaPool.Tag.WRAP_XA_RESOURCE).append(">");
        }
        sb.append("</xa-pool>");
        return sb.toString();
    }
}

