/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds.v13;

import java.util.Map;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.v12.DsPool;
import org.jboss.jca.common.api.metadata.ds.v13.DataSource;
import org.jboss.jca.common.api.validator.ValidateException;

public class DataSourceImpl
extends org.jboss.jca.common.metadata.ds.v12.DataSourceImpl
implements DataSource {
    private static final long serialVersionUID = 1L;
    protected Boolean connectable;
    protected Boolean tracking;

    public DataSourceImpl(String connectionUrl, String driverClass, String dataSourceClass, String driver, TransactionIsolation transactionIsolation, Map<String, String> connectionProperties, TimeOut timeOut, DsSecurity security, Statement statement, Validation validation, String urlDelimiter, String urlSelectorStrategyClassName, String newConnectionSql, Boolean useJavaContext, String poolName, Boolean enabled, String jndiName, Boolean spy, Boolean useccm, Boolean jta, Boolean connectable, Boolean tracking, DsPool pool) throws ValidateException {
        super(connectionUrl, driverClass, dataSourceClass, driver, transactionIsolation, connectionProperties, timeOut, security, statement, validation, urlDelimiter, urlSelectorStrategyClassName, newConnectionSql, useJavaContext, poolName, enabled, jndiName, spy, useccm, jta, pool);
        this.connectable = connectable;
        this.tracking = tracking;
    }

    public Boolean isConnectable() {
        return this.connectable;
    }

    public Boolean isTracking() {
        return this.tracking;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.connectable == null ? 0 : this.connectable.hashCode());
        result = 31 * result + (this.tracking == null ? 0 : this.tracking.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DataSourceImpl)) {
            return false;
        }
        DataSourceImpl other = (DataSourceImpl)obj;
        if (this.connectable == null ? other.connectable != null : !this.connectable.equals(other.connectable)) {
            return false;
        }
        return !(this.tracking == null ? other.tracking != null : !this.tracking.equals(other.tracking));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<datasource");
        if (this.jndiName != null) {
            sb.append(" ").append(DataSource.Attribute.JNDI_NAME).append("=\"").append(this.jndiName).append("\"");
        }
        if (this.poolName != null) {
            sb.append(" ").append(DataSource.Attribute.POOL_NAME).append("=\"").append(this.poolName).append("\"");
        }
        if (this.enabled != null) {
            sb.append(" ").append(DataSource.Attribute.ENABLED).append("=\"").append(this.enabled).append("\"");
        }
        if (this.useJavaContext != null) {
            sb.append(" ").append(DataSource.Attribute.USE_JAVA_CONTEXT);
            sb.append("=\"").append(this.useJavaContext).append("\"");
        }
        if (this.spy != null) {
            sb.append(" ").append(DataSource.Attribute.SPY).append("=\"").append(this.spy).append("\"");
        }
        if (this.useCcm != null) {
            sb.append(" ").append(DataSource.Attribute.USE_CCM).append("=\"").append(this.useCcm).append("\"");
        }
        if (this.jta != null) {
            sb.append(" ").append(DataSource.Attribute.JTA).append("=\"").append(this.jta).append("\"");
        }
        if (this.connectable != null) {
            sb.append(" ").append(DataSource.Attribute.CONNECTABLE).append("=\"").append(this.connectable).append("\"");
        }
        if (this.tracking != null) {
            sb.append(" ").append(DataSource.Attribute.TRACKING).append("=\"").append(this.tracking).append("\"");
        }
        sb.append(">");
        if (this.connectionUrl != null) {
            sb.append("<").append(DataSource.Tag.CONNECTION_URL).append(">");
            sb.append(this.connectionUrl);
            sb.append("</").append(DataSource.Tag.CONNECTION_URL).append(">");
        }
        if (this.driverClass != null) {
            sb.append("<").append(DataSource.Tag.DRIVER_CLASS).append(">");
            sb.append(this.driverClass);
            sb.append("</").append(DataSource.Tag.DRIVER_CLASS).append(">");
        }
        if (this.dataSourceClass != null) {
            sb.append("<").append(DataSource.Tag.DATASOURCE_CLASS).append(">");
            sb.append(this.dataSourceClass);
            sb.append("</").append(DataSource.Tag.DATASOURCE_CLASS).append(">");
        }
        if (this.driver != null) {
            sb.append("<").append(DataSource.Tag.DRIVER).append(">");
            sb.append(this.driver);
            sb.append("</").append(DataSource.Tag.DRIVER).append(">");
        }
        if (this.connectionProperties != null && this.connectionProperties.size() > 0) {
            for (Map.Entry entry : this.connectionProperties.entrySet()) {
                sb.append("<").append(DataSource.Tag.CONNECTION_PROPERTY);
                sb.append(" name=\"").append((String)entry.getKey()).append("\">");
                sb.append((String)entry.getValue());
                sb.append("</").append(DataSource.Tag.CONNECTION_PROPERTY).append(">");
            }
        }
        if (this.newConnectionSql != null) {
            sb.append("<").append(DataSource.Tag.NEW_CONNECTION_SQL).append(">");
            sb.append(this.newConnectionSql);
            sb.append("</").append(DataSource.Tag.NEW_CONNECTION_SQL).append(">");
        }
        if (this.transactionIsolation != null) {
            sb.append("<").append(DataSource.Tag.TRANSACTION_ISOLATION).append(">");
            sb.append(this.transactionIsolation);
            sb.append("</").append(DataSource.Tag.TRANSACTION_ISOLATION).append(">");
        }
        if (this.urlDelimiter != null) {
            sb.append("<").append(DataSource.Tag.URL_DELIMITER).append(">");
            sb.append(this.urlDelimiter);
            sb.append("</").append(DataSource.Tag.URL_DELIMITER).append(">");
        }
        if (this.urlSelectorStrategyClassName != null) {
            sb.append("<").append(DataSource.Tag.URL_SELECTOR_STRATEGY_CLASS_NAME).append(">");
            sb.append(this.urlSelectorStrategyClassName);
            sb.append("</").append(DataSource.Tag.URL_SELECTOR_STRATEGY_CLASS_NAME).append(">");
        }
        if (this.pool != null) {
            sb.append(this.pool);
        }
        if (this.security != null) {
            sb.append(this.security);
        }
        if (this.validation != null) {
            sb.append(this.validation);
        }
        if (this.timeOut != null) {
            sb.append(this.timeOut);
        }
        if (this.statement != null) {
            sb.append(this.statement);
        }
        sb.append("</datasource>");
        return sb.toString();
    }
}

