/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds.v13;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.metadata.ds.v12.DsPool;
import org.jboss.jca.common.api.metadata.ds.v12.DsXaPool;
import org.jboss.jca.common.api.metadata.ds.v13.DataSource;
import org.jboss.jca.common.api.metadata.ds.v13.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.MetadataParser;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.ds.v13.DataSourceImpl;
import org.jboss.jca.common.metadata.ds.v13.XADataSourceImpl;

public class DsParser
extends org.jboss.jca.common.metadata.ds.v12.DsParser
implements MetadataParser<DataSources> {
    @Override
    protected XaDataSource parseXADataSource(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        TransactionIsolation transactionIsolation = null;
        HashMap<String, String> xaDataSourceProperty = new HashMap<String, String>();
        TimeOut timeOutSettings = null;
        DsSecurity securitySettings = null;
        Statement statementSettings = null;
        Validation validationSettings = null;
        String urlDelimiter = null;
        String urlProperty = null;
        String urlSelectorStrategyClassName = null;
        String newConnectionSql = null;
        DsXaPool xaPool = null;
        Recovery recovery = null;
        String xaDataSourceClass = null;
        String driver = null;
        Boolean useJavaContext = Defaults.USE_JAVA_CONTEXT;
        String poolName = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        Boolean spy = Defaults.SPY;
        Boolean useCcm = Defaults.USE_CCM;
        Boolean connectable = Defaults.CONNECTABLE;
        Boolean tracking = Defaults.TRACKING;
        block30: for (XaDataSource.Attribute attribute : XaDataSource.Attribute.values()) {
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.ENABLED);
                    continue block30;
                }
                case JNDI_NAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block30;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block30;
                }
                case USE_JAVA_CONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.USE_JAVA_CONTEXT);
                    continue block30;
                }
                case SPY: {
                    spy = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.SPY);
                    continue block30;
                }
                case USE_CCM: {
                    useCcm = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.USE_CCM);
                    continue block30;
                }
                case CONNECTABLE: {
                    connectable = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.CONNECTABLE);
                    continue block30;
                }
                case TRACKING: {
                    tracking = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.TRACKING);
                    continue block30;
                }
            }
        }
        while (reader.hasNext()) {
            block10 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.XA_DATASOURCE) {
                        return new XADataSourceImpl(transactionIsolation, timeOutSettings, securitySettings, statementSettings, validationSettings, urlDelimiter, urlProperty, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, spy, useCcm, connectable, tracking, xaDataSourceProperty, xaDataSourceClass, driver, newConnectionSql, xaPool, recovery);
                    }
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) != XaDataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XaDataSource.Tag.forName((String)reader.getLocalName())) {
                        case XA_DATASOURCE_PROPERTY: {
                            this.parseConfigProperty(xaDataSourceProperty, reader);
                            break block10;
                        }
                        case XA_DATASOURCE_CLASS: {
                            xaDataSourceClass = this.elementAsString(reader);
                            break block10;
                        }
                        case DRIVER: {
                            driver = this.elementAsString(reader);
                            break block10;
                        }
                        case XA_POOL: {
                            xaPool = this.parseXaPool(reader);
                            break block10;
                        }
                        case NEW_CONNECTION_SQL: {
                            newConnectionSql = this.elementAsString(reader);
                            break block10;
                        }
                        case URL_DELIMITER: {
                            urlDelimiter = this.elementAsString(reader);
                            break block10;
                        }
                        case URL_PROPERTY: {
                            urlProperty = this.elementAsString(reader);
                            break block10;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            urlSelectorStrategyClassName = this.elementAsString(reader);
                            break block10;
                        }
                        case TRANSACTION_ISOLATION: {
                            String str = this.elementAsString(reader);
                            transactionIsolation = TransactionIsolation.forName((String)str);
                            if (transactionIsolation != null) break block10;
                            transactionIsolation = TransactionIsolation.customLevel((String)str);
                            break block10;
                        }
                        case SECURITY: {
                            securitySettings = this.parseDsSecurity(reader);
                            break block10;
                        }
                        case STATEMENT: {
                            statementSettings = this.parseStatementSettings(reader);
                            break block10;
                        }
                        case TIMEOUT: {
                            timeOutSettings = this.parseTimeOutSettings(reader);
                            break block10;
                        }
                        case VALIDATION: {
                            validationSettings = this.parseValidationSetting(reader);
                            break block10;
                        }
                        case RECOVERY: {
                            recovery = this.parseRecovery(reader);
                            break block10;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    @Override
    protected DataSource parseDataSource(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String connectionUrl = null;
        String driverClass = null;
        String dataSourceClass = null;
        String driver = null;
        TransactionIsolation transactionIsolation = null;
        HashMap<String, String> connectionProperties = new HashMap<String, String>();
        TimeOut timeOutSettings = null;
        DsSecurity securitySettings = null;
        Statement statementSettings = null;
        Validation validationSettings = null;
        String urlDelimiter = null;
        String urlSelectorStrategyClassName = null;
        String newConnectionSql = null;
        DsPool pool = null;
        Boolean useJavaContext = Defaults.USE_JAVA_CONTEXT;
        String poolName = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        Boolean spy = Defaults.SPY;
        Boolean useCcm = Defaults.USE_CCM;
        Boolean jta = Defaults.JTA;
        Boolean connectable = Defaults.CONNECTABLE;
        Boolean tracking = Defaults.TRACKING;
        block31: for (DataSource.Attribute attribute : DataSource.Attribute.values()) {
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.ENABLED);
                    continue block31;
                }
                case JNDI_NAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block31;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block31;
                }
                case USE_JAVA_CONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.USE_JAVA_CONTEXT);
                    continue block31;
                }
                case SPY: {
                    spy = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.SPY);
                    continue block31;
                }
                case USE_CCM: {
                    useCcm = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.USE_CCM);
                    continue block31;
                }
                case JTA: {
                    jta = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.JTA);
                    continue block31;
                }
                case CONNECTABLE: {
                    connectable = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.CONNECTABLE);
                    continue block31;
                }
                case TRACKING: {
                    tracking = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.TRACKING);
                    continue block31;
                }
            }
        }
        while (reader.hasNext()) {
            block11 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DATASOURCE) {
                        return new DataSourceImpl(connectionUrl, driverClass, dataSourceClass, driver, transactionIsolation, connectionProperties, timeOutSettings, securitySettings, statementSettings, validationSettings, urlDelimiter, urlSelectorStrategyClassName, newConnectionSql, useJavaContext, poolName, enabled, jndiName, spy, useCcm, jta, connectable, tracking, pool);
                    }
                    if (DataSource.Tag.forName((String)reader.getLocalName()) != DataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DataSource.Tag.forName((String)reader.getLocalName())) {
                        case CONNECTION_PROPERTY: {
                            this.parseConfigProperty(connectionProperties, reader);
                            break block11;
                        }
                        case CONNECTION_URL: {
                            connectionUrl = this.elementAsString(reader);
                            break block11;
                        }
                        case DRIVER_CLASS: {
                            driverClass = this.elementAsString(reader);
                            break block11;
                        }
                        case DATASOURCE_CLASS: {
                            dataSourceClass = this.elementAsString(reader);
                            break block11;
                        }
                        case DRIVER: {
                            driver = this.elementAsString(reader);
                            break block11;
                        }
                        case POOL: {
                            pool = this.parsePool(reader);
                            break block11;
                        }
                        case NEW_CONNECTION_SQL: {
                            newConnectionSql = this.elementAsString(reader);
                            break block11;
                        }
                        case URL_DELIMITER: {
                            urlDelimiter = this.elementAsString(reader);
                            break block11;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            urlSelectorStrategyClassName = this.elementAsString(reader);
                            break block11;
                        }
                        case TRANSACTION_ISOLATION: {
                            String str = this.elementAsString(reader);
                            transactionIsolation = TransactionIsolation.forName((String)str);
                            if (transactionIsolation != null) break block11;
                            transactionIsolation = TransactionIsolation.customLevel((String)str);
                            break block11;
                        }
                        case SECURITY: {
                            securitySettings = this.parseDsSecurity(reader);
                            break block11;
                        }
                        case STATEMENT: {
                            statementSettings = this.parseStatementSettings(reader);
                            break block11;
                        }
                        case TIMEOUT: {
                            timeOutSettings = this.parseTimeOutSettings(reader);
                            break block11;
                        }
                        case VALIDATION: {
                            validationSettings = this.parseValidationSetting(reader);
                            break block11;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    public static enum Tag {
        UNKNOWN(null),
        DATASOURCES("datasources");

        private String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        Tag value(String v) {
            this.name = v;
            return this;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

