/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.spec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.MergeUtil;
import org.jboss.jca.common.api.metadata.spec.ConfigProperty;
import org.jboss.jca.common.api.metadata.spec.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.spec.MergeableMetadata;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.common.metadata.spec.XML;

public class ConnectionDefinitionImpl
implements ConnectionDefinition {
    private static final long serialVersionUID = 197264648585424765L;
    private XsdString managedconnectionfactoryClass;
    private List<ConfigProperty> configProperties;
    private XsdString connectionfactoryInterface;
    private XsdString connectionfactoryImplClass;
    private XsdString connectionInterface;
    private XsdString connectionImplClass;
    private String id;

    public ConnectionDefinitionImpl(XsdString managedconnectionfactoryClass, List<ConfigProperty> configProperty, XsdString connectionfactoryInterface, XsdString connectionfactoryImplClass, XsdString connectionInterface, XsdString connectionImplClass, String id) {
        this.configProperties = configProperty != null ? new ArrayList<ConfigProperty>(configProperty) : new ArrayList<ConfigProperty>(0);
        this.managedconnectionfactoryClass = managedconnectionfactoryClass;
        if (!XsdString.isNull((XsdString)this.managedconnectionfactoryClass)) {
            this.managedconnectionfactoryClass.setTag(XML.ConnectionDefinitionTag.MANAGEDCONNECTIONFACTORY_CLASS.toString());
        }
        this.connectionfactoryInterface = connectionfactoryInterface;
        if (!XsdString.isNull((XsdString)this.connectionfactoryInterface)) {
            this.connectionfactoryInterface.setTag(XML.ConnectionDefinitionTag.CONNECTIONFACTORY_INTERFACE.toString());
        }
        this.connectionfactoryImplClass = connectionfactoryImplClass;
        if (!XsdString.isNull((XsdString)this.connectionfactoryImplClass)) {
            this.connectionfactoryImplClass.setTag(XML.ConnectionDefinitionTag.CONNECTIONFACTORY_IMPL_CLASS.toString());
        }
        this.connectionInterface = connectionInterface;
        if (!XsdString.isNull((XsdString)this.connectionInterface)) {
            this.connectionInterface.setTag(XML.ConnectionDefinitionTag.CONNECTION_INTERFACE.toString());
        }
        this.connectionImplClass = connectionImplClass;
        if (!XsdString.isNull((XsdString)this.connectionImplClass)) {
            this.connectionImplClass.setTag(XML.ConnectionDefinitionTag.CONNECTION_IMPL_CLASS.toString());
        }
        this.id = id;
    }

    public XsdString getManagedConnectionFactoryClass() {
        return this.managedconnectionfactoryClass;
    }

    public List<ConfigProperty> getConfigProperties() {
        return Collections.unmodifiableList(this.configProperties);
    }

    public synchronized void forceConfigProperties(List<ConfigProperty> newContents) {
        this.configProperties = newContents != null ? new ArrayList<ConfigProperty>(newContents) : new ArrayList<ConfigProperty>(0);
    }

    public XsdString getConnectionFactoryInterface() {
        return this.connectionfactoryInterface;
    }

    public XsdString getConnectionFactoryImplClass() {
        return this.connectionfactoryImplClass;
    }

    public XsdString getConnectionInterface() {
        return this.connectionInterface;
    }

    public XsdString getConnectionImplClass() {
        return this.connectionImplClass;
    }

    public String getId() {
        return this.id;
    }

    public ConnectionDefinition merge(MergeableMetadata<?> jmd) throws Exception {
        if (jmd instanceof ConnectionDefinitionImpl) {
            ConnectionDefinitionImpl input = (ConnectionDefinitionImpl)jmd;
            List newConfigProperty = MergeUtil.mergeConfigList(this.configProperties, input.configProperties);
            XsdString newManagedconnectionfactoryClass = this.managedconnectionfactoryClass == null ? input.managedconnectionfactoryClass : this.managedconnectionfactoryClass;
            XsdString newConnectionInterface = this.connectionInterface == null ? input.connectionInterface : this.connectionInterface;
            XsdString newConnectionfactoryImplClass = this.connectionfactoryImplClass == null ? input.connectionfactoryImplClass : this.connectionfactoryImplClass;
            XsdString newConnectionfactoryInterface = this.connectionfactoryInterface == null ? input.connectionfactoryInterface : this.connectionfactoryInterface;
            String newId = this.id == null ? input.id : this.id;
            XsdString newConnectionImplClass = this.connectionImplClass == null ? input.connectionImplClass : this.connectionImplClass;
            return new ConnectionDefinitionImpl(newManagedconnectionfactoryClass, newConfigProperty, newConnectionfactoryInterface, newConnectionfactoryImplClass, newConnectionInterface, newConnectionImplClass, newId);
        }
        return this;
    }

    public CopyableMetaData copy() {
        return new ConnectionDefinitionImpl((XsdString)CopyUtil.clone((CopyableMetaData)this.managedconnectionfactoryClass), CopyUtil.cloneList(this.configProperties), (XsdString)CopyUtil.clone((CopyableMetaData)this.connectionfactoryInterface), (XsdString)CopyUtil.clone((CopyableMetaData)this.connectionfactoryImplClass), (XsdString)CopyUtil.clone((CopyableMetaData)this.connectionInterface), (XsdString)CopyUtil.clone((CopyableMetaData)this.connectionImplClass), CopyUtil.cloneString((String)this.id));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.configProperties == null ? 0 : this.configProperties.hashCode());
        result = 31 * result + (this.connectionImplClass == null ? 0 : this.connectionImplClass.hashCode());
        result = 31 * result + (this.connectionInterface == null ? 0 : this.connectionInterface.hashCode());
        result = 31 * result + (this.connectionfactoryImplClass == null ? 0 : this.connectionfactoryImplClass.hashCode());
        result = 31 * result + (this.connectionfactoryInterface == null ? 0 : this.connectionfactoryInterface.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.managedconnectionfactoryClass == null ? 0 : this.managedconnectionfactoryClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionDefinitionImpl)) {
            return false;
        }
        ConnectionDefinitionImpl other = (ConnectionDefinitionImpl)obj;
        if (this.configProperties == null ? other.configProperties != null : !this.configProperties.equals(other.configProperties)) {
            return false;
        }
        if (this.connectionImplClass == null ? other.connectionImplClass != null : !this.connectionImplClass.equals((Object)other.connectionImplClass)) {
            return false;
        }
        if (this.connectionInterface == null ? other.connectionInterface != null : !this.connectionInterface.equals((Object)other.connectionInterface)) {
            return false;
        }
        if (this.connectionfactoryImplClass == null ? other.connectionfactoryImplClass != null : !this.connectionfactoryImplClass.equals((Object)other.connectionfactoryImplClass)) {
            return false;
        }
        if (this.connectionfactoryInterface == null ? other.connectionfactoryInterface != null : !this.connectionfactoryInterface.equals((Object)other.connectionfactoryInterface)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.managedconnectionfactoryClass == null ? other.managedconnectionfactoryClass != null : !this.managedconnectionfactoryClass.equals((Object)other.managedconnectionfactoryClass));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<connection-definition");
        if (this.id != null) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(">");
        sb.append(this.managedconnectionfactoryClass);
        if (this.configProperties != null) {
            for (ConfigProperty cp : this.configProperties) {
                sb.append(cp);
            }
        }
        sb.append(this.connectionfactoryInterface);
        sb.append(this.connectionfactoryImplClass);
        sb.append(this.connectionInterface);
        sb.append(this.connectionImplClass);
        sb.append("</connection-definition>");
        return sb.toString();
    }
}

