/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.spec;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.spec.Activationspec;
import org.jboss.jca.common.api.metadata.spec.AdminObject;
import org.jboss.jca.common.api.metadata.spec.AuthenticationMechanism;
import org.jboss.jca.common.api.metadata.spec.ConfigProperty;
import org.jboss.jca.common.api.metadata.spec.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.api.metadata.spec.CredentialInterfaceEnum;
import org.jboss.jca.common.api.metadata.spec.Icon;
import org.jboss.jca.common.api.metadata.spec.InboundResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.LicenseType;
import org.jboss.jca.common.api.metadata.spec.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.spec.MessageListener;
import org.jboss.jca.common.api.metadata.spec.Messageadapter;
import org.jboss.jca.common.api.metadata.spec.OutboundResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.RequiredConfigProperty;
import org.jboss.jca.common.api.metadata.spec.ResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.SecurityPermission;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.common.metadata.MetadataParser;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.common.AbstractParser;
import org.jboss.jca.common.metadata.spec.ActivationSpecImpl;
import org.jboss.jca.common.metadata.spec.AdminObjectImpl;
import org.jboss.jca.common.metadata.spec.AuthenticationMechanismImpl;
import org.jboss.jca.common.metadata.spec.ConfigPropertyImpl;
import org.jboss.jca.common.metadata.spec.ConnectionDefinitionImpl;
import org.jboss.jca.common.metadata.spec.ConnectorImpl;
import org.jboss.jca.common.metadata.spec.IconImpl;
import org.jboss.jca.common.metadata.spec.InboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.spec.LicenseTypeImpl;
import org.jboss.jca.common.metadata.spec.MessageAdapterImpl;
import org.jboss.jca.common.metadata.spec.MessageListenerImpl;
import org.jboss.jca.common.metadata.spec.OutboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.spec.RequiredConfigPropertyImpl;
import org.jboss.jca.common.metadata.spec.ResourceAdapterImpl;
import org.jboss.jca.common.metadata.spec.SecurityPermissionImpl;
import org.jboss.jca.common.metadata.spec.XML;
import org.jboss.logging.Messages;

public class RaParser
extends AbstractParser
implements MetadataParser<Connector> {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    @Override
    public Connector parse(InputStream xmlInputStream) throws Exception {
        XMLStreamReader reader = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        reader = inputFactory.createXMLStreamReader(xmlInputStream);
        return this.parse(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Connector parse(XMLStreamReader reader) throws Exception {
        Connector connector = null;
        try {
            int iterate;
            try {
                iterate = reader.nextTag();
            }
            catch (XMLStreamException e) {
                iterate = reader.nextTag();
            }
            switch (iterate) {
                case 2: {
                    return connector;
                }
                case 1: {
                    if ("2.1".equals(reader.getAttributeValue(null, "version"))) {
                        switch (Tag.forName(reader.getLocalName()).ordinal()) {
                            case 1: {
                                connector = this.parseConnector21(reader);
                                return connector;
                            }
                        }
                        throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                    }
                    if ("2.0".equals(reader.getAttributeValue(null, "version"))) {
                        switch (Tag.forName(reader.getLocalName()).ordinal()) {
                            case 1: {
                                connector = this.parseConnector20(reader);
                                return connector;
                            }
                        }
                        throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                    }
                    if ("1.7".equals(reader.getAttributeValue(null, "version"))) {
                        switch (Tag.forName(reader.getLocalName()).ordinal()) {
                            case 1: {
                                connector = this.parseConnector17(reader);
                                return connector;
                            }
                        }
                        throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                    }
                    if ("1.6".equals(reader.getAttributeValue(null, "version"))) {
                        switch (Tag.forName(reader.getLocalName()).ordinal()) {
                            case 1: {
                                connector = this.parseConnector16(reader);
                                return connector;
                            }
                        }
                        throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                    }
                    if ("1.5".equals(reader.getAttributeValue(null, "version"))) {
                        switch (Tag.forName(reader.getLocalName()).ordinal()) {
                            case 1: {
                                connector = this.parseConnector15(reader);
                                return connector;
                            }
                        }
                        throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                    }
                    switch (Tag.forName(reader.getLocalName()).ordinal()) {
                        case 1: {
                            connector = this.parseConnector10(reader);
                            return connector;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private Connector parseConnector10(XMLStreamReader reader) throws XMLStreamException, ParserException {
        LicenseType license = null;
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        ArrayList<Icon> icon = new ArrayList<Icon>();
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        XsdString eisType = XsdString.NULL_XSDSTRING;
        ResourceAdapter resourceadapter = null;
        XsdString vendorName = XsdString.NULL_XSDSTRING;
        ArrayList<LocalizedXsdString> displayName = new ArrayList<LocalizedXsdString>();
        XsdString resourceadapterVersion = XsdString.NULL_XSDSTRING;
        XsdString specVersion = XsdString.NULL_XSDSTRING;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.CONNECTOR) {
                        icon.trimToSize();
                        description.trimToSize();
                        for (Icon i : icon) {
                            ((IconImpl)i).setLang(null);
                        }
                        for (LocalizedXsdString d : description) {
                            d.setLang(null);
                        }
                        for (LocalizedXsdString n : displayName) {
                            n.setLang(null);
                        }
                        return new ConnectorImpl(Connector.Version.V_10, null, vendorName, eisType, resourceadapterVersion, license, resourceadapter, null, true, description, displayName, icon, id);
                    }
                    if (XML.Connector10Tag.forName(reader.getLocalName()) != XML.Connector10Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.Connector10Tag.forName(reader.getLocalName())) {
                        case VENDOR_NAME: {
                            vendorName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case EIS_TYPE: {
                            eisType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case LICENSE: {
                            license = this.parseLicense(reader);
                            break block0;
                        }
                        case VERSION: {
                            resourceadapterVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case RESOURCEADAPTER: {
                            resourceadapter = this.parseResourceAdapter10(reader);
                            break block0;
                        }
                        case DESCRIPTION: {
                            if (description.size() > 0) {
                                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                            }
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case DISPLAY_NAME: {
                            if (displayName.size() > 0) {
                                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                            }
                            displayName.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case ICON: {
                            icon.add(this.parseIcon(reader));
                            break block0;
                        }
                        case SPEC_VERSION: {
                            specVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Connector parseConnector15(XMLStreamReader reader) throws XMLStreamException, ParserException {
        LicenseType license = null;
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        XsdString eisType = XsdString.NULL_XSDSTRING;
        ResourceAdapter resourceadapter = null;
        XsdString vendorName = XsdString.NULL_XSDSTRING;
        XsdString resourceadapterVersion = XsdString.NULL_XSDSTRING;
        ArrayList<Icon> icon = new ArrayList<Icon>();
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        ArrayList<LocalizedXsdString> displayName = new ArrayList<LocalizedXsdString>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.CONNECTOR) {
                        return new ConnectorImpl(Connector.Version.V_15, null, vendorName, eisType, resourceadapterVersion, license, resourceadapter, null, true, description, displayName, icon, id);
                    }
                    if (XML.Connector15Tag.forName(reader.getLocalName()) != XML.Connector15Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.Connector15Tag.forName(reader.getLocalName())) {
                        case VENDOR_NAME: {
                            vendorName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case EIS_TYPE: {
                            eisType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case LICENSE: {
                            license = this.parseLicense(reader);
                            break block0;
                        }
                        case RESOURCEADAPTER_VERSION: {
                            resourceadapterVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case RESOURCEADAPTER: {
                            resourceadapter = this.parseResourceAdapter(reader);
                            break block0;
                        }
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case DISPLAY_NAME: {
                            displayName.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case ICON: {
                            icon.add(this.parseIcon(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Connector parseConnector16(XMLStreamReader reader) throws XMLStreamException, ParserException {
        boolean metadataComplete = Boolean.valueOf(reader.getAttributeValue(null, XML.Connector16Attribute.METADATA_COMPLETE.getLocalName()));
        LicenseType license = null;
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        ArrayList<Icon> icon = new ArrayList<Icon>();
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        ArrayList<LocalizedXsdString> displayName = new ArrayList<LocalizedXsdString>();
        XsdString eisType = XsdString.NULL_XSDSTRING;
        ResourceAdapter resourceadapter = null;
        XsdString vendorName = XsdString.NULL_XSDSTRING;
        XsdString moduleName = null;
        ArrayList<XsdString> requiredWorkContext = new ArrayList<XsdString>();
        XsdString resourceadapterVersion = XsdString.NULL_XSDSTRING;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.CONNECTOR) {
                        icon.trimToSize();
                        description.trimToSize();
                        displayName.trimToSize();
                        requiredWorkContext.trimToSize();
                        return new ConnectorImpl(Connector.Version.V_16, moduleName, vendorName, eisType, resourceadapterVersion, license, resourceadapter, requiredWorkContext, metadataComplete, description, displayName, icon, id);
                    }
                    if (XML.Connector16Tag.forName(reader.getLocalName()) != XML.Connector16Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.Connector16Tag.forName(reader.getLocalName())) {
                        case MODULE_NAME: {
                            moduleName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case VENDOR_NAME: {
                            vendorName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case EIS_TYPE: {
                            eisType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case LICENSE: {
                            license = this.parseLicense(reader);
                            break block0;
                        }
                        case RESOURCEADAPTER_VERSION: {
                            resourceadapterVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case RESOURCEADAPTER: {
                            resourceadapter = this.parseResourceAdapter(reader);
                            break block0;
                        }
                        case REQUIRED_WORK_CONTEXT: {
                            requiredWorkContext.add(this.elementAsXsdString(reader));
                            break block0;
                        }
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case DISPLAY_NAME: {
                            displayName.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case ICON: {
                            icon.add(this.parseIcon(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Connector parseConnector17(XMLStreamReader reader) throws XMLStreamException, ParserException {
        boolean metadataComplete = Boolean.valueOf(reader.getAttributeValue(null, XML.Connector17Attribute.METADATA_COMPLETE.getLocalName()));
        LicenseType license = null;
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        ArrayList<Icon> icon = new ArrayList<Icon>();
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        ArrayList<LocalizedXsdString> displayName = new ArrayList<LocalizedXsdString>();
        XsdString eisType = XsdString.NULL_XSDSTRING;
        ResourceAdapter resourceadapter = null;
        XsdString vendorName = XsdString.NULL_XSDSTRING;
        XsdString moduleName = null;
        ArrayList<XsdString> requiredWorkContext = new ArrayList<XsdString>();
        XsdString resourceadapterVersion = XsdString.NULL_XSDSTRING;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.CONNECTOR) {
                        icon.trimToSize();
                        description.trimToSize();
                        displayName.trimToSize();
                        requiredWorkContext.trimToSize();
                        return new ConnectorImpl(Connector.Version.V_17, moduleName, vendorName, eisType, resourceadapterVersion, license, resourceadapter, requiredWorkContext, metadataComplete, description, displayName, icon, id);
                    }
                    if (XML.Connector17Tag.forName(reader.getLocalName()) != XML.Connector17Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.Connector17Tag.forName(reader.getLocalName())) {
                        case MODULE_NAME: {
                            moduleName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case VENDOR_NAME: {
                            vendorName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case EIS_TYPE: {
                            eisType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case LICENSE: {
                            license = this.parseLicense(reader);
                            break block0;
                        }
                        case RESOURCEADAPTER_VERSION: {
                            resourceadapterVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case RESOURCEADAPTER: {
                            resourceadapter = this.parseResourceAdapter(reader);
                            break block0;
                        }
                        case REQUIRED_WORK_CONTEXT: {
                            requiredWorkContext.add(this.elementAsXsdString(reader));
                            break block0;
                        }
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case DISPLAY_NAME: {
                            displayName.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case ICON: {
                            icon.add(this.parseIcon(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Connector parseConnector20(XMLStreamReader reader) throws XMLStreamException, ParserException {
        boolean metadataComplete = Boolean.valueOf(reader.getAttributeValue(null, XML.Connector17Attribute.METADATA_COMPLETE.getLocalName()));
        LicenseType license = null;
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        ArrayList<Icon> icon = new ArrayList<Icon>();
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        ArrayList<LocalizedXsdString> displayName = new ArrayList<LocalizedXsdString>();
        XsdString eisType = XsdString.NULL_XSDSTRING;
        ResourceAdapter resourceadapter = null;
        XsdString vendorName = XsdString.NULL_XSDSTRING;
        XsdString moduleName = null;
        ArrayList<XsdString> requiredWorkContext = new ArrayList<XsdString>();
        XsdString resourceadapterVersion = XsdString.NULL_XSDSTRING;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.CONNECTOR) {
                        icon.trimToSize();
                        description.trimToSize();
                        displayName.trimToSize();
                        requiredWorkContext.trimToSize();
                        return new ConnectorImpl(Connector.Version.V_20, moduleName, vendorName, eisType, resourceadapterVersion, license, resourceadapter, requiredWorkContext, metadataComplete, description, displayName, icon, id);
                    }
                    if (XML.Connector17Tag.forName(reader.getLocalName()) != XML.Connector17Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.Connector17Tag.forName(reader.getLocalName())) {
                        case MODULE_NAME: {
                            moduleName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case VENDOR_NAME: {
                            vendorName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case EIS_TYPE: {
                            eisType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case LICENSE: {
                            license = this.parseLicense(reader);
                            break block0;
                        }
                        case RESOURCEADAPTER_VERSION: {
                            resourceadapterVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case RESOURCEADAPTER: {
                            resourceadapter = this.parseResourceAdapter(reader);
                            break block0;
                        }
                        case REQUIRED_WORK_CONTEXT: {
                            requiredWorkContext.add(this.elementAsXsdString(reader));
                            break block0;
                        }
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case DISPLAY_NAME: {
                            displayName.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case ICON: {
                            icon.add(this.parseIcon(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Connector parseConnector21(XMLStreamReader reader) throws XMLStreamException, ParserException {
        boolean metadataComplete = Boolean.valueOf(reader.getAttributeValue(null, XML.Connector17Attribute.METADATA_COMPLETE.getLocalName()));
        LicenseType license = null;
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        ArrayList<Icon> icon = new ArrayList<Icon>();
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        ArrayList<LocalizedXsdString> displayName = new ArrayList<LocalizedXsdString>();
        XsdString eisType = XsdString.NULL_XSDSTRING;
        ResourceAdapter resourceadapter = null;
        XsdString vendorName = XsdString.NULL_XSDSTRING;
        XsdString moduleName = null;
        ArrayList<XsdString> requiredWorkContext = new ArrayList<XsdString>();
        XsdString resourceadapterVersion = XsdString.NULL_XSDSTRING;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.CONNECTOR) {
                        icon.trimToSize();
                        description.trimToSize();
                        displayName.trimToSize();
                        requiredWorkContext.trimToSize();
                        return new ConnectorImpl(Connector.Version.V_21, moduleName, vendorName, eisType, resourceadapterVersion, license, resourceadapter, requiredWorkContext, metadataComplete, description, displayName, icon, id);
                    }
                    if (XML.Connector17Tag.forName(reader.getLocalName()) != XML.Connector17Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.Connector17Tag.forName(reader.getLocalName())) {
                        case MODULE_NAME: {
                            moduleName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case VENDOR_NAME: {
                            vendorName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case EIS_TYPE: {
                            eisType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case LICENSE: {
                            license = this.parseLicense(reader);
                            break block0;
                        }
                        case RESOURCEADAPTER_VERSION: {
                            resourceadapterVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case RESOURCEADAPTER: {
                            resourceadapter = this.parseResourceAdapter(reader);
                            break block0;
                        }
                        case REQUIRED_WORK_CONTEXT: {
                            requiredWorkContext.add(this.elementAsXsdString(reader));
                            break block0;
                        }
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case DISPLAY_NAME: {
                            displayName.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case ICON: {
                            icon.add(this.parseIcon(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Icon parseIcon(XMLStreamReader reader) throws XMLStreamException, ParserException {
        XsdString largeIcon = null;
        XsdString smallIcon = null;
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        String lang = reader.getAttributeValue(null, XML.IconAttribute.LANG.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XML.Connector16Tag.forName(reader.getLocalName()) == XML.Connector16Tag.ICON) {
                        return new IconImpl(smallIcon, largeIcon, lang, id);
                    }
                    if (XML.IconTag.forName(reader.getLocalName()) != XML.IconTag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.IconTag.forName(reader.getLocalName())) {
                        case SMALL_ICON: {
                            smallIcon = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case LARGE_ICON: {
                            largeIcon = this.elementAsXsdString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private ResourceAdapter parseResourceAdapter(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<ConfigProperty> configProperty = new ArrayList<ConfigProperty>();
        XsdString resourceadapterClass = null;
        OutboundResourceAdapter outboundResourceadapter = null;
        ArrayList<SecurityPermission> securityPermission = new ArrayList<SecurityPermission>();
        InboundResourceAdapter inboundResourceadapter = null;
        ArrayList<AdminObject> adminobject = new ArrayList<AdminObject>();
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XML.Connector16Tag.forName(reader.getLocalName()) == XML.Connector16Tag.RESOURCEADAPTER) {
                        configProperty.trimToSize();
                        securityPermission.trimToSize();
                        adminobject.trimToSize();
                        return new ResourceAdapterImpl(resourceadapterClass, configProperty, outboundResourceadapter, inboundResourceadapter, adminobject, securityPermission, id);
                    }
                    if (XML.ResourceAdapterTag.forName(reader.getLocalName()) != XML.ResourceAdapterTag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.ResourceAdapterTag.forName(reader.getLocalName())) {
                        case RESOURCEADAPTER_CLASS: {
                            resourceadapterClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY: {
                            configProperty.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                        case OUTBOUND_RESOURCEADAPTER: {
                            outboundResourceadapter = this.parseOutboundResourceadapter(reader);
                            break block0;
                        }
                        case INBOUND_RESOURCEADAPTER: {
                            inboundResourceadapter = this.parseInboundResourceadapter(reader);
                            break block0;
                        }
                        case ADMINOBJECT: {
                            adminobject.add(this.parseAdminObject(reader));
                            break block0;
                        }
                        case SECURITY_PERMISSION: {
                            securityPermission.add(this.parseSecurityPermission(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private ResourceAdapter parseResourceAdapter10(XMLStreamReader reader) throws XMLStreamException, ParserException {
        XsdString managedConnectionFactoryClass = XsdString.NULL_XSDSTRING;
        XsdString connectionFactoryInterface = XsdString.NULL_XSDSTRING;
        XsdString connectionFactoryImplClass = XsdString.NULL_XSDSTRING;
        XsdString connectionInterface = XsdString.NULL_XSDSTRING;
        XsdString connectionImplClass = XsdString.NULL_XSDSTRING;
        TransactionSupportEnum transactionSupport = null;
        ArrayList<AuthenticationMechanism> authenticationMechanism = new ArrayList<AuthenticationMechanism>();
        ArrayList<ConfigProperty> configProperties = new ArrayList<ConfigProperty>();
        boolean reauthenticationSupport = false;
        ArrayList<SecurityPermission> securityPermission = new ArrayList<SecurityPermission>();
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        String rsId = null;
        String tsId = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XML.Connector10Tag.forName(reader.getLocalName()) == XML.Connector10Tag.RESOURCEADAPTER) {
                        authenticationMechanism.trimToSize();
                        configProperties.trimToSize();
                        securityPermission.trimToSize();
                        ArrayList<ConnectionDefinition> cds = new ArrayList<ConnectionDefinition>(1);
                        ConnectionDefinitionImpl cd = new ConnectionDefinitionImpl(managedConnectionFactoryClass, configProperties, connectionFactoryInterface, connectionFactoryImplClass, connectionInterface, connectionImplClass, id);
                        cds.add(cd);
                        OutboundResourceAdapterImpl ora = new OutboundResourceAdapterImpl(cds, transactionSupport, authenticationMechanism, reauthenticationSupport, id, tsId, rsId);
                        return new ResourceAdapterImpl(null, null, ora, null, null, securityPermission, id);
                    }
                    if (XML.ResourceAdapterTag.forName(reader.getLocalName()) != XML.ResourceAdapterTag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.ResourceAdapter10Tag.forName(reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            configProperties.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                        case AUTHENTICATION_MECHANISM: {
                            authenticationMechanism.add(this.parseAuthenticationMechanism(reader));
                            break block0;
                        }
                        case MANAGEDCONNECTIONFACTORY_CLASS: {
                            managedConnectionFactoryClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONNECTION_INTERFACE: {
                            connectionInterface = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONNECTION_IMPL_CLASS: {
                            connectionImplClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONNECTIONFACTORY_INTERFACE: {
                            connectionFactoryInterface = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONNECTIONFACTORY_IMPL_CLASS: {
                            connectionFactoryImplClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case REAUTHENTICATION_SUPPORT: {
                            rsId = reader.getAttributeValue(null, "id");
                            reauthenticationSupport = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case SECURITY_PERMISSION: {
                            securityPermission.add(this.parseSecurityPermission(reader));
                            break block0;
                        }
                        case TRANSACTION_SUPPORT: {
                            tsId = reader.getAttributeValue(null, "id");
                            transactionSupport = TransactionSupportEnum.valueOf((String)reader.getElementText().trim());
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private InboundResourceAdapter parseInboundResourceadapter(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Messageadapter messageadapter = null;
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XML.ResourceAdapterTag.forName(reader.getLocalName()) == XML.ResourceAdapterTag.INBOUND_RESOURCEADAPTER) {
                        return new InboundResourceAdapterImpl(messageadapter, id);
                    }
                    if (XML.InboundResourceAdapterTag.forName(reader.getLocalName()) != XML.InboundResourceAdapterTag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.InboundResourceAdapterTag.forName(reader.getLocalName())) {
                        case MESSAGEADAPTER: {
                            messageadapter = this.parseMessageAdapter(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Messageadapter parseMessageAdapter(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<MessageListener> messagelistener = new ArrayList<MessageListener>();
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XML.InboundResourceAdapterTag.forName(reader.getLocalName()) == XML.InboundResourceAdapterTag.MESSAGEADAPTER) {
                        messagelistener.trimToSize();
                        return new MessageAdapterImpl(messagelistener, id);
                    }
                    if (XML.MessageAdapterTag.forName(reader.getLocalName()) != XML.MessageAdapterTag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.MessageAdapterTag.forName(reader.getLocalName())) {
                        case MESSAGELISTENER: {
                            messagelistener.add(this.parseMessageListener(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private MessageListener parseMessageListener(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Activationspec activationspec = null;
        XsdString messagelistenerType = XsdString.NULL_XSDSTRING;
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XML.MessageAdapterTag.forName(reader.getLocalName()) == XML.MessageAdapterTag.MESSAGELISTENER) {
                        return new MessageListenerImpl(messagelistenerType, activationspec, id);
                    }
                    if (XML.MessageListenerTag.forName(reader.getLocalName()) != XML.MessageListenerTag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.MessageListenerTag.forName(reader.getLocalName())) {
                        case MESSAGELISTENER_TYPE: {
                            messagelistenerType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case ACTIVATIONSPEC: {
                            activationspec = this.parseActivationspec(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Activationspec parseActivationspec(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<RequiredConfigProperty> requiredConfigProperty = new ArrayList<RequiredConfigProperty>();
        XsdString activationspecClass = XsdString.NULL_XSDSTRING;
        ArrayList<ConfigProperty> configProperty = new ArrayList<ConfigProperty>();
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XML.MessageListenerTag.forName(reader.getLocalName()) == XML.MessageListenerTag.ACTIVATIONSPEC) {
                        requiredConfigProperty.trimToSize();
                        configProperty.trimToSize();
                        return new ActivationSpecImpl(activationspecClass, requiredConfigProperty, configProperty, id);
                    }
                    if (XML.ActivationSpecTag.forName(reader.getLocalName()) != XML.ActivationSpecTag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.ActivationSpecTag.forName(reader.getLocalName())) {
                        case ACTIVATIONSPEC_CLASS: {
                            activationspecClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case REQUIRED_CONFIG_PROPERTY: {
                            requiredConfigProperty.add(this.parseRequiredConfigProperty(reader));
                            break block0;
                        }
                        case CONFIG_PROPERTY: {
                            configProperty.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private RequiredConfigProperty parseRequiredConfigProperty(XMLStreamReader reader) throws XMLStreamException, ParserException {
        XsdString configPropertyName = XsdString.NULL_XSDSTRING;
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XML.ActivationSpecTag.forName(reader.getLocalName()) == XML.ActivationSpecTag.REQUIRED_CONFIG_PROPERTY) {
                        description.trimToSize();
                        return new RequiredConfigPropertyImpl(description, configPropertyName, id);
                    }
                    if (XML.RequiredConfigPropertyTag.forName(reader.getLocalName()) != XML.RequiredConfigPropertyTag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.RequiredConfigPropertyTag.forName(reader.getLocalName())) {
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case CONFIG_PROPERTY_NAME: {
                            configPropertyName = this.elementAsXsdString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private OutboundResourceAdapter parseOutboundResourceadapter(XMLStreamReader reader) throws XMLStreamException, ParserException {
        boolean reauthenticationSupport = false;
        TransactionSupportEnum transactionSupport = null;
        ArrayList<ConnectionDefinition> connectionDefinition = new ArrayList<ConnectionDefinition>();
        ArrayList<AuthenticationMechanism> authenticationMechanism = new ArrayList<AuthenticationMechanism>();
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        String tsId = null;
        String rsId = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XML.ResourceAdapterTag.forName(reader.getLocalName()) == XML.ResourceAdapterTag.OUTBOUND_RESOURCEADAPTER) {
                        authenticationMechanism.trimToSize();
                        connectionDefinition.trimToSize();
                        return new OutboundResourceAdapterImpl(connectionDefinition, transactionSupport, authenticationMechanism, reauthenticationSupport, id, tsId, rsId);
                    }
                    if (XML.OutboundResourceAdapterTag.forName(reader.getLocalName()) != XML.OutboundResourceAdapterTag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.OutboundResourceAdapterTag.forName(reader.getLocalName())) {
                        case CONNECTION_DEFINITION: {
                            connectionDefinition.add(this.parseConncetionDefinition(reader));
                            break block0;
                        }
                        case AUTHENTICATION_MECHANISM: {
                            authenticationMechanism.add(this.parseAuthenticationMechanism(reader));
                            break block0;
                        }
                        case TRANSACTION_SUPPORT: {
                            tsId = reader.getAttributeValue(null, "id");
                            transactionSupport = TransactionSupportEnum.valueOf((String)reader.getElementText().trim());
                            break block0;
                        }
                        case REAUTHENTICATION_SUPPORT: {
                            rsId = reader.getAttributeValue(null, "id");
                            reauthenticationSupport = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private ConnectionDefinition parseConncetionDefinition(XMLStreamReader reader) throws XMLStreamException, ParserException {
        XsdString managedconnectionfactoryClass = XsdString.NULL_XSDSTRING;
        ArrayList<ConfigProperty> configProperty = new ArrayList<ConfigProperty>();
        XsdString connectionImplClass = XsdString.NULL_XSDSTRING;
        XsdString connectionInterface = XsdString.NULL_XSDSTRING;
        XsdString connectionfactoryImplClass = XsdString.NULL_XSDSTRING;
        XsdString connectionfactoryInterface = XsdString.NULL_XSDSTRING;
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XML.OutboundResourceAdapterTag.forName(reader.getLocalName()) == XML.OutboundResourceAdapterTag.CONNECTION_DEFINITION) {
                        configProperty.trimToSize();
                        return new ConnectionDefinitionImpl(managedconnectionfactoryClass, configProperty, connectionfactoryInterface, connectionfactoryImplClass, connectionInterface, connectionImplClass, id);
                    }
                    if (XML.ConnectionDefinitionTag.forName(reader.getLocalName()) != XML.ConnectionDefinitionTag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.ConnectionDefinitionTag.forName(reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            configProperty.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                        case MANAGEDCONNECTIONFACTORY_CLASS: {
                            managedconnectionfactoryClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONNECTIONFACTORY_INTERFACE: {
                            connectionfactoryInterface = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONNECTIONFACTORY_IMPL_CLASS: {
                            connectionfactoryImplClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONNECTION_INTERFACE: {
                            connectionInterface = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONNECTION_IMPL_CLASS: {
                            connectionImplClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private AuthenticationMechanism parseAuthenticationMechanism(XMLStreamReader reader) throws XMLStreamException, ParserException {
        XsdString authenticationMechanismType = XsdString.NULL_XSDSTRING;
        CredentialInterfaceEnum credentialInterface = null;
        String cIId = null;
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XML.OutboundResourceAdapterTag.forName(reader.getLocalName()) == XML.OutboundResourceAdapterTag.AUTHENTICATION_MECHANISM) {
                        description.trimToSize();
                        return new AuthenticationMechanismImpl(description, authenticationMechanismType, credentialInterface, id, cIId);
                    }
                    if (XML.AuthenticationMechanismTag.forName(reader.getLocalName()) != XML.AuthenticationMechanismTag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.AuthenticationMechanismTag.forName(reader.getLocalName())) {
                        case AUTHENTICATION_MECHANISM_TYPE: {
                            authenticationMechanismType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CREDENTIAL_INTERFACE: {
                            cIId = reader.getAttributeValue(null, "id");
                            credentialInterface = CredentialInterfaceEnum.forName((String)reader.getElementText().trim());
                            break block0;
                        }
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private AdminObject parseAdminObject(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<ConfigProperty> configProperty = new ArrayList<ConfigProperty>();
        XsdString adminobjectInterface = XsdString.NULL_XSDSTRING;
        XsdString adminobjectClass = XsdString.NULL_XSDSTRING;
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XML.ResourceAdapterTag.forName(reader.getLocalName()) == XML.ResourceAdapterTag.ADMINOBJECT) {
                        configProperty.trimToSize();
                        return new AdminObjectImpl(adminobjectInterface, adminobjectClass, configProperty, id);
                    }
                    if (XML.AdminObjectTag.forName(reader.getLocalName()) != XML.AdminObjectTag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.AdminObjectTag.forName(reader.getLocalName())) {
                        case ADMINOBJECT_CLASS: {
                            adminobjectClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case ADMINOBJECT_INTERFACE: {
                            adminobjectInterface = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY: {
                            configProperty.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private ConfigProperty parseConfigProperty(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        XsdString configPropertyType = XsdString.NULL_XSDSTRING;
        XsdString configPropertyValue = XsdString.NULL_XSDSTRING;
        Boolean configPropertyIgnore = null;
        XsdString configPropertyName = XsdString.NULL_XSDSTRING;
        Boolean configPropertySupportsDynamicUpdates = null;
        Boolean configPropertyConfidential = null;
        String ignoreId = null;
        String updatesId = null;
        String confidId = null;
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XML.ResourceAdapterTag.forName(reader.getLocalName()) == XML.ResourceAdapterTag.CONFIG_PROPERTY) {
                        description.trimToSize();
                        return new ConfigPropertyImpl(description, configPropertyName, configPropertyType, configPropertyValue, configPropertyIgnore, configPropertySupportsDynamicUpdates, configPropertyConfidential, id, false, null, ignoreId, updatesId, confidId);
                    }
                    if (XML.ConfigPropertyTag.forName(reader.getLocalName()) != XML.ConfigPropertyTag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.ConfigPropertyTag.forName(reader.getLocalName())) {
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case CONFIG_PROPERTY_NAME: {
                            configPropertyName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY_TYPE: {
                            configPropertyType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY_VALUE: {
                            configPropertyValue = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY_IGNORE: {
                            ignoreId = reader.getAttributeValue(null, "id");
                            configPropertyIgnore = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY_CONFIDENTIAL: {
                            confidId = reader.getAttributeValue(null, "id");
                            configPropertyConfidential = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY_SUPPORT_DYNAMIC_UPDATE: {
                            updatesId = reader.getAttributeValue(null, "id");
                            configPropertySupportsDynamicUpdates = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private SecurityPermission parseSecurityPermission(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        XsdString securityPermissionSpec = XsdString.NULL_XSDSTRING;
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XML.ResourceAdapterTag.forName(reader.getLocalName()) == XML.ResourceAdapterTag.SECURITY_PERMISSION) {
                        description.trimToSize();
                        return new SecurityPermissionImpl(description, securityPermissionSpec, id);
                    }
                    if (XML.SecurityPermissionTag.forName(reader.getLocalName()) != XML.SecurityPermissionTag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.SecurityPermissionTag.forName(reader.getLocalName())) {
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case SECURITY_PERMISSION_SPEC: {
                            securityPermissionSpec = this.elementAsXsdString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private LicenseType parseLicense(XMLStreamReader reader) throws XMLStreamException, ParserException {
        String id = reader.getAttributeValue(null, XML.IdAttribute.ID.getLocalName());
        boolean licenseRequired = false;
        String lrid = null;
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XML.Connector16Tag.forName(reader.getLocalName()) == XML.Connector16Tag.LICENSE) {
                        description.trimToSize();
                        return new LicenseTypeImpl(description, licenseRequired, id, lrid);
                    }
                    if (XML.LicenseTag.forName(reader.getLocalName()) != XML.LicenseTag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XML.LicenseTag.forName(reader.getLocalName())) {
                        case LICENSE_REQUIRED: {
                            lrid = reader.getAttributeValue(null, "id");
                            licenseRequired = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private XsdString elementAsXsdString(XMLStreamReader reader) throws XMLStreamException {
        String id = reader.getAttributeValue(null, "id");
        return new XsdString(reader.getElementText().trim(), id, reader.getLocalName());
    }

    private LocalizedXsdString elementAsLocalizedXsdString(XMLStreamReader reader) throws XMLStreamException {
        String id = reader.getAttributeValue(null, "id");
        String lang = reader.getAttributeValue(null, "lang");
        return new LocalizedXsdString(reader.getElementText().trim(), id, lang, reader.getLocalName());
    }

    public static enum Tag {
        UNKNOWN(null),
        CONNECTOR("connector");

        private String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        Tag value(String v) {
            this.name = v;
            return this;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

