/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.classloading.ClassLoaderFactory;
import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.api.util.FileUtil;
import com.github.fungal.api.util.Injection;
import com.github.fungal.api.util.JarFilter;
import com.github.fungal.spi.deployers.CloneableDeployer;
import com.github.fungal.spi.deployers.DeployException;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.Deployment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.Referenceable;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.TransactionSupport;
import javax.transaction.TransactionManager;
import org.jboss.jca.common.annotations.Annotations;
import org.jboss.jca.common.metadata.Metadata;
import org.jboss.jca.core.api.CloneableBootstrapContext;
import org.jboss.jca.core.connectionmanager.ConnectionManagerFactory;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.pool.api.PoolFactory;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;
import org.jboss.jca.core.naming.NoopJndiStrategy;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.deployers.fungal.BeanValidation;
import org.jboss.jca.deployers.fungal.RADeployment;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.jca.validator.Failure;
import org.jboss.jca.validator.FailureHelper;
import org.jboss.jca.validator.Key;
import org.jboss.jca.validator.Validate;
import org.jboss.jca.validator.ValidateClass;
import org.jboss.jca.validator.ValidateObject;
import org.jboss.jca.validator.Validator;
import org.jboss.jca.validator.ValidatorException;
import org.jboss.logging.Logger;
import org.jboss.metadata.rar.jboss.BvGroupMetaData;
import org.jboss.metadata.rar.jboss.JBossRA20Base;
import org.jboss.metadata.rar.jboss.JBossRAMetaData;
import org.jboss.metadata.rar.spec.AdminObjectMetaData;
import org.jboss.metadata.rar.spec.ConfigPropertyMetaData;
import org.jboss.metadata.rar.spec.ConnectionDefinitionMetaData;
import org.jboss.metadata.rar.spec.ConnectorMetaData;
import org.jboss.metadata.rar.spec.JCA10DTDMetaData;
import org.jboss.metadata.rar.spec.MessageListenerMetaData;
import org.jboss.metadata.rar.spec.TransactionSupportMetaData;

public final class RADeployer
implements CloneableDeployer {
    private static Logger log = Logger.getLogger(RADeployer.class);
    private static boolean trace = log.isTraceEnabled();
    private static TransactionManager transactionManager = null;
    private static AtomicBoolean beanValidation = new AtomicBoolean(true);
    private static AtomicBoolean archiveValidation = new AtomicBoolean(true);
    private static AtomicBoolean archiveValidationFailOnWarn = new AtomicBoolean(false);
    private static AtomicBoolean archiveValidationFailOnError = new AtomicBoolean(true);
    private static PrintStream printStream = null;
    private static CloneableBootstrapContext defaultBootstrapContext = null;
    private static Map<String, CloneableBootstrapContext> bootstrapContexts = null;
    private static AtomicBoolean scopeDeployment = new AtomicBoolean(false);
    private static JndiStrategy jndiStrategy = null;

    public synchronized void setTransactionManager(TransactionManager value) {
        transactionManager = value;
    }

    public synchronized TransactionManager getTransactionManager() {
        return transactionManager;
    }

    public void setBeanValidation(boolean value) {
        beanValidation.set(value);
    }

    public boolean getBeanValidation() {
        return beanValidation.get();
    }

    public void setArchiveValidation(boolean value) {
        archiveValidation.set(value);
    }

    public boolean getArchiveValidation() {
        return archiveValidation.get();
    }

    public void setArchiveValidationFailOnWarn(boolean value) {
        archiveValidationFailOnWarn.set(value);
    }

    public boolean getArchiveValidationFailOnWarn() {
        return archiveValidationFailOnWarn.get();
    }

    public void setArchiveValidationFailOnError(boolean value) {
        archiveValidationFailOnError.set(value);
    }

    public boolean getArchiveValidationFailOnError() {
        return archiveValidationFailOnError.get();
    }

    public synchronized void setPrintStream(PrintStream value) {
        printStream = value;
    }

    public synchronized PrintStream getPrintStream() {
        return printStream;
    }

    public synchronized void setDefaultBootstrapContext(CloneableBootstrapContext value) {
        defaultBootstrapContext = value;
    }

    public synchronized CloneableBootstrapContext getDefaultBootstrapContext() {
        return defaultBootstrapContext;
    }

    public synchronized void setBootstrapContexts(Map<String, CloneableBootstrapContext> value) {
        bootstrapContexts = value;
    }

    public synchronized Map<String, CloneableBootstrapContext> getBootstrapContexts() {
        return bootstrapContexts;
    }

    public void setScopeDeployment(boolean value) {
        scopeDeployment.set(value);
    }

    public boolean getScopeDeployment() {
        return scopeDeployment.get();
    }

    public synchronized void setJndiStrategy(JndiStrategy value) {
        jndiStrategy = value;
    }

    public synchronized JndiStrategy getJndiStrategy() {
        return jndiStrategy;
    }

    public Deployment deploy(URL url, ClassLoader parent) throws DeployException {
        if (url == null || !url.toExternalForm().endsWith(".rar") && !url.toExternalForm().endsWith(".rar/")) {
            return null;
        }
        HashSet<Object> failures = null;
        log.debug((Object)("Deploying: " + url.toExternalForm()));
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        try {
            File f = new File(url.toURI());
            if (!f.exists()) {
                throw new IOException("Archive " + url.toExternalForm() + " doesnt exists");
            }
            File root = null;
            File destination = null;
            if (f.isFile()) {
                FileUtil fileUtil = new FileUtil();
                destination = new File(SecurityActions.getSystemProperty("iron.jacamar.home"), "/tmp/");
                root = fileUtil.extract(f, destination);
            } else {
                root = f;
            }
            URL[] urls = this.getUrls(root);
            KernelClassLoader cl = null;
            cl = scopeDeployment.get() ? ClassLoaderFactory.create((int)1, (URL[])urls, (ClassLoader)parent) : ClassLoaderFactory.create((int)0, (URL[])urls, (ClassLoader)parent);
            SecurityActions.setThreadContextClassLoader((ClassLoader)cl);
            Metadata metadataHandler = new Metadata();
            ConnectorMetaData cmd = metadataHandler.getStandardMetaData(root);
            JBossRAMetaData jrmd = metadataHandler.getJBossMetaData(root);
            Annotations annotator = new Annotations();
            cmd = annotator.scan(cmd, cl.getURLs(), (ClassLoader)cl);
            metadataHandler.validate(cmd);
            cmd = metadataHandler.merge(cmd, jrmd);
            if (cmd != null && cmd.getLicense() != null && cmd.getLicense().getRequired()) {
                log.info((Object)("Required license terms for " + url.toExternalForm()));
            }
            ResourceAdapter resourceAdapter = null;
            ArrayList<Validate> archiveValidationObjects = new ArrayList<Validate>();
            List<Failure> partialFailures = null;
            ArrayList<Object> beanValidationObjects = new ArrayList<Object>();
            String deploymentName = null;
            Object[] cfs = null;
            if (cmd != null) {
                List aoMetas;
                List mlMetas;
                List cdMetas;
                if (!cmd.is10() && cmd.getRa() != null && cmd.getRa().getRaClass() != null) {
                    partialFailures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.RESOURCE_ADAPTER, cmd.getRa().getRaClass(), (ClassLoader)cl, cmd.getRa().getConfigProperty())));
                    if (partialFailures != null) {
                        failures = new HashSet();
                        failures.addAll(partialFailures);
                    }
                    if (!this.getArchiveValidationFailOnError() || !this.hasFailuresLevel(failures, 1)) {
                        resourceAdapter = (ResourceAdapter)this.initAndInject(cmd.getRa().getRaClass(), cmd.getRa().getConfigProperty(), (ClassLoader)cl);
                        if (trace) {
                            log.trace((Object)("ResourceAdapter: " + resourceAdapter.getClass().getName()));
                            log.trace((Object)("ResourceAdapter defined in classloader: " + resourceAdapter.getClass().getClassLoader()));
                        }
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.RESOURCE_ADAPTER, (Object)resourceAdapter, cmd.getRa().getConfigProperty()));
                        beanValidationObjects.add(resourceAdapter);
                    }
                }
                if (cmd.getRa() != null && cmd.getRa().getOutboundRa() != null && cmd.getRa().getOutboundRa().getConDefs() != null && (cdMetas = cmd.getRa().getOutboundRa().getConDefs()).size() > 0) {
                    for (ConnectionDefinitionMetaData cdMeta : cdMetas) {
                        ConnectionManagerFactory cmf;
                        Object cf;
                        partialFailures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.MANAGED_CONNECTION_FACTORY, cdMeta.getManagedConnectionFactoryClass(), (ClassLoader)cl, cdMeta.getConfigProps())));
                        if (partialFailures != null) {
                            failures = new HashSet();
                            failures.addAll(partialFailures);
                        }
                        if (this.getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) continue;
                        ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(cdMeta.getManagedConnectionFactoryClass(), cdMeta.getConfigProps(), (ClassLoader)cl);
                        if (trace) {
                            log.trace((Object)("ManagedConnectionFactory: " + mcf.getClass().getName()));
                            log.trace((Object)("ManagedConnectionFactory defined in classloader: " + mcf.getClass().getClassLoader()));
                        }
                        mcf.setLogWriter(new PrintWriter(printStream));
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.MANAGED_CONNECTION_FACTORY, (Object)mcf, cdMeta.getConfigProps()));
                        beanValidationObjects.add(mcf);
                        this.associateResourceAdapter(resourceAdapter, mcf);
                        PoolConfiguration pc = new PoolConfiguration();
                        PoolFactory pf = new PoolFactory();
                        Pool pool = pf.create(PoolStrategy.ONE_POOL, mcf, pc, true);
                        org.jboss.jca.core.connectionmanager.ConnectionManager cm = null;
                        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                        TransactionSupportMetaData tsmd = TransactionSupportMetaData.NoTransaction;
                        tsmd = cmd instanceof JCA10DTDMetaData ? ((JCA10DTDMetaData)cmd).getRa10().getTransSupport() : cmd.getRa().getOutboundRa().getTransSupport();
                        if (tsmd == TransactionSupportMetaData.NoTransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                        } else if (tsmd == TransactionSupportMetaData.LocalTransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
                        } else if (tsmd == TransactionSupportMetaData.XATransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
                        }
                        if (mcf instanceof TransactionSupport) {
                            tsl = ((TransactionSupport)mcf).getTransactionSupport();
                        }
                        if ((cf = mcf.createConnectionFactory((ConnectionManager)(cm = (cmf = new ConnectionManagerFactory()).create(tsl, pool, transactionManager)))) == null) {
                            log.error((Object)"ConnectionFactory is null");
                        } else if (trace) {
                            log.trace((Object)("ConnectionFactory: " + cf.getClass().getName()));
                            log.trace((Object)("ConnectionFactory defined in classloader: " + cf.getClass().getClassLoader()));
                        }
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.CONNECTION_FACTORY, cf));
                        if (cf == null || !(cf instanceof Serializable) || !(cf instanceof Referenceable)) continue;
                        if (cdMetas.size() == 1) {
                            deploymentName = f.getName().substring(0, f.getName().indexOf(".rar"));
                            this.bindConnectionFactory(deploymentName, cf);
                            cfs = new Object[]{cf};
                            continue;
                        }
                        log.warn((Object)("NYI: There are multiple connection factories for: " + f.getName()));
                    }
                }
                if (cmd.getRa() != null && cmd.getRa().getInboundRa() != null && cmd.getRa().getInboundRa().getMessageAdapter() != null && cmd.getRa().getInboundRa().getMessageAdapter().getMessageListeners() != null && (mlMetas = cmd.getRa().getInboundRa().getMessageAdapter().getMessageListeners()).size() > 0) {
                    for (MessageListenerMetaData mlMeta : mlMetas) {
                        if (mlMeta.getActivationSpecType() == null || mlMeta.getActivationSpecType().getAsClass() == null) continue;
                        partialFailures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.ACTIVATION_SPEC, mlMeta.getActivationSpecType().getAsClass(), (ClassLoader)cl, mlMeta.getActivationSpecType().getConfigProps())));
                        if (partialFailures != null) {
                            failures = new HashSet();
                            failures.addAll(partialFailures);
                        }
                        if (this.getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) continue;
                        List cpm = mlMeta.getActivationSpecType().getConfigProps();
                        Object o = this.initAndInject(mlMeta.getActivationSpecType().getAsClass(), cpm, (ClassLoader)cl);
                        if (trace) {
                            log.trace((Object)("ActivationSpec: " + o.getClass().getName()));
                            log.trace((Object)("ActivationSpec defined in classloader: " + o.getClass().getClassLoader()));
                        }
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.ACTIVATION_SPEC, o, cpm));
                        beanValidationObjects.add(o);
                        this.associateResourceAdapter(resourceAdapter, o);
                    }
                }
                if (cmd.getRa() != null && cmd.getRa().getAdminObjects() != null && (aoMetas = cmd.getRa().getAdminObjects()).size() > 0) {
                    for (AdminObjectMetaData aoMeta : aoMetas) {
                        if (aoMeta.getAdminObjectImplementationClass() == null) continue;
                        partialFailures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.ADMIN_OBJECT, aoMeta.getAdminObjectImplementationClass(), (ClassLoader)cl, aoMeta.getConfigProps())));
                        if (partialFailures != null) {
                            failures = new HashSet();
                            failures.addAll(partialFailures);
                        }
                        if (this.getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) continue;
                        Object o = this.initAndInject(aoMeta.getAdminObjectImplementationClass(), aoMeta.getConfigProps(), (ClassLoader)cl);
                        if (trace) {
                            log.trace((Object)("AdminObject: " + o.getClass().getName()));
                            log.trace((Object)("AdminObject defined in classloader: " + o.getClass().getClassLoader()));
                        }
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.ADMIN_OBJECT, o, aoMeta.getConfigProps()));
                        beanValidationObjects.add(o);
                    }
                }
            }
            if ((partialFailures = this.validateArchive(url, archiveValidationObjects)) != null) {
                if (failures == null) {
                    failures = new HashSet<Failure>();
                }
                failures.addAll(partialFailures);
            }
            if (this.getArchiveValidationFailOnWarn() && this.hasFailuresLevel(failures, 0) || this.getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) {
                throw new ValidatorException(this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]), failures);
            }
            this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]);
            if (this.getBeanValidation()) {
                JBossRA20Base jrmd20 = null;
                ArrayList<Class> groupsClasses = null;
                if (jrmd instanceof JBossRA20Base) {
                    jrmd20 = (JBossRA20Base)jrmd;
                }
                if (jrmd20 != null && jrmd20.getBvGroupsList() != null && jrmd20.getBvGroupsList().size() > 0) {
                    BvGroupMetaData bvGroups = (BvGroupMetaData)jrmd20.getBvGroupsList().get(0);
                    groupsClasses = new ArrayList<Class>();
                    for (String group : bvGroups.getBvGroups()) {
                        groupsClasses.add(Class.forName(group, true, (ClassLoader)cl));
                    }
                }
                if (beanValidationObjects.size() > 0) {
                    BeanValidation beanValidator = new BeanValidation();
                    for (Object o : beanValidationObjects) {
                        beanValidator.validate(o, groupsClasses);
                    }
                }
            }
            if (resourceAdapter != null) {
                String bootstrapIdentifier = null;
                if (jrmd != null && jrmd instanceof JBossRA20Base) {
                    JBossRA20Base jrmd20 = (JBossRA20Base)jrmd;
                    bootstrapIdentifier = jrmd20.getBootstrapContext();
                }
                this.startContext(resourceAdapter, bootstrapIdentifier);
            }
            log.info((Object)("Deployed: " + url.toExternalForm()));
            RADeployment rADeployment = new RADeployment(url, deploymentName, resourceAdapter, jndiStrategy, cfs, destination, (ClassLoader)cl);
            return rADeployment;
        }
        catch (DeployException de) {
            throw de;
        }
        catch (Throwable t) {
            if (this.getArchiveValidationFailOnWarn() && this.hasFailuresLevel(failures, 0) || this.getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) {
                throw new DeployException("Deployment " + url.toExternalForm() + " failed", (Throwable)new ValidatorException(this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]), failures));
            }
            this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]);
            throw new DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    List<Failure> validateArchive(URL url, List<Validate> archiveValidation) {
        if (!this.getArchiveValidation()) {
            return null;
        }
        Validator validator = new Validator();
        List failures = validator.validate(archiveValidation);
        return failures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String printFailuresLog(String urlFileName, Validator validator, Collection<Failure> failures, File reportDirectory, FailureHelper ... fhInput) {
        String errorText = "";
        FailureHelper fh = null;
        fh = fhInput.length == 0 ? new FailureHelper(failures) : fhInput[0];
        if (failures != null && failures.size() > 0) {
            if (reportDirectory == null) {
                reportDirectory = new File(SecurityActions.getSystemProperty("iron.jacamar.home"), "/log/");
            }
            if (reportDirectory.exists()) {
                int lastSepaIndex;
                int lastIndex;
                int lastSlashIndex = urlFileName.lastIndexOf("/");
                int n = lastIndex = lastSlashIndex > (lastSepaIndex = urlFileName.lastIndexOf(File.separator)) ? lastSlashIndex : lastSepaIndex;
                if (lastIndex != -1) {
                    urlFileName = urlFileName.substring(lastIndex + 1);
                }
                urlFileName = urlFileName + ".log";
                File report = new File(reportDirectory, urlFileName);
                FileWriter fw = null;
                BufferedWriter bw = null;
                try {
                    fw = new FileWriter(report);
                    bw = new BufferedWriter(fw, 8192);
                    bw.write(fh.asText(validator.getResourceBundle()));
                    bw.flush();
                    errorText = "Validation failures - see: " + report.getAbsolutePath();
                }
                catch (IOException ioe) {
                    log.warn((Object)ioe.getMessage(), (Throwable)ioe);
                }
                finally {
                    if (bw != null) {
                        try {
                            bw.close();
                        }
                        catch (IOException ignore) {}
                    }
                    if (fw != null) {
                        try {
                            fw.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            } else {
                errorText = fh.asText(validator.getResourceBundle());
            }
        }
        return errorText;
    }

    private boolean hasFailuresLevel(Collection<Failure> failures, int severity) {
        if (failures != null) {
            for (Failure failure : failures) {
                if (failure.getSeverity() != severity) continue;
                return true;
            }
        }
        return false;
    }

    private void startContext(ResourceAdapter resourceAdapter, String bootstrapIdentifier) throws DeployException {
        try {
            CloneableBootstrapContext bc;
            Class<?> clz = resourceAdapter.getClass();
            Method start = clz.getMethod("start", BootstrapContext.class);
            CloneableBootstrapContext cbc = null;
            if (bootstrapIdentifier != null && bootstrapContexts != null && (bc = bootstrapContexts.get(bootstrapIdentifier)) != null) {
                cbc = bc.clone();
            }
            if (cbc == null) {
                cbc = defaultBootstrapContext.clone();
            }
            start.invoke((Object)resourceAdapter, cbc);
        }
        catch (InvocationTargetException ite) {
            throw new DeployException("Unable to start " + resourceAdapter.getClass().getName(), ite.getTargetException());
        }
        catch (Throwable t) {
            throw new DeployException("Unable to start " + resourceAdapter.getClass().getName(), t);
        }
    }

    private void associateResourceAdapter(ResourceAdapter resourceAdapter, Object object) throws DeployException {
        if (resourceAdapter != null && object != null && object instanceof ResourceAdapterAssociation) {
            try {
                Class<?> clz = object.getClass();
                Method setResourceAdapter = clz.getMethod("setResourceAdapter", ResourceAdapter.class);
                setResourceAdapter.invoke(object, resourceAdapter);
            }
            catch (Throwable t) {
                throw new DeployException("Unable to associate " + object.getClass().getName(), t);
            }
        }
    }

    private Object initAndInject(String className, List<ConfigPropertyMetaData> configs, ClassLoader cl) throws DeployException {
        try {
            Class<?> clz = Class.forName(className, true, cl);
            Object o = clz.newInstance();
            if (configs != null) {
                Injection injector = new Injection();
                for (ConfigPropertyMetaData cpmd : configs) {
                    if (!cpmd.isValueSet()) continue;
                    injector.inject(cpmd.getType(), cpmd.getName(), cpmd.getValue(), o);
                }
            }
            return o;
        }
        catch (Throwable t) {
            throw new DeployException("Deployment " + className + " failed", t);
        }
    }

    private URL[] getUrls(File directory) throws MalformedURLException, IOException {
        LinkedList<URL> list = new LinkedList<URL>();
        if (directory.exists() && directory.isDirectory()) {
            list.add(directory.toURI().toURL());
            File[] jars = directory.listFiles((FilenameFilter)new JarFilter());
            if (jars != null) {
                for (int j = 0; j < jars.length; ++j) {
                    list.add(jars[j].getCanonicalFile().toURI().toURL());
                }
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    private String[] bindConnectionFactory(String deployment, Object cf) throws Throwable {
        if (jndiStrategy == null) {
            jndiStrategy = new NoopJndiStrategy();
        }
        JndiStrategy js = jndiStrategy.clone();
        return js.bindConnectionFactories(deployment, new Object[]{cf});
    }

    public void start() {
        if (defaultBootstrapContext == null) {
            throw new IllegalStateException("DefaultBootstrapContext not defined");
        }
        if (printStream == null) {
            throw new IllegalStateException("PrintStream not defined");
        }
    }

    public Deployer clone() throws CloneNotSupportedException {
        return new RADeployer();
    }
}

