/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.util.FileUtil;
import com.github.fungal.spi.deployers.Deployment;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.resource.spi.ResourceAdapter;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.deployers.fungal.RADeployer;
import org.jboss.logging.Logger;

public class RADeployment
implements Deployment {
    private static Logger log = Logger.getLogger(RADeployer.class);
    private URL deployment;
    private String deploymentName;
    private ResourceAdapter ra;
    private JndiStrategy jndiStrategy;
    private Object[] cfs;
    private File tmpDirectory;
    private ClassLoader cl;

    public RADeployment(URL deployment, String deploymentName, ResourceAdapter ra, JndiStrategy jndiStrategy, Object[] cfs, File tmpDirectory, ClassLoader cl) {
        this.deployment = deployment;
        this.deploymentName = deploymentName;
        this.ra = ra;
        this.jndiStrategy = jndiStrategy;
        this.cfs = cfs;
        this.tmpDirectory = tmpDirectory;
        this.cl = cl;
    }

    public URL getURL() {
        return this.deployment;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public void stop() {
        log.debug((Object)("Undeploying: " + this.deployment.toExternalForm()));
        if (this.cfs != null) {
            try {
                this.jndiStrategy.unbindConnectionFactories(this.deploymentName, this.cfs);
            }
            catch (Throwable t) {
                log.warn((Object)"Exception during JNDI unbinding", t);
            }
        }
        if (this.ra != null) {
            this.ra.stop();
            this.ra = null;
        }
    }

    public void destroy() {
        if (this.cl != null && this.cl instanceof Closeable) {
            try {
                ((Closeable)((Object)this.cl)).close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (this.tmpDirectory != null && this.tmpDirectory.exists()) {
            try {
                FileUtil fu = new FileUtil();
                fu.recursiveDelete(this.tmpDirectory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        log.info((Object)("Undeployed: " + this.deployment.toExternalForm()));
    }
}

