/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.util.Injection;
import com.github.fungal.api.util.JarFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.TransactionManager;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.core.spi.mdr.AlreadyExistsException;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.deployers.common.AbstractResourceAdapterDeployer;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.jca.deployers.fungal.RAConfiguration;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.logging.Logger;

public abstract class AbstractFungalRADeployer
extends AbstractResourceAdapterDeployer {
    public AbstractFungalRADeployer(boolean validateClasses, Logger log) {
        super(validateClasses, log);
    }

    public Object initAndInject(String className, List<? extends ConfigProperty> configs, ClassLoader cl) throws DeployException {
        try {
            Class<?> clz = Class.forName(className, true, cl);
            Object o = clz.newInstance();
            if (configs != null) {
                Injection injector = new Injection();
                for (ConfigProperty configProperty : configs) {
                    if (!configProperty.isValueSet()) continue;
                    injector.inject(configProperty.getConfigPropertyType().getValue(), configProperty.getConfigPropertyName().getValue(), configProperty.getConfigPropertyValue().getValue(), o);
                }
            }
            return o;
        }
        catch (Throwable t) {
            throw new DeployException("Deployment " + className + " failed", t);
        }
    }

    protected URL[] getUrls(File directory) throws MalformedURLException, IOException {
        LinkedList<URL> list = new LinkedList<URL>();
        if (directory.exists() && directory.isDirectory()) {
            list.add(directory.toURI().toURL());
            File[] jars = directory.listFiles((FilenameFilter)new JarFilter());
            if (jars != null) {
                for (int j = 0; j < jars.length; ++j) {
                    list.add(jars[j].getCanonicalFile().toURI().toURL());
                }
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    public String[] bindConnectionFactory(URL url, String deployment, Object cf) throws Throwable {
        JndiStrategy js = ((RAConfiguration)this.getConfiguration()).getJndiStrategy().clone();
        String[] result = js.bindConnectionFactories(deployment, new Object[]{cf});
        ((RAConfiguration)this.getConfiguration()).getMetadataRepository().registerJndiMapping(url.toExternalForm(), cf.getClass().getName(), result[0]);
        return result;
    }

    public String[] bindConnectionFactory(URL url, String deployment, Object cf, String jndi) throws Throwable {
        JndiStrategy js = ((RAConfiguration)this.getConfiguration()).getJndiStrategy().clone();
        String[] result = js.bindConnectionFactories(deployment, new Object[]{cf}, new String[]{jndi});
        ((RAConfiguration)this.getConfiguration()).getMetadataRepository().registerJndiMapping(url.toExternalForm(), cf.getClass().getName(), jndi);
        return result;
    }

    protected File getReportDirectory() {
        return new File(SecurityActions.getSystemProperty("iron.jacamar.home"), "/log/");
    }

    protected boolean checkConfigurationIsValid() {
        return this.getConfiguration() != null && this.getConfiguration() instanceof RAConfiguration;
    }

    protected PrintWriter getLogPrintWriter() {
        return new PrintWriter(((RAConfiguration)this.getConfiguration()).getPrintStream());
    }

    protected TransactionManager getTransactionManager() {
        return ((RAConfiguration)this.getConfiguration()).getTransactionManager();
    }

    protected void registerResourceAdapterToMDR(URL url, File root, Connector cmd, IronJacamar ijmd) throws AlreadyExistsException {
        ((RAConfiguration)this.getConfiguration()).getMetadataRepository().registerResourceAdapter(url.toExternalForm(), root, cmd, ijmd);
    }
}

