/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.Kernel;
import com.github.fungal.api.util.Injection;
import com.github.fungal.spi.deployers.DeployException;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.Deployment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import javax.transaction.TransactionManager;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.ds.CommonDataSource;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.metadata.ds.DsParser;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.core.connectionmanager.ConnectionManagerFactory;
import org.jboss.jca.core.connectionmanager.TxConnectionManager;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.pool.api.PoolFactory;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;
import org.jboss.jca.core.naming.ExplicitJndiStrategy;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.deployers.fungal.DsXmlDeployment;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.logging.Logger;

public final class DsXmlDeployer
implements Deployer {
    private static Logger log = Logger.getLogger(DsXmlDeployer.class);
    private static boolean trace = log.isTraceEnabled();
    private String jdbcLocal = null;
    private String jdbcXA = null;
    private TransactionManager transactionManager = null;
    private MetadataRepository mdr = null;
    private Kernel kernel = null;

    public void setJDBCLocal(String value) {
        this.jdbcLocal = value;
    }

    public String getJDBCLocal() {
        return this.jdbcLocal;
    }

    public void setJDBCXA(String value) {
        this.jdbcXA = value;
    }

    public String getJDBCXA() {
        return this.jdbcXA;
    }

    public void setTransactionManager(TransactionManager value) {
        this.transactionManager = value;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setMetadataRepository(MetadataRepository value) {
        this.mdr = value;
    }

    public MetadataRepository getMetadataRepository() {
        return this.mdr;
    }

    public void setKernel(Kernel value) {
        this.kernel = value;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public synchronized Deployment deploy(URL url, ClassLoader parent) throws DeployException {
        if (url == null || !url.toExternalForm().endsWith("-ds.xml")) {
            return null;
        }
        log.debug((Object)("Deploying: " + url.toExternalForm()));
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        InputStream is = null;
        try {
            Object cf;
            String jndiName;
            File f = new File(url.toURI());
            if (!f.exists()) {
                throw new IOException("Deployment " + url.toExternalForm() + " doesnt exists");
            }
            is = new FileInputStream(f);
            DsParser dsParser = new DsParser();
            DataSources dataSources = dsParser.parse(is);
            String deploymentName = f.getName();
            Set raDeployments = this.mdr.getResourceAdapters();
            URL urlJdbcLocal = null;
            URL urlJdbcXA = null;
            for (String s : raDeployments) {
                if (s.endsWith(this.jdbcLocal)) {
                    urlJdbcLocal = new URL(s);
                    continue;
                }
                if (!s.endsWith(this.jdbcXA)) continue;
                urlJdbcXA = new URL(s);
            }
            ArrayList<Object> cfs = new ArrayList<Object>(1);
            ArrayList<String> jndis = new ArrayList<String>(1);
            if (urlJdbcLocal != null) {
                List ds = dataSources.getDataSource();
                if (ds != null) {
                    Deployment jdbcLocalDeployment = this.kernel.getDeployment(urlJdbcLocal);
                    for (DataSource dataSource : ds) {
                        try {
                            jndiName = dataSource.getJndiName();
                            if (!jndiName.startsWith("java:/")) {
                                jndiName = "java:/" + jndiName;
                            }
                            cf = this.deployDataSource(dataSource, jndiName, urlJdbcLocal, jdbcLocalDeployment.getClassLoader());
                            this.bindConnectionFactory(deploymentName, jndiName, cf);
                            cfs.add(cf);
                            jndis.add(jndiName);
                        }
                        catch (Throwable t) {
                            log.error((Object)("Error during the deployment of " + dataSource.getJndiName()), t);
                        }
                    }
                }
            } else if (dataSources.getDataSource() != null && dataSources.getDataSource().size() > 0) {
                log.error((Object)"Deployment of datasources disabled since jdbc-local.rar couldn't be found");
            }
            if (urlJdbcXA != null) {
                List xads = dataSources.getXaDataSource();
                if (xads != null) {
                    Deployment jdbcXADeployment = this.kernel.getDeployment(urlJdbcXA);
                    for (XaDataSource xaDataSource : xads) {
                        try {
                            jndiName = xaDataSource.getJndiName();
                            if (!jndiName.startsWith("java:/")) {
                                jndiName = "java:/" + jndiName;
                            }
                            cf = this.deployXADataSource(xaDataSource, jndiName, urlJdbcXA, jdbcXADeployment.getClassLoader());
                            this.bindConnectionFactory(deploymentName, jndiName, cf);
                            cfs.add(cf);
                            jndis.add(jndiName);
                        }
                        catch (Throwable t) {
                            log.error((Object)("Error during the deployment of " + xaDataSource.getJndiName()), t);
                        }
                    }
                }
            } else if (dataSources.getXaDataSource() != null && dataSources.getXaDataSource().size() > 0) {
                log.error((Object)"Deployment of XA datasources disabled since jdbc-xa.rar couldn't be found");
            }
            DsXmlDeployment dsXmlDeployment = new DsXmlDeployment(url, deploymentName, cfs.toArray(new Object[cfs.size()]), jndis.toArray(new String[jndis.size()]), parent);
            return dsXmlDeployment;
        }
        catch (DeployException de) {
            throw de;
        }
        catch (Throwable t) {
            throw new DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    private Object deployDataSource(DataSource ds, String jndiName, URL ra, ClassLoader cl) throws Throwable {
        log.debug((Object)("DataSource=" + ds));
        Merger merger = new Merger();
        Connector md = this.mdr.getResourceAdapter(ra.toExternalForm());
        md = merger.mergeConnectorAndDs((CommonDataSource)ds, md);
        ResourceAdapter1516 ra1516 = (ResourceAdapter1516)md.getResourceadapter();
        List cds = ra1516.getOutboundResourceadapter().getConnectionDefinitions();
        ConnectionDefinition cd = (ConnectionDefinition)cds.get(0);
        ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(cd.getManagedConnectionFactoryClass().getValue(), cd.getConfigProperties(), cl);
        PoolConfiguration pc = this.createPoolConfiguration(ds.getPool(), (CommonTimeOut)ds.getTimeOut(), (CommonValidation)ds.getValidation());
        PoolFactory pf = new PoolFactory();
        Pool pool = pf.create(PoolStrategy.ONE_POOL, mcf, pc, false);
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        if (ds.getTimeOut() != null) {
            allocationRetry = ds.getTimeOut().getAllocationRetry();
            allocationRetryWaitMillis = ds.getTimeOut().getAllocationRetryWaitMillis();
        }
        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
        TxConnectionManager cm = cmf.createTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis, this.getTransactionManager(), null, null, null, null, null);
        cm.setJndiName(jndiName);
        return mcf.createConnectionFactory((ConnectionManager)cm);
    }

    private Object deployXADataSource(XaDataSource ds, String jndiName, URL ra, ClassLoader cl) throws Throwable {
        log.debug((Object)("XaDataSource=" + ds));
        Merger merger = new Merger();
        Connector md = this.mdr.getResourceAdapter(ra.toExternalForm());
        md = merger.mergeConnectorAndDs((CommonDataSource)ds, md);
        ResourceAdapter1516 ra1516 = (ResourceAdapter1516)md.getResourceadapter();
        List cds = ra1516.getOutboundResourceadapter().getConnectionDefinitions();
        ConnectionDefinition cd = (ConnectionDefinition)cds.get(0);
        ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(cd.getManagedConnectionFactoryClass().getValue(), cd.getConfigProperties(), cl);
        PoolConfiguration pc = this.createPoolConfiguration((CommonPool)ds.getXaPool(), (CommonTimeOut)ds.getTimeOut(), (CommonValidation)ds.getValidation());
        Boolean noTxSeparatePool = Boolean.FALSE;
        if (ds.getXaPool() != null && ds.getXaPool().isNoTxSeparatePool() != null) {
            noTxSeparatePool = ds.getXaPool().isNoTxSeparatePool();
        }
        PoolFactory pf = new PoolFactory();
        Pool pool = pf.create(PoolStrategy.ONE_POOL, mcf, pc, noTxSeparatePool.booleanValue());
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        Boolean interleaving = null;
        Integer xaResourceTimeout = null;
        Boolean isSameRMOverride = null;
        Boolean wrapXAResource = null;
        Boolean padXid = null;
        if (ds.getTimeOut() != null) {
            allocationRetry = ds.getTimeOut().getAllocationRetry();
            allocationRetryWaitMillis = ds.getTimeOut().getAllocationRetryWaitMillis();
            xaResourceTimeout = ds.getTimeOut().getXaResourceTimeout();
        }
        if (ds.getXaPool() != null) {
            interleaving = ds.getXaPool().isInterleaving();
            isSameRMOverride = ds.getXaPool().isSameRmOverride();
            wrapXAResource = ds.getXaPool().isWrapXaDataSource();
            padXid = ds.getXaPool().isPadXid();
        }
        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
        TxConnectionManager cm = cmf.createTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis, this.getTransactionManager(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
        cm.setJndiName(jndiName);
        return mcf.createConnectionFactory((ConnectionManager)cm);
    }

    private PoolConfiguration createPoolConfiguration(CommonPool pp, CommonTimeOut tp, CommonValidation vp) {
        PoolConfiguration pc = new PoolConfiguration();
        if (pp != null) {
            if (pp.getMinPoolSize() != null) {
                pc.setMinSize(pp.getMinPoolSize().intValue());
            }
            if (pp.getMaxPoolSize() != null) {
                pc.setMaxSize(pp.getMaxPoolSize().intValue());
            }
            if (pp.isPrefill() != null) {
                pc.setPrefill(pp.isPrefill().booleanValue());
            }
            if (pp.isUseStrictMin() != null) {
                pc.setStrictMin(pp.isUseStrictMin().booleanValue());
            }
        }
        if (tp != null) {
            if (tp.getBlockingTimeoutMillis() != null) {
                pc.setBlockingTimeout(tp.getBlockingTimeoutMillis().longValue());
            }
            if (tp.getIdleTimeoutMinutes() != null) {
                pc.setIdleTimeout(tp.getIdleTimeoutMinutes().longValue());
            }
        }
        if (vp != null) {
            if (vp.isBackgroundValidation() != null) {
                pc.setBackgroundValidation(vp.isBackgroundValidation().booleanValue());
            }
            if (vp.getBackgroundValidationMinutes() != null) {
                pc.setBackgroundValidationMinutes(vp.getBackgroundValidationMinutes().intValue());
            }
            if (vp.isUseFastFail() != null) {
                pc.setUseFastFail(vp.isUseFastFail().booleanValue());
            }
        }
        return pc;
    }

    private Object initAndInject(String className, List<? extends ConfigProperty> configs, ClassLoader cl) throws DeployException {
        try {
            Class<?> clz = Class.forName(className, true, cl);
            Object o = clz.newInstance();
            if (configs != null) {
                Injection injector = new Injection();
                for (ConfigProperty configProperty : configs) {
                    if (!configProperty.isValueSet()) continue;
                    injector.inject(configProperty.getConfigPropertyType().getValue(), configProperty.getConfigPropertyName().getValue(), configProperty.getConfigPropertyValue().getValue(), o);
                }
            }
            return o;
        }
        catch (Throwable t) {
            throw new DeployException("Deployment " + className + " failed", t);
        }
    }

    private String[] bindConnectionFactory(String deployment, String jndi, Object cf) throws Throwable {
        ExplicitJndiStrategy js = new ExplicitJndiStrategy();
        return js.bindConnectionFactories(deployment, new Object[]{cf}, new String[]{jndi});
    }

    public void start() {
        if (this.transactionManager == null) {
            throw new IllegalStateException("TransactionManager not defined");
        }
        if (this.mdr == null) {
            throw new IllegalStateException("MetadataRepository not defined");
        }
        if (this.kernel == null) {
            throw new IllegalStateException("Kernel not defined");
        }
    }
}

