/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.util.Injection;
import com.github.fungal.api.util.JarFilter;
import com.github.fungal.spi.deployers.DeployException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.core.api.bootstrap.CloneableBootstrapContext;
import org.jboss.jca.core.connectionmanager.pool.api.PoolConfiguration;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.deployers.fungal.RAConfiguration;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.jca.validator.Failure;
import org.jboss.jca.validator.FailureHelper;
import org.jboss.jca.validator.Validate;
import org.jboss.jca.validator.Validator;
import org.jboss.logging.Logger;

public abstract class AbstractResourceAdapterDeployer {
    private static Logger log = Logger.getLogger(AbstractResourceAdapterDeployer.class);
    private static boolean trace = log.isTraceEnabled();
    private RAConfiguration raConfiguration = null;

    AbstractResourceAdapterDeployer() {
    }

    public void setConfiguration(RAConfiguration value) {
        this.raConfiguration = value;
    }

    public RAConfiguration getConfiguration() {
        return this.raConfiguration;
    }

    List<Failure> validateArchive(URL url, List<Validate> archiveValidation) {
        if (!this.getConfiguration().getArchiveValidation()) {
            return null;
        }
        Validator validator = new Validator();
        List failures = validator.validate(archiveValidation);
        return failures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String printFailuresLog(String urlFileName, Validator validator, Collection<Failure> failures, File reportDirectory, FailureHelper ... fhInput) {
        String errorText = "";
        FailureHelper fh = null;
        fh = fhInput.length == 0 ? new FailureHelper(failures) : fhInput[0];
        if (failures != null && failures.size() > 0) {
            if (reportDirectory == null) {
                reportDirectory = new File(SecurityActions.getSystemProperty("iron.jacamar.home"), "/log/");
            }
            if (reportDirectory.exists()) {
                int lastSepaIndex;
                int lastIndex;
                int lastSlashIndex = urlFileName.lastIndexOf("/");
                int n = lastIndex = lastSlashIndex > (lastSepaIndex = urlFileName.lastIndexOf(File.separator)) ? lastSlashIndex : lastSepaIndex;
                if (lastIndex != -1) {
                    urlFileName = urlFileName.substring(lastIndex + 1);
                }
                urlFileName = urlFileName + ".log";
                File report = new File(reportDirectory, urlFileName);
                FileWriter fw = null;
                BufferedWriter bw = null;
                try {
                    fw = new FileWriter(report);
                    bw = new BufferedWriter(fw, 8192);
                    bw.write(fh.asText(validator.getResourceBundle()));
                    bw.flush();
                    errorText = "Validation failures - see: " + report.getAbsolutePath();
                }
                catch (IOException ioe) {
                    log.warn((Object)ioe.getMessage(), (Throwable)ioe);
                }
                finally {
                    if (bw != null) {
                        try {
                            bw.close();
                        }
                        catch (IOException ignore) {}
                    }
                    if (fw != null) {
                        try {
                            fw.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            } else {
                errorText = fh.asText(validator.getResourceBundle());
            }
        }
        return errorText;
    }

    protected boolean hasFailuresLevel(Collection<Failure> failures, int severity) {
        if (failures != null) {
            for (Failure failure : failures) {
                if (failure.getSeverity() != severity) continue;
                return true;
            }
        }
        return false;
    }

    protected void startContext(ResourceAdapter resourceAdapter, String bootstrapIdentifier) throws DeployException {
        try {
            CloneableBootstrapContext bc;
            Class<?> clz = resourceAdapter.getClass();
            Method start = clz.getMethod("start", BootstrapContext.class);
            CloneableBootstrapContext cbc = null;
            if (bootstrapIdentifier != null && this.getConfiguration().getBootstrapContexts() != null && (bc = this.getConfiguration().getBootstrapContexts().get(bootstrapIdentifier)) != null) {
                cbc = bc.clone();
            }
            if (cbc == null) {
                cbc = this.getConfiguration().getDefaultBootstrapContext().clone();
            }
            start.invoke((Object)resourceAdapter, cbc);
        }
        catch (InvocationTargetException ite) {
            throw new DeployException("Unable to start " + resourceAdapter.getClass().getName(), ite.getTargetException());
        }
        catch (Throwable t) {
            throw new DeployException("Unable to start " + resourceAdapter.getClass().getName(), t);
        }
    }

    protected void associateResourceAdapter(ResourceAdapter resourceAdapter, Object object) throws DeployException {
        if (resourceAdapter != null && object != null && object instanceof ResourceAdapterAssociation) {
            try {
                Class<?> clz = object.getClass();
                Method setResourceAdapter = clz.getMethod("setResourceAdapter", ResourceAdapter.class);
                setResourceAdapter.invoke(object, resourceAdapter);
            }
            catch (Throwable t) {
                throw new DeployException("Unable to associate " + object.getClass().getName(), t);
            }
        }
    }

    protected Object initAndInject(String className, List<? extends ConfigProperty> configs, ClassLoader cl) throws DeployException {
        try {
            Class<?> clz = Class.forName(className, true, cl);
            Object o = clz.newInstance();
            if (configs != null) {
                Injection injector = new Injection();
                for (ConfigProperty configProperty : configs) {
                    if (!configProperty.isValueSet()) continue;
                    injector.inject(configProperty.getConfigPropertyType().getValue(), configProperty.getConfigPropertyName().getValue(), configProperty.getConfigPropertyValue().getValue(), o);
                }
            }
            return o;
        }
        catch (Throwable t) {
            throw new DeployException("Deployment " + className + " failed", t);
        }
    }

    protected URL[] getUrls(File directory) throws MalformedURLException, IOException {
        LinkedList<URL> list = new LinkedList<URL>();
        if (directory.exists() && directory.isDirectory()) {
            list.add(directory.toURI().toURL());
            File[] jars = directory.listFiles((FilenameFilter)new JarFilter());
            if (jars != null) {
                for (int j = 0; j < jars.length; ++j) {
                    list.add(jars[j].getCanonicalFile().toURI().toURL());
                }
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    protected String[] bindConnectionFactory(URL url, String deployment, Object cf) throws Throwable {
        JndiStrategy js = this.getConfiguration().getJndiStrategy().clone();
        String[] result = js.bindConnectionFactories(deployment, new Object[]{cf});
        this.getConfiguration().getMetadataRepository().registerJndiMapping(url, cf.getClass().getName(), result[0]);
        return result;
    }

    protected String[] bindConnectionFactory(URL url, String deployment, Object cf, String jndi) throws Throwable {
        JndiStrategy js = this.getConfiguration().getJndiStrategy().clone();
        String[] result = js.bindConnectionFactories(deployment, new Object[]{cf}, new String[]{jndi});
        this.getConfiguration().getMetadataRepository().registerJndiMapping(url, cf.getClass().getName(), jndi);
        return result;
    }

    protected CommonConnDef findConnectionDefinition(String clz, List<CommonConnDef> defs) {
        if (defs != null) {
            if (defs.size() == 1) {
                CommonConnDef cd = defs.get(0);
                if (cd.getClassName() != null && !clz.equals(cd.getClassName())) {
                    log.warn((Object)("Only one connection definitopn found with a mis-match in class-name: " + cd));
                    return null;
                }
                return cd;
            }
            if (clz == null) {
                throw new IllegalArgumentException("ManagedConnectionFactory must be defined in class-name");
            }
            for (CommonConnDef cd : defs) {
                if (!clz.equals(cd.getClassName())) continue;
                return cd;
            }
        }
        return null;
    }

    protected PoolConfiguration createPoolConfiguration(CommonPool pp, CommonTimeOut tp, CommonValidation vp) {
        PoolConfiguration pc = new PoolConfiguration();
        if (pp != null) {
            if (pp.getMinPoolSize() != null) {
                pc.setMinSize(pp.getMinPoolSize().intValue());
            }
            if (pp.getMaxPoolSize() != null) {
                pc.setMaxSize(pp.getMaxPoolSize().intValue());
            }
            if (pp.isPrefill() != null) {
                pc.setPrefill(pp.isPrefill().booleanValue());
            }
            if (pp.isUseStrictMin() != null) {
                pc.setStrictMin(pp.isUseStrictMin().booleanValue());
            }
        }
        if (tp != null) {
            if (tp.getBlockingTimeoutMillis() != null) {
                pc.setBlockingTimeout(tp.getBlockingTimeoutMillis().longValue());
            }
            if (tp.getIdleTimeoutMinutes() != null) {
                pc.setIdleTimeout(tp.getIdleTimeoutMinutes().longValue());
            }
        }
        if (vp != null) {
            if (vp.isBackgroundValidation() != null) {
                pc.setBackgroundValidation(vp.isBackgroundValidation().booleanValue());
            }
            if (vp.getBackgroundValidationMinutes() != null) {
                pc.setBackgroundValidationMinutes(vp.getBackgroundValidationMinutes().intValue());
            }
            if (vp.isUseFastFail() != null) {
                pc.setUseFastFail(vp.isUseFastFail().booleanValue());
            }
        }
        return pc;
    }

    public void start() {
        if (this.raConfiguration == null) {
            throw new IllegalStateException("Configuration not defined");
        }
    }
}

