/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.classloading.ClassLoaderFactory;
import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.api.util.FileUtil;
import com.github.fungal.spi.deployers.DeployException;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.DeployerOrder;
import com.github.fungal.spi.deployers.Deployment;
import com.github.fungal.spi.deployers.MultiStageDeployer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.resource.Referenceable;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.TransactionSupport;
import org.jboss.jca.common.annotations.Annotations;
import org.jboss.jca.common.annotations.repository.papaki.AnnotationScannerFactory;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonIronJacamar;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.AdminObject;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.MessageListener;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.ra10.ResourceAdapter10;
import org.jboss.jca.common.metadata.MetadataFactory;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.common.spi.annotations.repository.AnnotationRepository;
import org.jboss.jca.common.spi.annotations.repository.AnnotationScanner;
import org.jboss.jca.core.connectionmanager.ConnectionManagerFactory;
import org.jboss.jca.core.connectionmanager.NoTxConnectionManager;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.pool.api.PoolFactory;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;
import org.jboss.jca.deployers.fungal.AbstractResourceAdapterDeployer;
import org.jboss.jca.deployers.fungal.BeanValidation;
import org.jboss.jca.deployers.fungal.RADeployment;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.jca.validator.Failure;
import org.jboss.jca.validator.FailureHelper;
import org.jboss.jca.validator.Key;
import org.jboss.jca.validator.Validate;
import org.jboss.jca.validator.ValidateClass;
import org.jboss.jca.validator.ValidateObject;
import org.jboss.jca.validator.Validator;
import org.jboss.jca.validator.ValidatorException;
import org.jboss.logging.Logger;

public final class RADeployer
extends AbstractResourceAdapterDeployer
implements Deployer,
MultiStageDeployer,
DeployerOrder {
    private static Logger log = Logger.getLogger(RADeployer.class);
    private static boolean trace = log.isTraceEnabled();

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public synchronized Deployment deploy(URL url, ClassLoader parent) throws DeployException {
        if (url == null || !url.toExternalForm().endsWith(".rar") && !url.toExternalForm().endsWith(".rar/")) {
            return null;
        }
        HashSet<Object> failures = null;
        log.debug((Object)("Deploying: " + url.toExternalForm()));
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        try {
            boolean activateDeployment;
            String deploymentName;
            String[] jndiNames;
            Object[] cfs;
            ArrayList<Object> beanValidationObjects;
            List<Failure> partialFailures;
            ArrayList<Validate> archiveValidationObjects;
            ResourceAdapter resourceAdapter;
            IronJacamar ijmd;
            Connector cmd;
            KernelClassLoader cl;
            File destination;
            File root;
            block70: {
                List aoMetas;
                List mlMetas;
                ResourceAdapter1516 ra1516;
                block72: {
                    List cdMetas;
                    block71: {
                        CommonXaPool ijXaPool;
                        CommonConnDef ijCD;
                        File f = new File(url.toURI());
                        if (!f.exists()) {
                            throw new IOException("Archive " + url.toExternalForm() + " doesnt exists");
                        }
                        root = null;
                        destination = null;
                        if (f.isFile()) {
                            FileUtil fileUtil = new FileUtil();
                            destination = new File(SecurityActions.getSystemProperty("iron.jacamar.home"), "/tmp/");
                            root = fileUtil.extract(f, destination);
                        } else {
                            root = f;
                        }
                        URL[] urls = this.getUrls(root);
                        cl = null;
                        cl = this.getConfiguration().getScopeDeployment() ? ClassLoaderFactory.create((int)1, (URL[])urls, (ClassLoader)parent) : ClassLoaderFactory.create((int)0, (URL[])urls, (ClassLoader)parent);
                        SecurityActions.setThreadContextClassLoader((ClassLoader)cl);
                        MetadataFactory metadataFactory = new MetadataFactory();
                        cmd = metadataFactory.getStandardMetaData(root);
                        ijmd = metadataFactory.getIronJacamarMetaData(root);
                        Annotations annotator = new Annotations();
                        AnnotationScanner scanner = new AnnotationScannerFactory().createScanner();
                        AnnotationRepository repository = scanner.scan(cl.getURLs(), (ClassLoader)cl);
                        cmd = annotator.merge(cmd, repository);
                        cmd.validate();
                        cmd = new Merger().mergeConnectorWithCommonIronJacamar((CommonIronJacamar)ijmd, cmd);
                        if (cmd != null && cmd.getLicense() != null && cmd.getLicense().isLicenseRequired()) {
                            log.info((Object)("Required license terms for " + url.toExternalForm()));
                        }
                        resourceAdapter = null;
                        archiveValidationObjects = new ArrayList<Validate>();
                        partialFailures = null;
                        beanValidationObjects = new ArrayList<Object>();
                        cfs = null;
                        jndiNames = null;
                        deploymentName = f.getName().substring(0, f.getName().indexOf(".rar"));
                        activateDeployment = this.checkActivation(cmd, ijmd);
                        if (cmd == null) break block70;
                        if (cmd.getVersion() != Connector.Version.V_10 && (ra1516 = (ResourceAdapter1516)cmd.getResourceadapter()) != null && ra1516.getResourceadapterClass() != null) {
                            partialFailures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.RESOURCE_ADAPTER, ra1516.getResourceadapterClass(), (ClassLoader)cl, cmd.getResourceadapter().getConfigProperties())));
                            if (partialFailures != null) {
                                failures = new HashSet();
                                failures.addAll(partialFailures);
                            }
                            if (!(this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1) || !activateDeployment)) {
                                resourceAdapter = (ResourceAdapter)this.initAndInject(ra1516.getResourceadapterClass(), ra1516.getConfigProperties(), (ClassLoader)cl);
                                if (trace) {
                                    log.trace((Object)("ResourceAdapter: " + resourceAdapter.getClass().getName()));
                                    log.trace((Object)("ResourceAdapter defined in classloader: " + resourceAdapter.getClass().getClassLoader()));
                                }
                                archiveValidationObjects.add((Validate)new ValidateObject(Key.RESOURCE_ADAPTER, (Object)resourceAdapter, ra1516.getConfigProperties()));
                                beanValidationObjects.add(resourceAdapter);
                            }
                        }
                        if (cmd.getVersion() != Connector.Version.V_10) break block71;
                        ResourceAdapter10 ra10 = (ResourceAdapter10)cmd.getResourceadapter();
                        if (!activateDeployment || !(ijCD = this.findConnectionDefinition(ra10.getManagedConnectionFactoryClass().getValue(), ijmd.getConnectionDefinitions())).isEnabled().booleanValue()) break block72;
                        ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(ra10.getManagedConnectionFactoryClass().getValue(), ra10.getConfigProperties(), (ClassLoader)cl);
                        if (trace) {
                            log.trace((Object)("ManagedConnectionFactory: " + mcf.getClass().getName()));
                            log.trace((Object)("ManagedConnectionFactory defined in classloader: " + mcf.getClass().getClassLoader()));
                        }
                        mcf.setLogWriter(new PrintWriter(this.getConfiguration().getPrintStream()));
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.MANAGED_CONNECTION_FACTORY, (Object)mcf, ra10.getConfigProperties()));
                        beanValidationObjects.add(mcf);
                        this.associateResourceAdapter(resourceAdapter, mcf);
                        PoolConfiguration poolConfiguration = this.createPoolConfiguration(ijCD != null ? ijCD.getPool() : null, ijCD != null ? ijCD.getTimeOut() : null, ijCD != null ? ijCD.getValidation() : null);
                        PoolFactory pf = new PoolFactory();
                        Boolean noTxSeparatePool = Boolean.FALSE;
                        if (ijCD != null && ijCD.getPool() != null && ijCD.isXa().booleanValue() && (ijXaPool = (CommonXaPool)ijCD.getPool()) != null) {
                            noTxSeparatePool = ijXaPool.isNoTxSeparatePool();
                        }
                        Pool pool = pf.create(PoolStrategy.ONE_POOL, mcf, poolConfiguration, noTxSeparatePool.booleanValue());
                        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
                        NoTxConnectionManager cm = null;
                        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                        TransactionSupportEnum tsmd = TransactionSupportEnum.NoTransaction;
                        tsmd = ijmd != null && ijmd.getTransactionSupport() != null ? ijmd.getTransactionSupport() : ((ResourceAdapter10)cmd.getResourceadapter()).getTransactionSupport();
                        if (tsmd == TransactionSupportEnum.NoTransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                        } else if (tsmd == TransactionSupportEnum.LocalTransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
                        } else if (tsmd == TransactionSupportEnum.XATransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
                        }
                        Integer allocationRetry = null;
                        Long allocationRetryWaitMillis = null;
                        if (ijCD != null && ijCD.getTimeOut() != null) {
                            allocationRetry = ijCD.getTimeOut().getAllocationRetry();
                            allocationRetryWaitMillis = ijCD.getTimeOut().getAllocationRetryWaitMillis();
                        }
                        if (tsl == TransactionSupport.TransactionSupportLevel.NoTransaction) {
                            cm = cmf.createNonTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis);
                        } else {
                            CommonXaPool ijXaPool2;
                            Boolean interleaving = null;
                            Integer xaResourceTimeout = null;
                            Boolean isSameRMOverride = null;
                            Boolean wrapXAResource = null;
                            Boolean padXid = null;
                            if (ijCD != null && ijCD.getPool() != null && ijCD.isXa().booleanValue() && (ijXaPool2 = (CommonXaPool)ijCD.getPool()) != null) {
                                interleaving = ijXaPool2.isInterleaving();
                                isSameRMOverride = ijXaPool2.isSameRmOverride();
                                wrapXAResource = ijXaPool2.isWrapXaDataSource();
                                padXid = ijXaPool2.isPadXid();
                            }
                            cm = cmf.createTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis, this.getConfiguration().getTransactionManager(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
                        }
                        Object cf = mcf.createConnectionFactory((ConnectionManager)cm);
                        if (cf == null) {
                            log.error((Object)"ConnectionFactory is null");
                        } else if (trace) {
                            log.trace((Object)("ConnectionFactory: " + cf.getClass().getName()));
                            log.trace((Object)("ConnectionFactory defined in classloader: " + cf.getClass().getClassLoader()));
                        }
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.CONNECTION_FACTORY, cf));
                        if (cf == null || !(cf instanceof Serializable) || !(cf instanceof Referenceable)) break block72;
                        String jndiName = ijCD.getJndiName();
                        this.bindConnectionFactory(url, deploymentName, cf, jndiName);
                        cfs = new Object[]{cf};
                        jndiNames = new String[]{jndiName};
                        cm.setJndiName(jndiName);
                        break block72;
                    }
                    ResourceAdapter1516 ra = (ResourceAdapter1516)cmd.getResourceadapter();
                    if (ra != null && ra.getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getConnectionDefinitions() != null && (cdMetas = ra.getOutboundResourceadapter().getConnectionDefinitions()).size() > 0) {
                        cfs = new Object[cdMetas.size()];
                        jndiNames = new String[cdMetas.size()];
                        for (int cdIndex = 0; cdIndex < cdMetas.size(); ++cdIndex) {
                            CommonXaPool ijXaPool;
                            CommonConnDef ijCD;
                            ConnectionDefinition connectionDefinition = (ConnectionDefinition)cdMetas.get(cdIndex);
                            partialFailures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.MANAGED_CONNECTION_FACTORY, connectionDefinition.getManagedConnectionFactoryClass().getValue(), (ClassLoader)cl, connectionDefinition.getConfigProperties())));
                            if (partialFailures != null) {
                                failures = new HashSet();
                                failures.addAll(partialFailures);
                            }
                            if (this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1) || !activateDeployment || !(ijCD = this.findConnectionDefinition(connectionDefinition.getManagedConnectionFactoryClass().getValue(), ijmd.getConnectionDefinitions())).isEnabled().booleanValue()) continue;
                            ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(connectionDefinition.getManagedConnectionFactoryClass().getValue(), connectionDefinition.getConfigProperties(), (ClassLoader)cl);
                            if (trace) {
                                log.trace((Object)("ManagedConnectionFactory: " + mcf.getClass().getName()));
                                log.trace((Object)("ManagedConnectionFactory defined in classloader: " + mcf.getClass().getClassLoader()));
                            }
                            mcf.setLogWriter(new PrintWriter(this.getConfiguration().getPrintStream()));
                            archiveValidationObjects.add((Validate)new ValidateObject(Key.MANAGED_CONNECTION_FACTORY, (Object)mcf, connectionDefinition.getConfigProperties()));
                            beanValidationObjects.add(mcf);
                            this.associateResourceAdapter(resourceAdapter, mcf);
                            PoolConfiguration pc = this.createPoolConfiguration(ijCD != null ? ijCD.getPool() : null, ijCD != null ? ijCD.getTimeOut() : null, ijCD != null ? ijCD.getValidation() : null);
                            PoolFactory pf = new PoolFactory();
                            Boolean noTxSeparatePool = Boolean.FALSE;
                            if (ijCD != null && ijCD.getPool() != null && ijCD.isXa().booleanValue() && (ijXaPool = (CommonXaPool)ijCD.getPool()) != null) {
                                noTxSeparatePool = ijXaPool.isNoTxSeparatePool();
                            }
                            Pool pool = pf.create(PoolStrategy.ONE_POOL, mcf, pc, noTxSeparatePool.booleanValue());
                            ConnectionManagerFactory cmf = new ConnectionManagerFactory();
                            NoTxConnectionManager cm = null;
                            TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                            TransactionSupportEnum tsmd = TransactionSupportEnum.NoTransaction;
                            tsmd = ijmd != null && ijmd.getTransactionSupport() != null ? ijmd.getTransactionSupport() : ra.getOutboundResourceadapter().getTransactionSupport();
                            if (tsmd == TransactionSupportEnum.NoTransaction) {
                                tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                            } else if (tsmd == TransactionSupportEnum.LocalTransaction) {
                                tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
                            } else if (tsmd == TransactionSupportEnum.XATransaction) {
                                tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
                            }
                            if (mcf instanceof TransactionSupport) {
                                tsl = ((TransactionSupport)mcf).getTransactionSupport();
                            }
                            Integer allocationRetry = null;
                            Long allocationRetryWaitMillis = null;
                            if (ijCD != null && ijCD.getTimeOut() != null) {
                                allocationRetry = ijCD.getTimeOut().getAllocationRetry();
                                allocationRetryWaitMillis = ijCD.getTimeOut().getAllocationRetryWaitMillis();
                            }
                            if (tsl == TransactionSupport.TransactionSupportLevel.NoTransaction) {
                                cm = cmf.createNonTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis);
                            } else {
                                Boolean interleaving = null;
                                Integer xaResourceTimeout = null;
                                Boolean isSameRMOverride = null;
                                Boolean wrapXAResource = null;
                                Boolean padXid = null;
                                if (ijCD != null && ijCD.isXa().booleanValue()) {
                                    CommonXaPool ijXaPool3 = (CommonXaPool)ijCD.getPool();
                                    interleaving = ijXaPool3.isInterleaving();
                                    isSameRMOverride = ijXaPool3.isSameRmOverride();
                                    wrapXAResource = ijXaPool3.isWrapXaDataSource();
                                    padXid = ijXaPool3.isPadXid();
                                }
                                cm = cmf.createTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis, this.getConfiguration().getTransactionManager(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
                            }
                            Object cf = mcf.createConnectionFactory((ConnectionManager)cm);
                            if (cf == null) {
                                log.error((Object)"ConnectionFactory is null");
                            } else if (trace) {
                                log.trace((Object)("ConnectionFactory: " + cf.getClass().getName()));
                                log.trace((Object)("ConnectionFactory defined in classloader: " + cf.getClass().getClassLoader()));
                            }
                            archiveValidationObjects.add((Validate)new ValidateObject(Key.CONNECTION_FACTORY, cf));
                            if (cf == null || !(cf instanceof Serializable) || !(cf instanceof Referenceable)) continue;
                            String jndiName = ijCD.getJndiName();
                            this.bindConnectionFactory(url, deploymentName, cf, jndiName);
                            cfs[cdIndex] = cf;
                            jndiNames[cdIndex] = jndiName;
                            cm.setJndiName(jndiName);
                        }
                    }
                }
                if (cmd.getVersion() != Connector.Version.V_10 && (ra1516 = (ResourceAdapter1516)cmd.getResourceadapter()) != null && ra1516.getInboundResourceadapter() != null && ra1516.getInboundResourceadapter().getMessageadapter() != null && ra1516.getInboundResourceadapter().getMessageadapter().getMessagelisteners() != null && (mlMetas = ra1516.getInboundResourceadapter().getMessageadapter().getMessagelisteners()).size() > 0) {
                    for (MessageListener messageListener : mlMetas) {
                        if (messageListener.getActivationspec() == null || messageListener.getActivationspec().getActivationspecClass().getValue() == null) continue;
                        partialFailures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.ACTIVATION_SPEC, messageListener.getActivationspec().getActivationspecClass().getValue(), (ClassLoader)cl, messageListener.getActivationspec().getConfigProperties())));
                        if (partialFailures != null) {
                            failures = new HashSet();
                            failures.addAll(partialFailures);
                        }
                        if (this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1) || !activateDeployment) continue;
                        List cpm = messageListener.getActivationspec().getConfigProperties();
                        Object o = this.initAndInject(messageListener.getActivationspec().getActivationspecClass().getValue(), cpm, (ClassLoader)cl);
                        if (trace) {
                            log.trace((Object)("ActivationSpec: " + o.getClass().getName()));
                            log.trace((Object)("ActivationSpec defined in classloader: " + o.getClass().getClassLoader()));
                        }
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.ACTIVATION_SPEC, o, cpm));
                        beanValidationObjects.add(o);
                        this.associateResourceAdapter(resourceAdapter, o);
                    }
                }
                if (cmd.getVersion() != Connector.Version.V_10 && (ra1516 = (ResourceAdapter1516)cmd.getResourceadapter()) != null && ra1516.getAdminObjects() != null && (aoMetas = ((ResourceAdapter1516)cmd.getResourceadapter()).getAdminObjects()).size() > 0) {
                    for (AdminObject adminObject : aoMetas) {
                        if (adminObject.getAdminobjectClass() == null || adminObject.getAdminobjectClass().getValue() == null) continue;
                        partialFailures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.ADMIN_OBJECT, adminObject.getAdminobjectClass().getValue(), (ClassLoader)cl, adminObject.getConfigProperties())));
                        if (partialFailures != null) {
                            failures = new HashSet();
                            failures.addAll(partialFailures);
                        }
                        if (this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1) || !activateDeployment) continue;
                        Object o = this.initAndInject(adminObject.getAdminobjectClass().getValue(), adminObject.getConfigProperties(), (ClassLoader)cl);
                        if (trace) {
                            log.trace((Object)("AdminObject: " + o.getClass().getName()));
                            log.trace((Object)("AdminObject defined in classloader: " + o.getClass().getClassLoader()));
                        }
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.ADMIN_OBJECT, o, adminObject.getConfigProperties()));
                        beanValidationObjects.add(o);
                    }
                }
            }
            if ((partialFailures = this.validateArchive(url, archiveValidationObjects)) != null) {
                if (failures == null) {
                    failures = new HashSet<Failure>();
                }
                failures.addAll(partialFailures);
            }
            if (this.getConfiguration().getArchiveValidationFailOnWarn() && this.hasFailuresLevel(failures, 0) || this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) {
                throw new ValidatorException(this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]), failures);
            }
            this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]);
            if (cmd != null) {
                this.getConfiguration().getMetadataRepository().registerResourceAdapter(url, root, cmd, ijmd);
            }
            if (activateDeployment) {
                if (this.getConfiguration().getBeanValidation()) {
                    ArrayList<Class> groupsClasses = null;
                    if (ijmd != null && ijmd.getBeanValidationGroups() != null && ijmd.getBeanValidationGroups().size() > 0) {
                        groupsClasses = new ArrayList<Class>();
                        for (String group : ijmd.getBeanValidationGroups()) {
                            groupsClasses.add(Class.forName(group, true, (ClassLoader)cl));
                        }
                    }
                    if (beanValidationObjects.size() > 0) {
                        BeanValidation beanValidator = new BeanValidation();
                        for (Object e : beanValidationObjects) {
                            beanValidator.validate(e, groupsClasses);
                        }
                    }
                }
                if (resourceAdapter != null) {
                    String bootstrapIdentifier = null;
                    if (ijmd != null) {
                        bootstrapIdentifier = ijmd.getBootstrapContext();
                    }
                    this.startContext(resourceAdapter, bootstrapIdentifier);
                }
            }
            if (activateDeployment) {
                log.info((Object)("Deployed: " + url.toExternalForm()));
            } else {
                log.debug((Object)("Activated: " + url.toExternalForm()));
            }
            RADeployment rADeployment = new RADeployment(url, deploymentName, activateDeployment, resourceAdapter, this.getConfiguration().getJndiStrategy(), this.getConfiguration().getMetadataRepository(), cfs, jndiNames, destination, (ClassLoader)cl, log);
            return rADeployment;
        }
        catch (DeployException de) {
            throw de;
        }
        catch (Throwable t) {
            if (this.getConfiguration().getArchiveValidationFailOnWarn() && this.hasFailuresLevel(failures, 0) || this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) {
                throw new DeployException("Deployment " + url.toExternalForm() + " failed", (Throwable)new ValidatorException(this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]), failures));
            }
            this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]);
            throw new DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    private boolean checkActivation(Connector cmd, IronJacamar ijmd) {
        if (cmd != null && ijmd != null) {
            HashSet<String> raClasses = new HashSet<String>();
            HashSet<String> ijClasses = new HashSet<String>();
            if (cmd.getVersion() == Connector.Version.V_10) {
                ResourceAdapter10 ra10 = (ResourceAdapter10)cmd.getResourceadapter();
                raClasses.add(ra10.getManagedConnectionFactoryClass().getValue());
            } else {
                List cdMetas;
                ResourceAdapter1516 ra = (ResourceAdapter1516)cmd.getResourceadapter();
                if (ra != null && ra.getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getConnectionDefinitions() != null && (cdMetas = ra.getOutboundResourceadapter().getConnectionDefinitions()).size() > 0) {
                    for (ConnectionDefinition cdMeta : cdMetas) {
                        raClasses.add(cdMeta.getManagedConnectionFactoryClass().getValue());
                    }
                }
            }
            if (raClasses.size() == 0) {
                return false;
            }
            if (ijmd.getConnectionDefinitions() != null) {
                for (CommonConnDef def : ijmd.getConnectionDefinitions()) {
                    String clz = def.getClassName();
                    if (clz == null && raClasses.size() == 1) {
                        return true;
                    }
                    if (clz == null) continue;
                    ijClasses.add(clz);
                }
            }
            for (String clz : raClasses) {
                if (ijClasses.contains(clz)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

