/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.spi.deployers.Deployment;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import javax.resource.spi.ResourceAdapter;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.logging.Logger;

public class RaXmlDeployment
implements Deployment {
    private Logger log;
    private URL deployment;
    private URL raDeployment;
    private String deploymentName;
    private ResourceAdapter ra;
    private JndiStrategy jndiStrategy;
    private MetadataRepository mdr;
    private Object[] cfs;
    private String[] jndis;
    private ClassLoader cl;

    public RaXmlDeployment(URL deployment, URL raDeployment, String deploymentName, ResourceAdapter ra, JndiStrategy jndiStrategy, MetadataRepository metadataRepository, Object[] cfs, String[] jndis, ClassLoader cl, Logger log) {
        this.deployment = deployment;
        this.raDeployment = raDeployment;
        this.deploymentName = deploymentName;
        this.ra = ra;
        this.jndiStrategy = jndiStrategy;
        this.mdr = metadataRepository;
        this.cfs = cfs;
        this.jndis = jndis;
        this.cl = cl;
        this.log = log;
    }

    public URL getURL() {
        return this.deployment;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public void stop() {
        this.log.debug((Object)("Undeploying: " + this.deployment.toExternalForm()));
        if (this.mdr != null && this.cfs != null && this.jndis != null) {
            for (int i = 0; i < this.cfs.length; ++i) {
                String cf = this.cfs[i].getClass().getName();
                String jndi = this.jndis[i];
                this.mdr.unregisterJndiMapping(this.raDeployment, cf, jndi);
            }
        }
        if (this.cfs != null && this.jndis != null) {
            try {
                this.jndiStrategy.unbindConnectionFactories(this.deploymentName, this.cfs, this.jndis);
            }
            catch (Throwable t) {
                this.log.warn((Object)"Exception during JNDI unbinding", t);
            }
        }
        if (this.ra != null) {
            this.ra.stop();
            this.ra = null;
        }
    }

    public void destroy() {
        if (this.cl != null && this.cl instanceof Closeable) {
            try {
                ((Closeable)((Object)this.cl)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.log.info((Object)("Undeployed: " + this.deployment.toExternalForm()));
    }
}

