/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.spi.deployers.Deployment;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.spi.ResourceAdapter;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.mdr.NotFoundException;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.logging.Logger;

public abstract class AbstractFungalDeployment
implements Deployment {
    protected Logger log;
    protected URL deployment;
    protected String deploymentName;
    protected boolean activator;
    protected ResourceAdapter ra;
    protected JndiStrategy jndiStrategy;
    protected MetadataRepository mdr;
    protected Object[] cfs;
    protected String[] cfJndis;
    protected Object[] aos;
    protected String[] aoJndis;
    protected MBeanServer server;
    protected List<ObjectName> objectNames;
    protected ClassLoader cl;

    public AbstractFungalDeployment(URL deployment, String deploymentName, boolean activator, ResourceAdapter ra, JndiStrategy jndiStrategy, MetadataRepository metadataRepository, Object[] cfs, String[] cfJndis, Object[] aos, String[] aoJndis, MBeanServer server, List<ObjectName> objectNames, ClassLoader cl, Logger log) {
        this.deployment = deployment;
        this.deploymentName = deploymentName;
        this.activator = activator;
        this.ra = ra;
        this.jndiStrategy = jndiStrategy;
        this.mdr = metadataRepository;
        this.cfs = cfs;
        this.cfJndis = cfJndis;
        this.aos = aos;
        this.aoJndis = aoJndis;
        this.server = server;
        this.objectNames = objectNames;
        this.cl = cl;
        this.log = log;
    }

    public URL getURL() {
        return this.deployment;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public void stop() {
        if (this.activator) {
            String jndi;
            this.log.debug((Object)("Undeploying: " + this.deployment.toExternalForm()));
            if (this.server != null && this.objectNames != null) {
                for (ObjectName on : this.objectNames) {
                    try {
                        this.server.unregisterMBean(on);
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)"Exception during unregistering deployment", t);
                    }
                }
            }
            if (this.mdr != null && this.cfs != null && this.cfJndis != null) {
                for (int i = 0; i < this.cfs.length; ++i) {
                    try {
                        String cf = this.cfs[i].getClass().getName();
                        jndi = this.cfJndis[i];
                        this.mdr.unregisterJndiMapping(this.deployment.toExternalForm(), cf, jndi);
                        continue;
                    }
                    catch (NotFoundException nfe) {
                        this.log.warn((Object)"Exception during unregistering deployment", (Throwable)nfe);
                    }
                }
            }
            if (this.mdr != null && this.aos != null && this.aoJndis != null) {
                for (int i = 0; i < this.aos.length; ++i) {
                    try {
                        String ao = this.aos[i].getClass().getName();
                        jndi = this.aoJndis[i];
                        this.mdr.unregisterJndiMapping(this.deployment.toExternalForm(), ao, jndi);
                        continue;
                    }
                    catch (NotFoundException nfe) {
                        this.log.warn((Object)"Exception during unregistering deployment", (Throwable)nfe);
                    }
                }
            }
            if (this.cfs != null && this.cfJndis != null) {
                try {
                    this.jndiStrategy.unbindConnectionFactories(this.deploymentName, this.cfs, this.cfJndis);
                }
                catch (Throwable t) {
                    this.log.warn((Object)"Exception during JNDI unbinding", t);
                }
            }
            if (this.aos != null && this.aoJndis != null) {
                try {
                    this.jndiStrategy.unbindAdminObjects(this.deploymentName, this.aos, this.aoJndis);
                }
                catch (Throwable t) {
                    this.log.warn((Object)"Exception during JNDI unbinding", t);
                }
            }
            if (this.ra != null) {
                this.ra.stop();
                this.ra = null;
            }
        }
    }

    public void destroy() {
        if (this.cl != null && this.cl instanceof Closeable) {
            try {
                ((Closeable)((Object)this.cl)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.activator) {
            this.log.info((Object)("Undeployed: " + this.deployment.toExternalForm()));
        }
    }
}

