/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.Kernel;
import com.github.fungal.api.util.Injection;
import com.github.fungal.api.util.JMX;
import com.github.fungal.api.util.JarFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.ra16.ConfigProperty16;
import org.jboss.jca.core.management.AdminObject;
import org.jboss.jca.core.management.ManagedConnectionFactory;
import org.jboss.jca.core.management.ResourceAdapter;
import org.jboss.jca.core.spi.mdr.AlreadyExistsException;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.deployers.common.AbstractResourceAdapterDeployer;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.jca.deployers.fungal.RAConfiguration;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.logging.Logger;

public abstract class AbstractFungalRADeployer
extends AbstractResourceAdapterDeployer {
    protected Kernel kernel = null;

    public AbstractFungalRADeployer(boolean validateClasses, Logger log) {
        super(validateClasses, log);
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public void start() {
        super.start();
        if (this.kernel == null) {
            throw new IllegalStateException("Kernel not defined");
        }
    }

    public Object initAndInject(String className, List<? extends ConfigProperty> configs, ClassLoader cl) throws DeployException {
        try {
            Class<?> clz = Class.forName(className, true, cl);
            Object o = clz.newInstance();
            if (configs != null) {
                Injection injector = new Injection();
                for (ConfigProperty configProperty : configs) {
                    ConfigProperty16 cpmd16;
                    if (!configProperty.isValueSet()) continue;
                    boolean setValue = true;
                    if (configProperty instanceof ConfigProperty16 && (cpmd16 = (ConfigProperty16)configProperty).getConfigPropertyIgnore() != null && cpmd16.getConfigPropertyIgnore().booleanValue()) {
                        setValue = false;
                    }
                    if (!setValue) continue;
                    injector.inject(configProperty.getConfigPropertyType().getValue(), configProperty.getConfigPropertyName().getValue(), configProperty.getConfigPropertyValue().getValue(), o);
                }
            }
            return o;
        }
        catch (Throwable t) {
            throw new DeployException("Deployment " + className + " failed", t);
        }
    }

    protected URL[] getUrls(File directory) throws MalformedURLException, IOException {
        LinkedList<URL> list = new LinkedList<URL>();
        if (directory.exists() && directory.isDirectory()) {
            list.add(directory.toURI().toURL());
            File[] jars = directory.listFiles((FilenameFilter)new JarFilter());
            if (jars != null) {
                for (int j = 0; j < jars.length; ++j) {
                    list.add(jars[j].getCanonicalFile().toURI().toURL());
                }
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    public String[] bindConnectionFactory(URL url, String deployment, Object cf) throws Throwable {
        JndiStrategy js = ((RAConfiguration)this.getConfiguration()).getJndiStrategy().clone();
        String[] result = js.bindConnectionFactories(deployment, new Object[]{cf});
        ((RAConfiguration)this.getConfiguration()).getMetadataRepository().registerJndiMapping(url.toExternalForm(), cf.getClass().getName(), result[0]);
        return result;
    }

    public String[] bindConnectionFactory(URL url, String deployment, Object cf, String jndi) throws Throwable {
        JndiStrategy js = ((RAConfiguration)this.getConfiguration()).getJndiStrategy().clone();
        String[] result = js.bindConnectionFactories(deployment, new Object[]{cf}, new String[]{jndi});
        ((RAConfiguration)this.getConfiguration()).getMetadataRepository().registerJndiMapping(url.toExternalForm(), cf.getClass().getName(), jndi);
        return result;
    }

    public String[] bindAdminObject(URL url, String deployment, Object ao) throws Throwable {
        JndiStrategy js = ((RAConfiguration)this.getConfiguration()).getJndiStrategy().clone();
        String[] result = js.bindAdminObjects(deployment, new Object[]{ao});
        ((RAConfiguration)this.getConfiguration()).getMetadataRepository().registerJndiMapping(url.toExternalForm(), ao.getClass().getName(), result[0]);
        return result;
    }

    public String[] bindAdminObject(URL url, String deployment, Object ao, String jndi) throws Throwable {
        JndiStrategy js = ((RAConfiguration)this.getConfiguration()).getJndiStrategy().clone();
        String[] result = js.bindAdminObjects(deployment, new Object[]{ao}, new String[]{jndi});
        ((RAConfiguration)this.getConfiguration()).getMetadataRepository().registerJndiMapping(url.toExternalForm(), ao.getClass().getName(), jndi);
        return result;
    }

    protected File getReportDirectory() {
        return new File(SecurityActions.getSystemProperty("iron.jacamar.home"), "/log/");
    }

    protected boolean checkConfigurationIsValid() {
        return this.getConfiguration() != null && this.getConfiguration() instanceof RAConfiguration;
    }

    protected PrintWriter getLogPrintWriter() {
        return new PrintWriter(((RAConfiguration)this.getConfiguration()).getPrintStream());
    }

    protected TransactionManager getTransactionManager() {
        return ((RAConfiguration)this.getConfiguration()).getTransactionManager();
    }

    protected void registerResourceAdapterToMDR(URL url, File root, Connector cmd, IronJacamar ijmd) throws AlreadyExistsException {
        ((RAConfiguration)this.getConfiguration()).getMetadataRepository().registerResourceAdapter(url.toExternalForm(), root, cmd, ijmd);
    }

    protected List<ObjectName> registerManagementView(org.jboss.jca.core.management.Connector mgtConnector, MBeanServer server) throws JMException {
        if (server == null) {
            throw new IllegalArgumentException("MBeanServer is null");
        }
        ArrayList<ObjectName> ons = new ArrayList<ObjectName>();
        if (mgtConnector != null) {
            String mgtCpName;
            HashSet<String> excludeAttributes;
            HashSet<String> writeable;
            ResourceAdapter mgtRa;
            String baseName = server.getDefaultDomain() + ":deployment=" + mgtConnector.getUniqueId();
            if (mgtConnector.getResourceAdapter() != null && (mgtRa = mgtConnector.getResourceAdapter()).getResourceAdapter() != null) {
                HashSet<String> writeable2 = new HashSet<String>();
                HashSet<String> excludeAttributes2 = new HashSet<String>();
                for (org.jboss.jca.core.management.ConfigProperty mgtCp : mgtRa.getConfigProperties()) {
                    String mgtCpName2 = mgtCp.getName().substring(0, 1).toUpperCase(Locale.US);
                    if (mgtCp.getName().length() > 1) {
                        mgtCpName2 = mgtCpName2 + mgtCp.getName().substring(1);
                    }
                    if (mgtCp.isDynamic()) {
                        writeable2.add(mgtCpName2);
                    }
                    if (!mgtCp.isConfidential()) continue;
                    excludeAttributes2.add(mgtCpName2);
                }
                String raName = baseName + ",type=ResourceAdapter,class=" + this.getClassName(mgtRa.getResourceAdapter().getClass().getName());
                DynamicMBean raDMB = JMX.createMBean((Object)mgtRa.getResourceAdapter(), (String)"Resource adapter", writeable2, null, excludeAttributes2, null);
                ObjectName raON = new ObjectName(raName);
                server.registerMBean(raDMB, raON);
                ons.add(raON);
            }
            for (ManagedConnectionFactory mgtMcf : mgtConnector.getManagedConnectionFactories()) {
                if (mgtMcf.getManagedConnectionFactory() != null) {
                    writeable = new HashSet<String>();
                    excludeAttributes = new HashSet<String>();
                    for (org.jboss.jca.core.management.ConfigProperty mgtCp : mgtMcf.getConfigProperties()) {
                        mgtCpName = mgtCp.getName().substring(0, 1).toUpperCase(Locale.US);
                        if (mgtCp.getName().length() > 1) {
                            mgtCpName = mgtCpName + mgtCp.getName().substring(1);
                        }
                        if (mgtCp.isDynamic()) {
                            writeable.add(mgtCpName);
                        }
                        if (!mgtCp.isConfidential()) continue;
                        excludeAttributes.add(mgtCpName);
                    }
                    String mcfName = baseName + ",type=ManagedConnectionFactory,class=" + this.getClassName(mgtMcf.getManagedConnectionFactory().getClass().getName());
                    DynamicMBean mcfDMB = JMX.createMBean((Object)mgtMcf.getManagedConnectionFactory(), (String)"Managed connection factory", writeable, null, excludeAttributes, null);
                    ObjectName mcfON = new ObjectName(mcfName);
                    server.registerMBean(mcfDMB, mcfON);
                    ons.add(mcfON);
                }
                if (mgtMcf.getPoolConfiguration() != null) {
                    String mcfPCName = baseName + ",type=ManagedConnectionFactory,class=" + this.getClassName(mgtMcf.getManagedConnectionFactory().getClass().getName()) + ",subcategory=PoolConfiguration";
                    DynamicMBean mcfPCDMB = JMX.createMBean((Object)mgtMcf.getPoolConfiguration(), (String)"Pool configuration");
                    ObjectName mcfPCON = new ObjectName(mcfPCName);
                    server.registerMBean(mcfPCDMB, mcfPCON);
                    ons.add(mcfPCON);
                }
                if (mgtMcf.getPool() == null) continue;
                String mcfPName = baseName + ",type=ManagedConnectionFactory,class=" + this.getClassName(mgtMcf.getManagedConnectionFactory().getClass().getName()) + ",subcategory=Pool";
                DynamicMBean mcfPDMB = JMX.createMBean((Object)mgtMcf.getPool(), (String)"Pool");
                ObjectName mcfPON = new ObjectName(mcfPName);
                server.registerMBean(mcfPDMB, mcfPON);
                ons.add(mcfPON);
            }
            for (AdminObject mgtAo : mgtConnector.getAdminObjects()) {
                if (mgtAo.getAdminObject() == null) continue;
                writeable = new HashSet();
                excludeAttributes = new HashSet();
                for (org.jboss.jca.core.management.ConfigProperty mgtCp : mgtAo.getConfigProperties()) {
                    mgtCpName = mgtCp.getName().substring(0, 1).toUpperCase(Locale.US);
                    if (mgtCp.getName().length() > 1) {
                        mgtCpName = mgtCpName + mgtCp.getName().substring(1);
                    }
                    if (mgtCp.isDynamic()) {
                        writeable.add(mgtCpName);
                    }
                    if (!mgtCp.isConfidential()) continue;
                    excludeAttributes.add(mgtCpName);
                }
                String aoName = baseName + ",type=AdminObject,class=" + this.getClassName(mgtAo.getAdminObject().getClass().getName());
                DynamicMBean aoDMB = JMX.createMBean((Object)mgtAo.getAdminObject(), (String)"Admin object", writeable, null, excludeAttributes, null);
                ObjectName aoON = new ObjectName(aoName);
                server.registerMBean(aoDMB, aoON);
                ons.add(aoON);
            }
        }
        return ons;
    }

    private String getClassName(String clz) {
        if (clz.indexOf(".") != -1) {
            int lastIndex = clz.lastIndexOf(".");
            return clz.substring(lastIndex + 1);
        }
        return clz;
    }
}

