/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.Kernel;
import com.github.fungal.api.util.Injection;
import com.github.fungal.api.util.JMX;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.Deployment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.metadata.ds.DsParser;
import org.jboss.jca.core.api.management.DataSource;
import org.jboss.jca.core.naming.ExplicitJndiStrategy;
import org.jboss.jca.deployers.common.AbstractDsDeployer;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.jca.deployers.fungal.DsXmlDeployment;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.security.SubjectFactory;

public final class DsXmlDeployer
extends AbstractDsDeployer
implements Deployer {
    private String jdbcLocal = null;
    private String jdbcXA = null;
    private Kernel kernel = null;

    public DsXmlDeployer() {
        super(Logger.getLogger(DsXmlDeployer.class));
    }

    public void setJDBCLocal(String value) {
        this.jdbcLocal = value;
    }

    public String getJDBCLocal() {
        return this.jdbcLocal;
    }

    public void setJDBCXA(String value) {
        this.jdbcXA = value;
    }

    public String getJDBCXA() {
        return this.jdbcXA;
    }

    public void setKernel(Kernel value) {
        this.kernel = value;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public synchronized Deployment deploy(URL url, ClassLoader parent) throws com.github.fungal.spi.deployers.DeployException {
        if (url == null || !url.toExternalForm().endsWith("-ds.xml")) {
            return null;
        }
        this.log.debug((Object)("Deploying: " + url.toExternalForm()));
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        InputStream is = null;
        try {
            File f = new File(url.toURI());
            if (!f.exists()) {
                throw new IOException("Deployment " + url.toExternalForm() + " doesnt exists");
            }
            is = new FileInputStream(f);
            DsParser dsParser = new DsParser();
            DataSources dataSources = dsParser.parse(is);
            String deploymentName = f.getName();
            Set raDeployments = this.mdr.getResourceAdapters();
            String uniqueJdbcLocalId = null;
            String uniqueJdbcXAId = null;
            for (String s : raDeployments) {
                if (s.endsWith(this.jdbcLocal)) {
                    URL urlJdbcLocal = new URL(s);
                    uniqueJdbcLocalId = urlJdbcLocal.toExternalForm();
                    continue;
                }
                if (!s.endsWith(this.jdbcXA)) continue;
                URL urlJdbcXA = new URL(s);
                uniqueJdbcXAId = urlJdbcXA.toExternalForm();
            }
            CommonDeployment c = this.createObjectsAndInjectValue(url, deploymentName, uniqueJdbcLocalId, uniqueJdbcXAId, dataSources, parent);
            List<ObjectName> onames = this.registerManagementView(c.getDataSources(), this.kernel.getMBeanServer());
            DsXmlDeployment dsXmlDeployment = new DsXmlDeployment(c.getURL(), c.getDeploymentName(), c.getCfs(), c.getCfJndiNames(), c.getRecovery(), this.getXAResourceRecoveryRegistry(), c.getDataSources(), this.getManagementRepository(), onames, this.kernel.getMBeanServer(), c.getCl());
            return dsXmlDeployment;
        }
        catch (com.github.fungal.spi.deployers.DeployException de) {
            throw de;
        }
        catch (Throwable t) {
            throw new com.github.fungal.spi.deployers.DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    public Object initAndInject(String className, List<? extends ConfigProperty> configs, ClassLoader cl) throws DeployException {
        try {
            Class<?> clz = Class.forName(className, true, cl);
            Object o = clz.newInstance();
            if (configs != null) {
                Injection injector = new Injection();
                for (ConfigProperty configProperty : configs) {
                    if (!configProperty.isValueSet()) continue;
                    injector.inject(o, configProperty.getConfigPropertyName().getValue(), (Object)configProperty.getConfigPropertyValue().getValue(), configProperty.getConfigPropertyType().getValue());
                }
            }
            return o;
        }
        catch (Throwable t) {
            throw new DeployException("Deployment " + className + " failed", t);
        }
    }

    protected String[] bindConnectionFactory(String deployment, String jndi, Object cf) throws Throwable {
        ExplicitJndiStrategy js = new ExplicitJndiStrategy();
        String[] result = js.bindConnectionFactories(deployment, new Object[]{cf}, new String[]{jndi});
        this.log.infof("Bound data source at: %s", (Object)jndi);
        return result;
    }

    public void start() {
        if (this.transactionIntegration == null) {
            throw new IllegalStateException("TransactionIntegration not defined");
        }
        if (this.mdr == null) {
            throw new IllegalStateException("MetadataRepository not defined");
        }
        if (this.kernel == null) {
            throw new IllegalStateException("Kernel not defined");
        }
        if (this.jdbcLocal == null) {
            throw new IllegalStateException("JDBCLocal not defined");
        }
        if (this.jdbcXA == null) {
            throw new IllegalStateException("JDBCXA not defined");
        }
    }

    protected ClassLoader getDeploymentClassLoader(String uniqueId) {
        try {
            URL urlJdbc = new URL(uniqueId);
            return this.kernel.getDeployment(urlJdbc).getClassLoader();
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    protected SubjectFactory getSubjectFactory(String securityDomain) throws DeployException {
        this.log.tracef("getSubjectFactory(%s)", (Object)securityDomain);
        if (securityDomain == null || securityDomain.trim().equals("")) {
            return null;
        }
        try {
            return (SubjectFactory)this.kernel.getBean(securityDomain, SubjectFactory.class);
        }
        catch (Throwable t) {
            throw new DeployException("Error during loookup of security domain: " + securityDomain, t);
        }
    }

    private List<ObjectName> registerManagementView(DataSource[] mgtDses, MBeanServer server) throws JMException {
        if (server == null) {
            throw new IllegalArgumentException("MBeanServer is null");
        }
        ArrayList<ObjectName> ons = new ArrayList<ObjectName>();
        if (mgtDses != null) {
            for (DataSource mgtDs : mgtDses) {
                String jndiName = mgtDs.getJndiName();
                if (jndiName.indexOf("/") != -1) {
                    jndiName = jndiName.substring(jndiName.lastIndexOf("/") + 1);
                }
                String baseName = server.getDefaultDomain() + ":deployment=" + jndiName;
                if (mgtDs.getPoolConfiguration() != null) {
                    String dsPCName = baseName + ",type=PoolConfigutation";
                    DynamicMBean dsPCDMB = JMX.createMBean((Object)mgtDs.getPoolConfiguration(), (String)"Pool configuration");
                    ObjectName dsPCON = new ObjectName(dsPCName);
                    server.registerMBean(dsPCDMB, dsPCON);
                    ons.add(dsPCON);
                }
                if (mgtDs.getPool() == null) continue;
                String dsPName = baseName + ",type=Pool";
                DynamicMBean dsPDMB = JMX.createMBean((Object)mgtDs.getPool(), (String)"Pool");
                ObjectName dsPON = new ObjectName(dsPName);
                server.registerMBean(dsPDMB, dsPON);
                ons.add(dsPON);
            }
        }
        return ons;
    }
}

