/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.classloading.ClassLoaderFactory;
import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.DeployerOrder;
import com.github.fungal.spi.deployers.DeployerPhases;
import com.github.fungal.spi.deployers.Deployment;
import com.github.fungal.spi.deployers.MultiStageDeployer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.jca.common.api.metadata.common.CommonIronJacamar;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapters;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.common.metadata.resourceadapter.ResourceAdapterParser;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.jca.deployers.fungal.AbstractFungalRADeployer;
import org.jboss.jca.deployers.fungal.RAConfiguration;
import org.jboss.jca.deployers.fungal.RaXmlDeployment;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.logging.Logger;

public final class RaXmlDeployer
extends AbstractFungalRADeployer
implements Deployer,
MultiStageDeployer,
DeployerOrder,
DeployerPhases {
    private static Logger log = Logger.getLogger(RaXmlDeployer.class);
    private List<Deployment> deployments;

    public RaXmlDeployer() {
        super(false, log);
    }

    public int getOrder() {
        return 0;
    }

    public void preDeploy() throws Throwable {
    }

    public void postDeploy() throws Throwable {
    }

    public void preUndeploy() throws Throwable {
        if (this.deployments != null) {
            for (Deployment raDeployment : this.deployments) {
                try {
                    this.kernel.getMainDeployer().unregisterDeployment(raDeployment);
                }
                catch (Throwable t) {
                    log.warn((Object)("Error during undeployment of " + raDeployment.getURL()));
                }
            }
            this.deployments = null;
        }
    }

    public void postUndeploy() throws Throwable {
    }

    public synchronized Deployment deploy(URL url, ClassLoader parent) throws com.github.fungal.spi.deployers.DeployException {
        if (url == null || !url.toExternalForm().endsWith("-ra.xml")) {
            return null;
        }
        log.debug((Object)("Deploying: " + url.toExternalForm()));
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        InputStream is = null;
        try {
            File f = new File(url.toURI());
            if (!f.exists()) {
                throw new IOException("Archive " + url.toExternalForm() + " doesnt exists");
            }
            ResourceAdapterParser parser = new ResourceAdapterParser();
            is = new FileInputStream(f);
            ResourceAdapters raXmlDeployment = parser.parse(is);
            int size = raXmlDeployment.getResourceAdapters().size();
            if (size == 1) {
                Deployment deployment = this.doDeploy(url, (ResourceAdapter)raXmlDeployment.getResourceAdapters().get(0), parent);
                return deployment;
            }
            this.deployments = new ArrayList<Deployment>(size);
            for (ResourceAdapter raxml : raXmlDeployment.getResourceAdapters()) {
                Deployment raDeployment = this.doDeploy(url, raxml, parent);
                if (raDeployment == null) continue;
                this.deployments.add(raDeployment);
                this.kernel.getMainDeployer().registerDeployment(raDeployment);
            }
            Deployment deployment = null;
            return deployment;
        }
        catch (com.github.fungal.spi.deployers.DeployException de) {
            throw de;
        }
        catch (Throwable t) {
            throw new com.github.fungal.spi.deployers.DeployException("Exception during deployment of " + url.toExternalForm(), t);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    private Deployment doDeploy(URL url, ResourceAdapter raxml, ClassLoader parent) throws com.github.fungal.spi.deployers.DeployException {
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        try {
            String archive = raxml.getArchive();
            URL deployment = null;
            Set deployments = ((RAConfiguration)this.getConfiguration()).getMetadataRepository().getResourceAdapters();
            for (String s : deployments) {
                if (!s.endsWith(archive)) continue;
                deployment = new URL(s);
            }
            if (deployment == null) {
                throw new com.github.fungal.spi.deployers.DeployException("Archive " + archive + " couldn't be resolved in " + url.toExternalForm());
            }
            MetadataRepository mdr = ((RAConfiguration)this.getConfiguration()).getMetadataRepository();
            Connector cmd = mdr.getResourceAdapter(deployment.toExternalForm());
            IronJacamar ijmd = mdr.getIronJacamar(deployment.toExternalForm());
            File root = mdr.getRoot(deployment.toExternalForm());
            cmd = new Merger().mergeConnectorWithCommonIronJacamar((CommonIronJacamar)raxml, cmd);
            URL[] urls = this.getUrls(root);
            KernelClassLoader cl = null;
            cl = ((RAConfiguration)this.getConfiguration()).getScopeDeployment() ? ClassLoaderFactory.create((int)1, (URL[])urls, (ClassLoader)parent) : ClassLoaderFactory.create((int)0, (URL[])urls, (ClassLoader)parent);
            SecurityActions.setThreadContextClassLoader((ClassLoader)cl);
            String deploymentName = archive.substring(0, archive.indexOf(".rar"));
            CommonDeployment c = this.createObjectsAndInjectValue(url, deploymentName, root, (ClassLoader)cl, cmd, ijmd, raxml);
            List<ObjectName> ons = null;
            if (c.isActivateDeployment()) {
                ons = this.registerManagementView(c.getConnector(), this.kernel.getMBeanServer());
            }
            JndiStrategy jndiStrategy = ((RAConfiguration)this.getConfiguration()).getJndiStrategy();
            MetadataRepository metadataRepository = ((RAConfiguration)this.getConfiguration()).getMetadataRepository();
            ResourceAdapterRepository resourceAdapterRepository = ((RAConfiguration)this.getConfiguration()).getResourceAdapterRepository();
            RaXmlDeployment raXmlDeployment = new RaXmlDeployment(c.getURL(), deployment, c.getDeploymentName(), c.getResourceAdapter(), c.getResourceAdapterKey(), jndiStrategy, metadataRepository, resourceAdapterRepository, c.getCfs(), c.getCfJndiNames(), c.getAos(), c.getAoJndiNames(), c.getRecovery(), this.getTransactionIntegration().getRecoveryRegistry(), ((RAConfiguration)this.getConfiguration()).getManagementRepository(), c.getConnector(), this.kernel.getMBeanServer(), ons, c.getCl(), c.getLog());
            return raXmlDeployment;
        }
        catch (com.github.fungal.spi.deployers.DeployException de) {
            throw de;
        }
        catch (DeployException cde) {
            throw new com.github.fungal.spi.deployers.DeployException(cde.getMessage(), cde.getCause());
        }
        catch (Throwable t) {
            throw new com.github.fungal.spi.deployers.DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    protected boolean checkActivation(Connector cmd, IronJacamar ijmd) {
        return true;
    }
}

