/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.spi.deployers.Deployment;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.spi.ResourceAdapter;
import org.jboss.jca.core.api.management.Connector;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.mdr.NotFoundException;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecoveryRegistry;
import org.jboss.jca.deployers.DeployersLogger;

public abstract class AbstractFungalDeployment
implements Deployment {
    protected DeployersLogger log;
    protected URL deployment;
    protected String deploymentName;
    protected boolean activator;
    protected ResourceAdapter ra;
    protected String raKey;
    protected JndiStrategy jndiStrategy;
    protected MetadataRepository mdr;
    protected ResourceAdapterRepository rar;
    protected Object[] cfs;
    protected String[] cfJndis;
    protected Object[] aos;
    protected String[] aoJndis;
    protected XAResourceRecovery[] recoveryModules;
    protected XAResourceRecoveryRegistry recoveryRegistry;
    protected ManagementRepository managementRepository;
    protected Connector connector;
    protected MBeanServer server;
    protected List<ObjectName> objectNames;
    protected ClassLoader cl;

    public AbstractFungalDeployment(URL deployment, String deploymentName, boolean activator, ResourceAdapter ra, String raKey, JndiStrategy jndiStrategy, MetadataRepository metadataRepository, ResourceAdapterRepository resourceAdapterRepository, Object[] cfs, String[] cfJndis, Object[] aos, String[] aoJndis, XAResourceRecovery[] recoveryModules, XAResourceRecoveryRegistry recoveryRegistry, ManagementRepository managementRepository, Connector connector, MBeanServer server, List<ObjectName> objectNames, ClassLoader cl, DeployersLogger log) {
        this.deployment = deployment;
        this.deploymentName = deploymentName;
        this.activator = activator;
        this.ra = ra;
        this.raKey = raKey;
        this.jndiStrategy = jndiStrategy;
        this.mdr = metadataRepository;
        this.rar = resourceAdapterRepository;
        this.cfs = cfs;
        this.cfJndis = cfJndis;
        this.aos = aos;
        this.aoJndis = aoJndis;
        this.recoveryModules = recoveryModules;
        this.recoveryRegistry = recoveryRegistry;
        this.managementRepository = managementRepository;
        this.connector = connector;
        this.server = server;
        this.objectNames = objectNames;
        this.cl = cl;
        this.log = log;
    }

    public URL getURL() {
        return this.deployment;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public void stop() {
        if (this.activator) {
            this.log.debug((Object)("Undeploying: " + this.deployment.toExternalForm()));
            if (this.server != null && this.objectNames != null) {
                for (ObjectName on : this.objectNames) {
                    try {
                        this.server.unregisterMBean(on);
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)"Exception during unregistering deployment", t);
                    }
                }
            }
            if (this.recoveryRegistry != null && this.recoveryModules != null) {
                for (XAResourceRecovery recovery : this.recoveryModules) {
                    this.recoveryRegistry.removeXAResourceRecovery(recovery);
                }
            }
            if (this.managementRepository != null && this.connector != null) {
                this.managementRepository.getConnectors().remove(this.connector);
            }
            if (this.mdr != null && this.cfs != null && this.cfJndis != null) {
                for (int i = 0; i < this.cfs.length; ++i) {
                    try {
                        String cf = this.cfs[i].getClass().getName();
                        String jndi = this.cfJndis[i];
                        this.mdr.unregisterJndiMapping(this.deployment.toExternalForm(), cf, jndi);
                        continue;
                    }
                    catch (NotFoundException nfe) {
                        this.log.warn((Object)"Exception during unregistering deployment", (Throwable)nfe);
                    }
                }
            }
            if (this.mdr != null && this.aos != null && this.aoJndis != null) {
                for (int i = 0; i < this.aos.length; ++i) {
                    try {
                        String ao = this.aos[i].getClass().getName();
                        String jndi = this.aoJndis[i];
                        this.mdr.unregisterJndiMapping(this.deployment.toExternalForm(), ao, jndi);
                        continue;
                    }
                    catch (NotFoundException nfe) {
                        this.log.warn((Object)"Exception during unregistering deployment", (Throwable)nfe);
                    }
                }
            }
            if (this.cfs != null && this.cfJndis != null) {
                try {
                    this.jndiStrategy.unbindConnectionFactories(this.deploymentName, this.cfs, this.cfJndis);
                    for (String jndi : this.cfJndis) {
                        this.log.infof("Unbound connection factory at: %s", (Object)jndi);
                    }
                }
                catch (Throwable t) {
                    this.log.warn((Object)"Exception during JNDI unbinding", t);
                }
            }
            if (this.aos != null && this.aoJndis != null) {
                try {
                    this.jndiStrategy.unbindAdminObjects(this.deploymentName, this.aos, this.aoJndis);
                    for (String jndi : this.aoJndis) {
                        this.log.infof("Unbound admin object at: %s", (Object)jndi);
                    }
                }
                catch (Throwable t) {
                    this.log.warn((Object)"Exception during JNDI unbinding", t);
                }
            }
            if (this.raKey != null && this.rar != null) {
                try {
                    this.rar.unregisterResourceAdapter(this.raKey);
                }
                catch (org.jboss.jca.core.spi.rar.NotFoundException nfe) {
                    this.log.warn((Object)"Exception during unregistering deployment", (Throwable)nfe);
                }
            }
            if (this.ra != null) {
                this.ra.stop();
                this.ra = null;
            }
        }
    }

    public void destroy() {
        if (this.cl != null && this.cl instanceof Closeable) {
            try {
                ((Closeable)((Object)this.cl)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.activator) {
            this.log.info((Object)("Undeployed: " + this.deployment.toExternalForm()));
        }
    }
}

