/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.spi.ResourceAdapter;
import org.jboss.jca.core.api.management.Connector;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecoveryRegistry;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.fungal.AbstractFungalDeployment;

public class RADeployment
extends AbstractFungalDeployment {
    private File tmpDirectory;

    public RADeployment(URL deployment, String deploymentName, boolean activator, ResourceAdapter ra, String raKey, JndiStrategy jndiStrategy, MetadataRepository mdr, ResourceAdapterRepository resourceAdapterRepository, Object[] cfs, String[] cfJndis, ConnectionManager[] cfCMs, Object[] aos, String[] aoJndis, XAResourceRecovery[] recoveryModules, XAResourceRecoveryRegistry recoveryRegistry, File tmpDirectory, ManagementRepository managementRepository, Connector connector, MBeanServer server, List<ObjectName> objectNames, ClassLoader cl, DeployersLogger log) {
        super(deployment, deploymentName, activator, ra, raKey, jndiStrategy, mdr, resourceAdapterRepository, cfs, cfJndis, cfCMs, aos, aoJndis, recoveryModules, recoveryRegistry, managementRepository, connector, server, objectNames, cl, log);
        this.tmpDirectory = tmpDirectory;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.mdr != null) {
            try {
                this.mdr.unregisterResourceAdapter(this.deployment.toExternalForm());
            }
            catch (Throwable t) {
                this.log.warn((Object)"Exception during unregistering deployment in the metadata repository", t);
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.tmpDirectory != null && this.tmpDirectory.exists()) {
            try {
                FileUtil fu = new FileUtil();
                fu.delete(this.tmpDirectory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

